/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.WebResponseHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessagePushServiceImpl
implements MessagePushService {
    private static final Logger log = LoggerFactory.getLogger(MessagePushServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WebResponse<?> handle(MessageDto message) {
        block6: {
            log.info("handle - message from app to wechat - message:{}", (Object)message);
            try {
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(message.getOrgId());
                if (message.getMsgT().intValue() == MsgType.TEXT.getValue()) {
                    this.handleTextMessage(authorizationInfo, message);
                    break block6;
                }
                if (message.getMsgT().intValue() == MsgType.PICTURE.getValue()) {
                    this.handleImageMessage(authorizationInfo, message);
                    break block6;
                }
                if (message.getMsgT().intValue() == MsgType.VOICE.getValue()) {
                    this.handleVoiceMessage(authorizationInfo, message);
                    break block6;
                }
                return WebResponseHelper.error((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_NONSUUPORT_TYPE);
            }
            catch (BussinessException | WebServiceException | WechatException e) {
                log.warn("handle - message from app to wechat - CustomException - message:{},e", (Object)message, (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("handle - message from app to wechat - Exception - message:{}", (Object)message);
                log.error("handle - message from app to wechat - Exception - e", (Throwable)e);
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_FAIL);
            }
        }
        return WebResponseHelper.success();
    }

    void handleTextMessage(AuthorizationInfo authorizationInfo, MessageDto message) {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        CustomerServiceApiHelper.sendTextMsg(accessToken, openId, content.getText() != null ? content.getText() : "null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleImageMessage(AuthorizationInfo authorizationInfo, MessageDto message) throws Exception {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        File localFile = null;
        try {
            OrgStorage orgStorage = this.orgStorageDao.getById(content.getStorageId().intValue());
            byte[] data = HttpClientUtils.download((String)StorageUtil.constructUrl(orgStorage));
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.getMimeType((Integer)orgStorage.getMimeType()));
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.IMAGE, localFile);
            CustomerServiceApiHelper.sendImageMsg(accessToken, openId, mediaApiDto.getMediaId());
            if (localFile == null) return;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (localFile == null) throw throwable;
                LocalFileHelper.deleteFile(localFile);
                throw throwable;
            }
        }
        LocalFileHelper.deleteFile(localFile);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleVoiceMessage(AuthorizationInfo authorizationInfo, MessageDto message) throws Exception {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        File localFile = null;
        try {
            OrgStorage orgStorage = this.orgStorageDao.getById(content.getStorageId().intValue());
            byte[] data = HttpClientUtils.download((String)StorageUtil.constructUrl(orgStorage));
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.getMimeType((Integer)orgStorage.getMimeType()));
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.VOICE, localFile);
            CustomerServiceApiHelper.sendVoiceMsg(accessToken, openId, mediaApiDto.getMediaId());
            if (localFile == null) return;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (localFile == null) throw throwable;
                LocalFileHelper.deleteFile(localFile);
                throw throwable;
            }
        }
        LocalFileHelper.deleteFile(localFile);
        return;
    }
}

