/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassiveReplyMsgHelper {
    private static final Logger log = LoggerFactory.getLogger(PassiveReplyMsgHelper.class);

    public static String getSubscribeReply(String fromUser, String toUser, OrgWechatReplyForSubscribe reply) {
        String result = "success";
        if (reply == null) {
            return result;
        }
        try {
            MediaType type = MediaType.getByVaule(reply.getMediaType());
            if (MediaType.UNKNOWN == type) {
                return result;
            }
            if (MediaType.IMAGE == type) {
                if (StringUtils.isNotBlank((CharSequence)reply.getMediaId())) {
                    result = PassiveReplyMsgBuilder.imageMsg(fromUser, toUser, reply.getMediaId());
                }
            } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type && MediaType.NEWS != type) {
                if (MediaType.CONTENT == type) {
                    if (StringUtils.isNotBlank((CharSequence)reply.getContent())) {
                        result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, reply.getContent());
                    }
                } else if ((MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) && StringUtils.isNotBlank((CharSequence)reply.getUrl())) {
                    String fmt = "\u3010%s\u3011\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, fmt);
                }
            }
        }
        catch (Exception e) {
            log.error("wechat - PassiveReplyMsgHelper - sendSubscribeReply fail - fromUser:{}, toUser:{}, reply:{}", new Object[]{fromUser, toUser, reply});
        }
        return result;
    }

    public static String getKeywordReply(String fromUser, String toUser, OrgWechatReplyForKeyword reply) {
        String result = "success";
        if (reply == null) {
            return result;
        }
        try {
            MediaType type = MediaType.getByVaule(reply.getMediaType());
            if (MediaType.UNKNOWN == type) {
                return result;
            }
            if (MediaType.IMAGE == type) {
                if (StringUtils.isNotBlank((CharSequence)reply.getMediaId())) {
                    result = PassiveReplyMsgBuilder.imageMsg(fromUser, toUser, reply.getMediaId());
                }
            } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type && MediaType.NEWS != type) {
                if (MediaType.CONTENT == type) {
                    if (StringUtils.isNotBlank((CharSequence)reply.getContent())) {
                        result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, reply.getContent());
                    }
                } else if ((MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) && StringUtils.isNotBlank((CharSequence)reply.getUrl())) {
                    String fmt = "\u3010%s\u3011\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, fmt);
                }
            }
        }
        catch (Exception e) {
            log.error("wechat - getKeywordReply - sendSubscribeReply fail - fromUser:{}, toUser:{}, reply:{}", new Object[]{fromUser, toUser, reply});
        }
        return result;
    }

    public static void main(String[] args) {
        String fmt = "\u3010%s\u3011\n\n%s";
        fmt = String.format(fmt, "haha", "xxx");
        System.out.println(fmt);
    }
}

