/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QRCodeSceneStr {
    private static final String SEPARATOR = "_";
    private static final String EQUAL = "=";
    private static final String JSON_KEY_QRCODE_TYPE = "qr";
    protected QRCodeType qrCodeType;

    private void setQrCodeType(QRCodeType qrCodeType) {
    }

    public String getSceneStr() {
        return QRCodeSceneStr.createSceneStrParam(JSON_KEY_QRCODE_TYPE, this.qrCodeType.getValue());
    }

    public static QRCodeType parseQRCodeType(String str) {
        return QRCodeType.getByVaule(QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_QRCODE_TYPE));
    }

    protected static String createSceneStrParam(String key, Object value) {
        return String.format("%s%s%s%s", key, EQUAL, value, SEPARATOR);
    }

    protected static String parseSceneStrParam(String str, String key) {
        String pattenStr;
        Pattern pattern;
        Matcher matcher;
        if (!str.startsWith(SEPARATOR)) {
            str = SEPARATOR + str;
        }
        if ((matcher = (pattern = Pattern.compile(pattenStr = String.format("%s%s%s([^%s]*)", SEPARATOR, key, EQUAL, SEPARATOR))).matcher(str)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public QRCodeType getQrCodeType() {
        return this.qrCodeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QRCodeSceneStr)) {
            return false;
        }
        QRCodeSceneStr other = (QRCodeSceneStr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QRCodeType this$qrCodeType = this.getQrCodeType();
        QRCodeType other$qrCodeType = other.getQrCodeType();
        return !(this$qrCodeType == null ? other$qrCodeType != null : !((Object)((Object)this$qrCodeType)).equals((Object)other$qrCodeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QRCodeSceneStr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QRCodeType $qrCodeType = this.getQrCodeType();
        result = result * 59 + ($qrCodeType == null ? 43 : ((Object)((Object)$qrCodeType)).hashCode());
        return result;
    }

    public String toString() {
        return "QRCodeSceneStr(qrCodeType=" + (Object)((Object)this.getQrCodeType()) + ")";
    }
}

