/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.ComponentAccessToken;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.api.WebAuthService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthDto;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthorizationDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauth.WechatWebAuthHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebAuthServiceImpl
implements WebAuthService {
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;

    @Override
    @Transactional(value="yunyingTransactionManager", readOnly=true)
    public Fans getWechatUserByWebAuthCode(WebAuthDto webAuthDto) {
        Fans fans = null;
        OpenPlatformInfoDto platformInfo = WechatProperties.getOpenPlatformInfo();
        ComponentAccessToken compAccessToken = this.componentAccessTokenDao.getByAppId(platformInfo.getAppId());
        WebAuthorizationDto webAuthorizationDto = WechatWebAuthHelper.getWebAuthorization(webAuthDto.getAppid(), webAuthDto.getCode(), platformInfo.getAppId(), compAccessToken.getComponentAccessToken());
        if (webAuthorizationDto != null) {
            fans = WechatWebAuthHelper.getUserInfoByWebAuth(webAuthorizationDto.getAccessToken(), webAuthorizationDto.getOpenid());
        }
        return fans;
    }

    @Override
    @Transactional(readOnly=true)
    public WebAuthorizationDto getWebAuthorizationDtoByWebAuthCode(WebAuthDto webAuthDto) {
        OpenPlatformInfoDto platformInfo = WechatProperties.getOpenPlatformInfo();
        ComponentAccessToken compAccessToken = this.componentAccessTokenDao.getByAppId(platformInfo.getAppId());
        return WechatWebAuthHelper.getWebAuthorization(webAuthDto.getAppid(), webAuthDto.getCode(), platformInfo.getAppId(), compAccessToken.getComponentAccessToken());
    }

    @Override
    public String getFansinfoLink(Integer orgId, String landingPage) {
        AuthorizerInfo info = this.authorizerInfoDao.getByOrgId(orgId);
        return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, info.getAuthorizerAppId(), landingPage);
    }

    @Override
    public String getFansinfoLink4UserInfoScope(Integer orgId, String landingPage) {
        AuthorizerInfo info = this.authorizerInfoDao.getByOrgId(orgId);
        return WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.USERINFO, info.getAuthorizerAppId(), landingPage);
    }
}

