/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForKeywordDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatReplyForSubscribeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.emoticons.WechatEmoticons;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgType;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStr;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeSceneStrActivity;
import com.baijia.tianxiao.sal.wechat.dto.request.MessageRequest;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatSubscribeEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatImageMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatVoiceMessage;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.AutoReplyHelper;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.KeyWordMatcher;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgHelper;
import com.baijia.tianxiao.sal.wechat.helper.common.MessageBuilder;
import com.baijia.tianxiao.sal.wechat.helper.common.WechatCryptUtils;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.CustomerServiceApiCaller;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.AudioUtil;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageReceiveServiceImpl
implements MessageReceiveService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiveServiceImpl.class);
    private static final String RELEASE_TEST_USERNAME = "gh_3c884a361561";
    @Autowired
    private ReleaseTest releaseTest;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgWechatReplyForKeywordDao replyForKeywordDao;
    @Autowired
    private OrgWechatReplyForSubscribeDao replySubscribeDao;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private CloudQueue consultMsgQueue;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public String generateDefaultResponse() {
        return "";
    }

    @Override
    @Transactional(value="yunyingTransactionManager", rollbackFor={Exception.class})
    public String handle(MessageRequest request) {
        log.info("handle - message from wechat to app - request:{}", (Object)request);
        String xmlMsg = WechatCryptUtils.decryptMsg(request.getMsgSignature(), request.getTimestamp(), request.getNonce(), request.getPostData());
        WechatAbstractMessage message = MessageBuilder.build(xmlMsg);
        if (message.getToUserName().equals(RELEASE_TEST_USERNAME)) {
            return this.releaseTest.handleTestMsg(message);
        }
        if (message.getMsgType() == WechatMsgType.EVENT) {
            WechatEventMessage eventMessage = (WechatEventMessage)message;
            String msgKey = String.format("wechat.msg.%s.%s", eventMessage.getFromUserName(), eventMessage.getCreateTime());
            if (!this.isFirstTimeHandle(msgKey)) {
                return this.generateDefaultResponse();
            }
            if (this.fansPretreatment(eventMessage) == null) {
                return this.generateDefaultResponse();
            }
            return this.generateEventResponse(eventMessage);
        }
        try {
            WechatOrdinaryMessage ordinaryMessage = (WechatOrdinaryMessage)message;
            String msgKey = String.format("wechat.msg.%s", ordinaryMessage.getMsgId());
            if (!this.isFirstTimeHandle(msgKey)) {
                return this.generateDefaultResponse();
            }
            if (this.fansPretreatment(ordinaryMessage) == null) {
                return this.generateDefaultResponse();
            }
            return this.generateOrdinaryResponse(ordinaryMessage);
        }
        catch (Exception e) {
            try {
                log.error("handle - generateOrdinaryResponse - exception", (Throwable)e);
                return this.generateDefaultResponse();
            }
            catch (Exception e2) {
                log.error("MessageReceiveServiceImpl - handle - exception", (Throwable)e2);
                return this.generateDefaultResponse();
            }
        }
    }

    private String generateEventResponse(WechatEventMessage message) {
        switch (message.getEvent()) {
            case SUBSCRIBE: {
                OrgWechatReplyForSubscribe reply;
                WechatSubscribeEventMessage subscribeMsg = (WechatSubscribeEventMessage)message;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(subscribeMsg.getToUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                if (StringUtils.isNotBlank((CharSequence)subscribeMsg.getTicket())) {
                    String params = subscribeMsg.getEventKey();
                    QRCodeType qwCodeType = QRCodeSceneStr.parseQRCodeType(params);
                    switch (qwCodeType) {
                        case CUSTOM_ACTIVITY: {
                            QRCodeSceneStrActivity dto = QRCodeSceneStrActivity.fromSceneStr(params);
                            OrgWechatCustomActivity customActivity = this.customActivityDao.get(dto.getActivityId().intValue(), dto.getActivityType().intValue());
                            String webauthUrl = WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizerInfo.getAuthorizerAppId(), customActivity.getActivityId(), customActivity.getActivityType());
                            return PassiveReplyMsgBuilder.newsMsg(message.getToUserName(), message.getFromUserName(), customActivity.getTitle(), customActivity.getDescription(), customActivity.getPicUrl(), webauthUrl);
                        }
                    }
                }
                if ((reply = this.replySubscribeDao.getByAppId(authorizerInfo.getAuthorizerAppId())) == null) break;
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                try {
                    WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                    AutoReplyHelper.sendSubscribeReply(authorizationInfo.getAuthorizerAccessToken(), subscribeMsg.getFromUserName(), reply);
                    break;
                }
                catch (Exception e) {
                    return PassiveReplyMsgHelper.getSubscribeReply(subscribeMsg.getToUserName(), subscribeMsg.getFromUserName(), reply);
                }
            }
            case UNSUBSCRIBE: {
                break;
            }
            case SCAN: {
                break;
            }
            case LOCATION: {
                break;
            }
            case MENU_CLICK: {
                AuthorizationInfo authorizationInfo;
                String content;
                Map<String, String> keyVsContentMap;
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
                    return this.generateDefaultResponse();
                }
                OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                if (menu == null || (keyVsContentMap = WechatMenuJsonConverter.mapClickKeyVsContent(menu.getJson())) == null || keyVsContentMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)(content = keyVsContentMap.get(message.getEventKey()))) || (authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId())) == null) break;
                CustomerServiceApiCaller.sendTextMsg(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), content);
                break;
            }
            case MENU_VIEW: {
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
                this.sendMenuVisitMonitor(authorizerInfo, message.getFromUserName());
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown event message - message:{}", (Object)message);
            }
        }
        return this.generateDefaultResponse();
    }

    void sendMenuVisitMonitor(AuthorizerInfo authorizerInfo, String openId) {
        if (authorizerInfo == null || StringUtils.isBlank((CharSequence)openId)) {
            return;
        }
        try {
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
            String url = WechatProperties.getWebCRMUrlPrefix() + "monitor.do";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgNumber", orgAccount.getNumber() + "");
            params.put("userNumber", openId);
            params.put("typeNumber", "10");
            HttpClientUtils.doGet((String)url, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String generateOrdinaryResponse(WechatOrdinaryMessage message) throws WechatException, WebServiceException, Exception {
        switch (message.getMsgType()) {
            case TEXT: {
                return this.generateTextOrdinaryResponse((WechatTextMessage)message);
            }
            case IMAGE: {
                return this.generateImageOrdinaryResponse((WechatImageMessage)message);
            }
            case VOICE: {
                return this.generateVoiceOrdinaryResponse((WechatVoiceMessage)message);
            }
            case VIDEO: {
                break;
            }
            case SHORT_VIDEO: {
                break;
            }
            case LOCATION: {
                break;
            }
            case LINK: {
                break;
            }
            case UNKNOWN: {
                log.warn("wechat - receive unknown type message - message:{}", (Object)message);
                break;
            }
        }
        return this.generateDefaultResponse();
    }

    private String generateTextOrdinaryResponse(WechatTextMessage message) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        if (authorizerInfo == null || !authorizerInfo.isPassedVerify()) {
            return this.generateDefaultResponse();
        }
        Fans fans = this.fansDao.getByOpenId(message.getFromUserName());
        MessageDto dto = new MessageDto(MsgType.TEXT.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setTextContent(WechatEmoticons.convert(message.getContent()));
        String msg = ConsultType.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        List replyList = this.replyForKeywordDao.search(authorizerInfo.getAuthorizerAppId(), null);
        OrgWechatReplyForKeyword reply = KeyWordMatcher.match(message.getContent(), replyList);
        if (reply != null) {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            try {
                WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_CUSTOMER_SERVICE);
                AutoReplyHelper.sendKeywordReply(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName(), reply);
            }
            catch (Exception e) {
                return PassiveReplyMsgHelper.getKeywordReply(message.getToUserName(), message.getFromUserName(), reply);
            }
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateImageOrdinaryResponse(WechatImageMessage message) throws WechatException, WebServiceException, Exception {
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        if (authorizationInfo == null) {
            return this.generateDefaultResponse();
        }
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.JPG);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            image = ImageIO.read(localFile);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block9: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateImageOrdinaryResponse - exception");
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block9;
                }
                catch (Throwable var13_15) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var13_15;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        dto = new MessageDto(MsgType.PICTURE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setImageContent(storageId, StorageUtil.constructUrl(orgStorage), imageHeight, imageWidth);
        msg = ConsultType.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String generateVoiceOrdinaryResponse(WechatVoiceMessage message) throws WechatException, WebServiceException, Exception {
        if (StringUtils.isNotBlank((CharSequence)message.getRecognition())) {
            textMessage = new WechatTextMessage("[\u8bed\u97f3\u8bc6\u522b] " + message.getRecognition());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        if (!message.getFormat().toLowerCase().equals("amr")) {
            textMessage = new WechatTextMessage("[\u4e0d\u652f\u6301\u7684\u8bed\u97f3\u7c7b\u578b] " + message.getFormat().toLowerCase());
            textMessage.setCreateTime(message.getCreateTime());
            textMessage.setFromUserName(message.getFromUserName());
            textMessage.setMsgId(message.getMsgId());
            textMessage.setMsgType(message.getMsgType());
            textMessage.setToUserName(message.getToUserName());
            return this.generateTextOrdinaryResponse(textMessage);
        }
        authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        uid = Long.parseLong(authorizerInfo.getOrgId() + "");
        localFile = null;
        try {
            data = WechatMediaApiHelper.downloadTempMedia(authorizationInfo.getAuthorizerAccessToken(), message.getMediaId());
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.AMR);
            result = FileUploadUtils.uploadToRemote(uid, localFile, false);
            storageId = this.saveToDb(result, MIMEType.AMR);
            orgStorage = this.orgStorageDao.getById(storageId.intValue());
            voiceLength = Integer.parseInt(AudioUtil.getAmrDuration(localFile) + "");
            ** if (localFile == null) goto lbl-1000
        }
        catch (Exception e) {
            block10: {
                try {
                    MessageReceiveServiceImpl.log.error("wechat - generateVoiceOrdinaryResponse - exception", (Throwable)e);
                    result = this.generateDefaultResponse();
                    if (localFile == null) break block10;
                }
                catch (Throwable var11_15) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw var11_15;
                }
                LocalFileHelper.deleteFile(localFile);
            }
            return result;
        }
lbl-1000:
        // 1 sources

        {
            LocalFileHelper.deleteFile(localFile);
        }
lbl-1000:
        // 2 sources

        {
        }
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        dto = new MessageDto(MsgType.VOICE.getValue(), DateUtil.date2UnixTimestamp((Date)message.getCreateTime()), authorizerInfo.getOrgId(), authorizerInfo.getAuthorizerAppId(), message.getFromUserName(), fans.getShowName(), fans.getHeadImgUrl());
        dto.setVoiceContent(storageId, StorageUtil.constructUrl(orgStorage), voiceLength);
        msg = ConsultType.WECHAT.buildConsultTypeMsg(dto.toJson().toString());
        try {
            this.consultMsgQueue.putMessage(new Message(msg));
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue msg:{}", (Object)msg);
        }
        catch (Exception e) {
            MessageReceiveServiceImpl.log.info("put message to consultMsgQueue - Exception - msg:{},e:{}", (Object)msg, (Object)e);
        }
        return this.generateDefaultResponse();
    }

    private String generateSubscribeEventResponse(WechatSubscribeEventMessage message) {
        try {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(authorizerInfo.getOrgId(), new String[0]);
            OrgTxtMsg brief = this.orgTxtMsgDao.getOrgTxtByIdAndType(authorizerInfo.getOrgId().intValue(), 3101);
            StringBuilder msg = new StringBuilder();
            String intro = "";
            if (brief != null && StringUtils.isNotBlank((CharSequence)brief.getValue())) {
                intro = brief.getValue();
            }
            msg.append("\u611f\u8c22\u5173\u6ce8\u3010").append(orgInfo.getShortName()).append("\u3011\u3002").append(intro);
            String content = msg.toString();
            String response = WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            log.info("wechat - return subscribe event response:{}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private Integer saveToDb(UploadResult uploadResult, MIMEType mimeType) {
        List uploadFiles = uploadResult.getFiles();
        if (uploadFiles.size() == 0) {
            return 0;
        }
        UploadResult.UploadFile uploadFile = (UploadResult.UploadFile)uploadFiles.get(0);
        OrgStorage orgStorage = new OrgStorage();
        orgStorage.setFid(uploadFile.getFid());
        orgStorage.setSn(uploadFile.getSn());
        orgStorage.setSize(Integer.valueOf(uploadFile.getSize()));
        orgStorage.setMimeType(Integer.valueOf(mimeType.getCode()));
        Date now = new Date();
        orgStorage.setCreateTime(now);
        orgStorage.setUpdateTime(now);
        orgStorage.setIsDel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStorage.setSource(Short.valueOf((short)0));
        this.orgStorageDao.save((Object)orgStorage, Boolean.valueOf(true), new String[0]);
        return orgStorage.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstTimeHandle(String key) {
        log.info("Wechat - isFirstTimeHandle - check - key:{}", (Object)key);
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.exists(key.getBytes()).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            connection.setEx(key.getBytes(), 20L, "".getBytes());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Wechat - isFirstTimeHandle - exception - e:{}", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public Fans fansPretreatment(WechatAbstractMessage message) {
        Fans fans = null;
        fans = this.fansDao.getByOpenId(message.getFromUserName());
        if (fans == null) {
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByUserName(message.getToUserName());
            if (authorizerInfo == null || !authorizerInfo.isPassedVerify() || authorizerInfo.getFansSyncStatus().intValue() == WechatDataSyncStatus.ONGOING.getValue()) {
                return null;
            }
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
            if (authorizationInfo == null || !authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue()))) {
                return null;
            }
            fans = FansServiceApiHelper.getFansInfo(authorizationInfo.getAuthorizerAccessToken(), message.getFromUserName());
            if (fans == null) {
                return null;
            }
            fans.initBasicAttribute();
            if (message instanceof WechatOrdinaryMessage) {
                fans.setLastCommunicationTime(new Date());
            } else {
                fans.setLastCommunicationTime(new Date(0L));
            }
            fans.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
            log.info("wechat - MessageReceiveServiceImpl - save fans - fans:{}", (Object)fans);
        } else if (message instanceof WechatOrdinaryMessage) {
            fans.setLastCommunicationTime(new Date());
            fans.setSubscribe(Integer.valueOf(1));
            log.info("wechat - MessageReceiveServiceImpl - WechatOrdinaryMessage - update fans - fans:{}", (Object)fans);
            this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        } else if (message instanceof WechatEventMessage) {
            switch (((WechatEventMessage)message).getEvent()) {
                case SUBSCRIBE: {
                    if (fans.getSubscribe() == 1) break;
                    fans.setSubscribe(Integer.valueOf(1));
                    fans.setSubscribeTime(new Date());
                    log.info("wechat - MessageReceiveServiceImpl - SUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
                case UNSUBSCRIBE: {
                    fans.setSubscribe(Integer.valueOf(0));
                    log.info("wechat - MessageReceiveServiceImpl - UNSUBSCRIBE - update fans - fans:{}", (Object)fans);
                    this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
                    break;
                }
            }
        }
        return fans;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"), mnsProperties.getProperty("mns.accesskeysecret"), mnsProperties.getProperty("mns.accountendpoint"));
            this.consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consult.msg.queue"));
        }
        catch (Exception e) {
            log.error("init cloud account error.");
        }
    }

    @Override
    public void pushConsultation(String orgNumber, String openId) {
    }
}

