/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatTemplateDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatTemplate;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.helper.template.TemplateMsgHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatMsgRenderServiceImpl
implements WechatMsgRenderService {
    private static final Logger log = LoggerFactory.getLogger(WechatMsgRenderServiceImpl.class);
    public static String KEY_TOUSER = "touser";
    public static String KEY_TEMPLATE_ID = "template_id";
    public static String KEY_URL = "url";
    public static String KEY_FIRST = "first";
    public static String KEY_REMARK = "remark";
    public static String KEY_KEYWORD_PREFIX = "keyword";
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatTemplateDao orgWechatTemplateDao;
    @Autowired
    private FansDao fansDao;

    public Object render(Integer msgType, Map<String, Object> params) {
        WechateTemplateMsgType type = WechateTemplateMsgType.getByVaule((int)msgType);
        JSONObject data = new JSONObject();
        int i = 1;
        String keyword = KEY_KEYWORD_PREFIX + i++;
        String value = (String)params.get(keyword);
        while (value != null) {
            data.put((Object)keyword, (Object)WechatMsgRenderServiceImpl.getTemplateMsgNode(value));
            keyword = KEY_KEYWORD_PREFIX + i++;
            value = (String)params.get(keyword);
        }
        if (params.get(KEY_FIRST) != null) {
            data.put((Object)"first", (Object)WechatMsgRenderServiceImpl.getTemplateMsgNode(params.get(KEY_FIRST) + ""));
        } else {
            data.put((Object)"first", (Object)"");
        }
        if (params.get(KEY_REMARK) != null) {
            data.put((Object)"remark", (Object)WechatMsgRenderServiceImpl.getTemplateMsgNode(params.get(KEY_REMARK) + ""));
        } else {
            data.put((Object)"remark", (Object)"");
        }
        JSONObject json = new JSONObject();
        json.put((Object)"touser", params.get(KEY_TOUSER));
        json.put((Object)"template_id", (Object)type.getTemplateId());
        json.put((Object)"url", params.get(KEY_URL));
        json.put((Object)"topcolor", (Object)"#333333");
        json.put((Object)"data", (Object)data);
        return json;
    }

    protected static JSONObject getTemplateMsgNode(String value, String color) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"value", (Object)value);
        obj.put((Object)"color", (Object)color);
        return obj;
    }

    protected static JSONObject getTemplateMsgNode(String value) {
        return WechatMsgRenderServiceImpl.getTemplateMsgNode(value, "#333333");
    }

    public boolean sendMsg(Object wechatMsg) {
        block7: {
            try {
                JSONObject json = (JSONObject)wechatMsg;
                String openId = json.getString(KEY_TOUSER);
                String originalTemplateId = json.getString(KEY_TEMPLATE_ID);
                Fans fans = this.fansDao.getByOpenId(openId);
                if (!fans.isSubscribed()) {
                    return false;
                }
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByAuthorizerAppId(fans.getAuthorizerAppId());
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
                WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_TEMPLATE_SEND);
                OrgWechatTemplate template = this.bindOrgNoticeTemplate(authorizationInfo.getAuthorizerAppId(), authorizationInfo.getAuthorizerAccessToken(), originalTemplateId);
                if (template == null) {
                    throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_UNBIND_TEMPLATE);
                }
                json.put((Object)KEY_TEMPLATE_ID, (Object)template.getAuthorizerTemplateId());
                try {
                    TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), json.toString());
                }
                catch (WechatException e) {
                    if (e.getErrorCode().equals((Object)SalWechatErrorCode.WECHAT_WRONG_TEMPLATE_ID)) {
                        this.orgWechatTemplateDao.delByAppIdAndOriginalTemplateId(authorizationInfo.getAuthorizerAppId(), originalTemplateId);
                        template = this.bindOrgNoticeTemplate(authorizationInfo.getAuthorizerAppId(), authorizationInfo.getAuthorizerAccessToken(), originalTemplateId);
                        json.put((Object)KEY_TEMPLATE_ID, (Object)template.getAuthorizerTemplateId());
                        TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), json.toString());
                        break block7;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                log.error("wechat - sendMsg - exception ", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private OrgWechatTemplate bindOrgNoticeTemplate(String authorizerAppId, String accessToken, String originalTemplateId) {
        OrgWechatTemplate template = null;
        try {
            Date now = new Date();
            template = this.orgWechatTemplateDao.getByAppIdAndOriginalTemplateId(authorizerAppId, originalTemplateId);
            if (template == null) {
                String templateId = TemplateMsgHelper.bindTemplate(accessToken, originalTemplateId);
                template = new OrgWechatTemplate();
                template.setAuthorizerAppId(authorizerAppId);
                template.setAuthorizerTemplateId(templateId);
                template.setOriginalTemplateId(originalTemplateId);
                template.setCreateTime(now);
                this.orgWechatTemplateDao.save((Object)template, Boolean.valueOf(true), new String[0]);
            }
        }
        catch (CustomException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("wechat - bindOrgNoticeTemplate fail - e:{}", (Throwable)e);
        }
        return template;
    }
}

