/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.MediaTypeService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.MediaTypeDto;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaTypeServiceImpl
implements MediaTypeService {
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    @Transactional(readOnly=true)
    public List<MediaTypeDto> listMediaTypeDto(int type, int orgId) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(authorizerInfo.getOrgId().intValue(), new String[0]);
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        String mediaTypeIds = null;
        if (type == 1) {
            mediaTypeIds = WechatProperties.getMediaTypeListForMenu();
        } else if (type == 2) {
            mediaTypeIds = WechatProperties.getMediaTypeListForAutoReply();
        } else {
            return null;
        }
        ArrayList<MediaTypeDto> list = new ArrayList<MediaTypeDto>();
        MediaTypeDto dto = null;
        if (StringUtils.isNotBlank((CharSequence)mediaTypeIds)) {
            for (String mediaTypeValue : mediaTypeIds.split(",")) {
                MediaType mType = MediaType.getByVaule(Integer.parseInt(mediaTypeValue));
                if (mType.isWebauth() && !authorizerInfo.hasWebAuthPermission()) continue;
                dto = new MediaTypeDto(mType, orgWechatDto);
                list.add(dto);
            }
        }
        return list;
    }
}

