/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.wechat.constant.WechatMediaNewsType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMediaNewsDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMediaNews;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.MediaService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaNewsDto;
import com.baijia.tianxiao.sal.wechat.dto.media.MediaUploadResultDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.PermanentMediaApiDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.task.MediaNewsSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MediaServiceImpl
implements MediaService {
    private static final Logger log = LoggerFactory.getLogger(MediaServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatMediaNewsDao orgWechatMediaNewsDao;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Override
    @Transactional(readOnly=true)
    public boolean isNeedToSync(int orgId) {
        try {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
            int mediaCount = this.orgWechatMediaNewsDao.count(authorizationInfo.getAuthorizerAppId());
            WechatApiResponse response = WechatMediaApiHelper.batchGetPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), 0, 20);
            JSONObject rootNode = response.getRootJSONObj();
            if (mediaCount != rootNode.optInt("total_count", 0)) {
                return true;
            }
        }
        catch (BussinessException | WechatException e) {
            log.warn("wechat - MediaServiceImpl - isNeedToSync CustomException", e);
        }
        catch (Exception e) {
            log.error("wechat - MediaServiceImpl - isNeedToSync Exception", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncMediaNews(String authorizerAppId) {
        int i;
        log.info("wechat - MediaServiceImpl - mediaNewsSync - start - authorizerAppId:{}", (Object)authorizerAppId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByAuthorizerAppId(authorizerAppId);
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        String appId = authorizationInfo.getAuthorizerAppId();
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        Map oldMediaNewsMap = this.orgWechatMediaNewsDao.mapKeyMediaIdValueWechatUpdateTime(appId);
        HashMap<String, OrgWechatMediaNews> newMediaNewsMap = new HashMap<String, OrgWechatMediaNews>();
        int count = -1;
        int num = 0;
        int pageSize = 20;
        int start = 0;
        ArrayList<OrgWechatMediaNews> mediaNewsToAdd = new ArrayList<OrgWechatMediaNews>();
        Date now = new Date();
        while (count < 0 || num < count) {
            WechatApiResponse response = null;
            try {
                response = WechatMediaApiHelper.batchGetPermanentMediaNews(accessToken, start, start + pageSize);
            }
            catch (WechatException e) {
                if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID) {
                    accessToken = this.authorizationInfoService.forceRefreshAccessToken(authorizationInfo.getOrgId()).getAuthorizerAccessToken();
                    response = WechatMediaApiHelper.batchGetPermanentMediaNews(accessToken, start, start + pageSize);
                }
                log.error("wechat - MediaServiceImpl - mediaNewsSync - batchGetPermanentMediaNews WechatException(all fail) - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                throw e;
            }
            catch (WebServiceException e) {
                log.warn("wechat - MediaServiceImpl - mediaNewsSync - batchGetPermanentMediaNews Exception - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                continue;
            }
            catch (Exception e) {
                log.error("wechat - MediaServiceImpl - mediaNewsSync - batchGetPermanentMediaNews Exception - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                continue;
            }
            JSONObject rootNode = response.getRootJSONObj();
            count = rootNode.optInt("total_count", 0);
            num += rootNode.optInt("item_count", 0);
            JSONArray mediaNewsArray = rootNode.getJSONArray("item");
            if (mediaNewsArray.size() > 0) {
                for (i = 0; i < mediaNewsArray.size(); ++i) {
                    OrgWechatMediaNews mediaNews = new OrgWechatMediaNews();
                    JSONObject mediaNewsJson = mediaNewsArray.getJSONObject(i);
                    JSONObject contentJson = mediaNewsJson.getJSONObject("content");
                    String mediaId = mediaNewsJson.getString("media_id");
                    Date wechatUpdateTime = new Date(mediaNewsJson.getLong("update_time"));
                    if (oldMediaNewsMap.get(mediaId) == null || ((Date)oldMediaNewsMap.get(mediaId)).getTime() / 1000L != wechatUpdateTime.getTime() / 1000L) {
                        mediaNews.setAuthorizerAppId(appId);
                        mediaNews.setMediaId(mediaId);
                        mediaNews.setWechatUpdateTime(wechatUpdateTime);
                        JSONArray newsItemArray = contentJson.getJSONArray("news_item");
                        if (newsItemArray.size() > 0) {
                            for (int j = 0; j < newsItemArray.size(); ++j) {
                                JSONObject mediaItem = newsItemArray.getJSONObject(j);
                                mediaItem.put((Object)"content", null);
                                String thumbMediaId = mediaItem.getString("thumb_media_id");
                                if (StringUtils.isNotBlank((CharSequence)thumbMediaId)) {
                                    File localFile = null;
                                    try {
                                        byte[] data = WechatMediaApiHelper.downloadPermanentMedia(authorizationInfo.getAuthorizerAccessToken(), thumbMediaId);
                                        localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                                        UploadResult result = FileUploadUtils.uploadToRemote(Long.parseLong(authorizationInfo.getOrgId() + ""), localFile, false);
                                        mediaItem.put((Object)"thumb_media_url", (Object)((UploadResult.UploadFile)result.getFiles().get(0)).getUrl());
                                        if (localFile == null) continue;
                                    }
                                    catch (Exception e) {
                                        try {
                                            mediaItem.put((Object)"thumb_media_url", (Object)"");
                                            if (localFile == null) continue;
                                        }
                                        catch (Throwable throwable) {
                                            if (localFile != null) {
                                                LocalFileHelper.deleteFile(localFile);
                                            }
                                            throw throwable;
                                        }
                                        LocalFileHelper.deleteFile(localFile);
                                        continue;
                                    }
                                    LocalFileHelper.deleteFile(localFile);
                                    continue;
                                }
                                mediaItem.put((Object)"thumb_media_url", (Object)"");
                            }
                            mediaNews.setJson(newsItemArray.toString());
                        } else {
                            mediaNews.setJson("[]");
                        }
                        if (oldMediaNewsMap.get(mediaId) == null) {
                            mediaNews.setCreateTime(now);
                            mediaNews.setUpdateTime(now);
                            mediaNews.setType(Integer.valueOf(WechatMediaNewsType.NORMAL.getValue()));
                            mediaNewsToAdd.add(mediaNews);
                        } else {
                            OrgWechatMediaNews news = this.orgWechatMediaNewsDao.getByMediaId(appId, mediaId);
                            if (!news.getWechatUpdateTime().equals(wechatUpdateTime)) {
                                news.setJson(mediaNews.getJson());
                                news.setWechatUpdateTime(wechatUpdateTime);
                                news.setUpdateTime(now);
                                this.orgWechatMediaNewsDao.update((Object)news, Boolean.valueOf(true), new String[0]);
                            }
                        }
                    }
                    newMediaNewsMap.put(mediaId, mediaNews);
                }
            }
            start += pageSize;
        }
        ArrayList<String> mediaIdsToDel = new ArrayList<String>();
        for (String mediaId : oldMediaNewsMap.keySet()) {
            if (newMediaNewsMap.get(mediaId) != null) continue;
            mediaIdsToDel.add(mediaId);
        }
        if (mediaIdsToDel.size() > 0) {
            this.orgWechatMediaNewsDao.delByMediaIds(appId, mediaIdsToDel);
        }
        int batchNum = 20;
        if (mediaNewsToAdd.size() > 0) {
            ArrayList<Object> list = new ArrayList<OrgWechatMediaNews>();
            for (i = 0; i < mediaNewsToAdd.size(); ++i) {
                list.add((OrgWechatMediaNews)mediaNewsToAdd.get(i));
                if ((i == 0 || i % batchNum != 0) && i != mediaNewsToAdd.size() - 1) continue;
                try {
                    this.batchSaveMediaNews(list);
                }
                catch (Exception e) {
                    log.warn("wechat - MediaServiceImpl - media batch insert fail", (Throwable)e);
                }
                list = new ArrayList();
            }
        }
        log.info("wechat - MediaServiceImpl - mediaNewsSync - end - authorizerAppId:{}", (Object)authorizerAppId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<MediaNewsDto> listPermanentMediaNews(int orgId, PageDto pageDto) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId));
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA, true);
        if (pageDto.getPageNum() == 1) {
            this.defalutMediaNews(orgId, authorizerInfo.getAuthorizerAppId());
            if (this.isNeedToSync(orgId)) {
                try {
                    log.info("wechat - listPermanentMediaNews - handle - add mediaNewsSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                    TaskHelper.getInstance().addTask(new MediaNewsSyncJob(this, authorizerInfo.getAuthorizerAppId(), this.authorizerInfoService));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String authorizerAppId = authorizerInfo.getAuthorizerAppId();
        Integer count = this.orgWechatMediaNewsDao.count(authorizerAppId);
        List mediaNewsList = null;
        mediaNewsList = count > 0 ? this.orgWechatMediaNewsDao.search(authorizerAppId, pageDto) : new ArrayList();
        pageDto.setCurPageCount(Integer.valueOf(mediaNewsList.size()));
        pageDto.setCount(count);
        ArrayList<MediaNewsDto> dtoList = new ArrayList<MediaNewsDto>();
        if (mediaNewsList != null && !mediaNewsList.isEmpty()) {
            for (OrgWechatMediaNews mediaNews : mediaNewsList) {
                MediaNewsDto dto = new MediaNewsDto();
                dto.setId(mediaNews.getId());
                dto.setMediaId(mediaNews.getMediaId());
                dto.setNewsItem(JSONArray.fromObject((Object)mediaNews.getJson()));
                dto.setWechatUpdateTime(mediaNews.getWechatUpdateTime().getTime());
                dto.setUpdateTime(mediaNews.getUpdateTime().getTime());
                dto.setCreateTime(mediaNews.getCreateTime().getTime());
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    @Transactional(readOnly=true)
    public MediaNewsDto getPermanentMediaNews(int orgId, String mediaId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        OrgWechatMediaNews mediaNews = this.orgWechatMediaNewsDao.getByMediaId(authorizationInfo.getAuthorizerAppId(), mediaId);
        MediaNewsDto dto = null;
        if (mediaNews != null) {
            dto = new MediaNewsDto();
            dto.setId(mediaNews.getId());
            dto.setMediaId(mediaNews.getMediaId());
            dto.setNewsItem(JSONArray.fromObject((Object)mediaNews.getJson()));
            dto.setWechatUpdateTime(mediaNews.getWechatUpdateTime().getTime());
            dto.setUpdateTime(mediaNews.getUpdateTime().getTime());
            dto.setCreateTime(mediaNews.getCreateTime().getTime());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MediaUploadResultDto uploadPermanentMediaImage(int orgId, String imageUrl, File imageFile) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA);
        PermanentMediaApiDto dto = WechatMediaApiHelper.uploadPermanentMediaImage(authorizationInfo.getAuthorizerAccessToken(), imageFile);
        MediaUploadResultDto result = new MediaUploadResultDto();
        result.setMediaId(dto.getMediaId());
        result.setMediaType(MediaType.IMAGE.getValue());
        result.setUrl(imageUrl);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MediaUploadResultDto uploadPermanentMediaImage(int orgId, String imageUrl) throws Exception {
        MediaUploadResultDto mediaUploadResultDto;
        block9: {
            File localFile = null;
            try {
                String extension = "jpg";
                if (imageUrl.contains("wx_fmt=")) {
                    Matcher matcher = Pattern.compile("wx_fmt=([^&]*)").matcher(imageUrl);
                    if (matcher.find()) {
                        extension = matcher.group(1);
                    }
                } else if (imageUrl.contains("\\.")) {
                    String[] temp = imageUrl.split("\\.");
                    extension = temp[temp.length - 1];
                }
                byte[] data = HttpClientUtils.download((String)imageUrl);
                localFile = LocalFileHelper.saveToLocal(data, extension);
                mediaUploadResultDto = this.uploadPermanentMediaImage(orgId, imageUrl, localFile);
                if (localFile == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw throwable;
                }
            }
            LocalFileHelper.deleteFile(localFile);
        }
        return mediaUploadResultDto;
    }

    @Override
    public MediaUploadResultDto uploadPermanentMediaNews(int orgId, String json) throws Exception {
        return this.uploadPermanentMediaNews(orgId, json, WechatMediaNewsType.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaUploadResultDto uploadPermanentMediaNews(int orgId, String json, WechatMediaNewsType type) throws Exception {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MEDIA);
        PermanentMediaApiDto dto = WechatMediaApiHelper.uploadPermanentNews(authorizationInfo.getAuthorizerAccessToken(), json);
        MediaUploadResultDto result = new MediaUploadResultDto();
        result.setMediaId(dto.getMediaId());
        result.setMediaType(MediaType.NEWS.getValue());
        WechatApiResponse response = WechatMediaApiHelper.getPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), dto.getMediaId());
        JSONArray newsItemArray = response.getRootJSONObj().getJSONArray("news_item");
        OrgWechatMediaNews mediaNews = new OrgWechatMediaNews();
        Date now = new Date();
        mediaNews.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
        mediaNews.setMediaId(dto.getMediaId());
        mediaNews.setWechatUpdateTime(now);
        mediaNews.setCreateTime(now);
        mediaNews.setUpdateTime(now);
        for (int j = 0; j < newsItemArray.size(); ++j) {
            JSONObject mediaItem = newsItemArray.getJSONObject(j);
            mediaItem.put((Object)"content", null);
            String thumbMediaId = mediaItem.getString("thumb_media_id");
            if (StringUtils.isNotBlank((CharSequence)thumbMediaId)) {
                File localFile = null;
                try {
                    byte[] data = WechatMediaApiHelper.downloadPermanentMedia(authorizationInfo.getAuthorizerAccessToken(), thumbMediaId);
                    localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                    UploadResult uploadResult = FileUploadUtils.uploadToRemote(Long.parseLong(authorizationInfo.getOrgId() + ""), localFile, false);
                    mediaItem.put((Object)"thumb_media_url", (Object)((UploadResult.UploadFile)uploadResult.getFiles().get(0)).getUrl());
                    if (localFile == null) continue;
                }
                catch (Exception e) {
                    try {
                        mediaItem.put((Object)"thumb_media_url", (Object)"");
                        if (localFile == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (localFile != null) {
                            LocalFileHelper.deleteFile(localFile);
                        }
                        throw throwable;
                    }
                    LocalFileHelper.deleteFile(localFile);
                    continue;
                }
                LocalFileHelper.deleteFile(localFile);
                continue;
            }
            mediaItem.put((Object)"thumb_media_url", (Object)"");
        }
        mediaNews.setJson(newsItemArray.toString());
        mediaNews.setType(Integer.valueOf(type.getValue()));
        this.orgWechatMediaNewsDao.save((Object)mediaNews, new String[0]);
        return result;
    }

    @Override
    public void delMedia(Integer orgId, String mediaId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        WechatMediaApiHelper.delPermanentMediaNews(authorizationInfo.getAuthorizerAccessToken(), mediaId);
        this.orgWechatMediaNewsDao.delByMediaId(mediaId);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void batchSaveMediaNews(List<OrgWechatMediaNews> list) {
        this.orgWechatMediaNewsDao.saveAll(list, new String[0]);
    }

    public void defalutMediaNews(int orgId, String authorizerAppId) {
        OrgWechatMediaNews mediaNews = this.orgWechatMediaNewsDao.getByAppIdAndType(authorizerAppId, WechatMediaNewsType.BUILTIN.getValue());
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        if (mediaNews == null) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId), new String[0]);
            try {
                MediaUploadResultDto dto = this.uploadPermanentMediaImage(orgId, WechatProperties.getBuilitnMediaNewsImage());
                String content = HttpClientUtils.doGet((String)(WechatProperties.getWebCRMUrlPrefix() + "view/weixin/guide.html"), null);
                content = content.replace("#\u673a\u6784\u540d\u79f0#", orgInfo.getShortName());
                Pattern pattern = Pattern.compile("<img src=\"([^\"]*)");
                Matcher matcher = pattern.matcher(content);
                String imgSrc = null;
                String wechatImgSrc = null;
                while (matcher.find()) {
                    imgSrc = matcher.group(1);
                    wechatImgSrc = this.uploadPermanentMediaNewsImage(authorizationInfo.getAuthorizerAccessToken(), imgSrc);
                    content = content.replace(imgSrc, wechatImgSrc);
                }
                JSONObject json = new JSONObject();
                JSONArray articles = new JSONArray();
                JSONObject news = new JSONObject();
                news.put((Object)"thumb_media_id", (Object)dto.getMediaId());
                news.put((Object)"title", (Object)"\u65b0\u624b\u5f15\u5bfc");
                news.put((Object)"author", (Object)"\u5929\u6821");
                news.put((Object)"digest", (Object)"");
                news.put((Object)"show_cover_pic", (Object)"0");
                news.put((Object)"content", (Object)content);
                news.put((Object)"content_source_url", (Object)"");
                articles.add((Object)news);
                json.put((Object)"articles", (Object)articles);
                this.uploadPermanentMediaNews(orgId, json.toString(), WechatMediaNewsType.BUILTIN);
            }
            catch (Exception e) {
                log.error("wechat - defalutMediaNews - exception", (Throwable)e);
            }
        }
    }

    public String uploadPermanentMediaNewsImage(String accessToken, String imageUrl) throws Exception {
        String string;
        block9: {
            File localFile = null;
            try {
                String extension = "jpg";
                if (imageUrl.contains("wx_fmt=")) {
                    Matcher matcher = Pattern.compile("wx_fmt=([^&]*)").matcher(imageUrl);
                    if (matcher.find()) {
                        extension = matcher.group(1);
                    }
                } else if (imageUrl.contains("\\.")) {
                    String[] temp = imageUrl.split("\\.");
                    extension = temp[temp.length - 1];
                }
                byte[] data = HttpClientUtils.download((String)imageUrl);
                localFile = LocalFileHelper.saveToLocal(data, extension);
                string = WechatMediaApiHelper.uploadPermanentMediaNewsImg(accessToken, localFile);
                if (localFile == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw throwable;
                }
            }
            LocalFileHelper.deleteFile(localFile);
        }
        return string;
    }
}

