/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomActivityDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomActivity;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import java.io.File;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomActivityServiceImpl
implements CustomActivityService {
    private static final Logger log = LoggerFactory.getLogger(CustomActivityServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgWechatCustomActivityDao customActivityDao;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomActivityDto createCustomActivity(int orgId, int activityId, int activityType, String title, String description, String picUrl) throws Exception {
        String qrCodeImgUrl;
        AuthorizationInfo authorizationInfo;
        block7: {
            authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
            QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForCustomActivity(authorizationInfo.getAuthorizerAccessToken(), activityId, activityType);
            File localFile = null;
            try {
                byte[] data = WechatQRCodeLinkHelper.downloadQRCodeImage(qrCodeDto.getTicket());
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                UploadResult result = FileUploadUtils.uploadToRemote(Long.parseLong(orgId + ""), localFile, false);
                qrCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
                if (localFile == null) break block7;
            }
            catch (Exception e) {
                try {
                    log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (localFile != null) {
                        LocalFileHelper.deleteFile(localFile);
                    }
                    throw throwable;
                }
            }
            LocalFileHelper.deleteFile(localFile);
        }
        OrgWechatCustomActivity customActivity = new OrgWechatCustomActivity();
        customActivity.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
        customActivity.setActivityType(Integer.valueOf(activityType));
        customActivity.setActivityId(Integer.valueOf(activityId));
        customActivity.setQrCodeUrl(qrCodeImgUrl);
        customActivity.setTitle(title);
        customActivity.setDescription(description);
        customActivity.setPicUrl(picUrl);
        customActivity.setCreateTime(new Date());
        try {
            this.customActivityDao.save((Object)customActivity, Boolean.valueOf(true), new String[0]);
            log.info("wechat - CustomActivityServiceImpl - createCustomActivity - obj:{}", (Object)customActivity);
        }
        catch (Exception e) {
            log.error("wechat - CustomActivityServiceImpl - createCustomActivity - exception - obj:{}", (Object)customActivity);
            throw e;
        }
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setQrCodeUrl(qrCodeImgUrl);
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, authorizationInfo.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CustomActivityDto getCustomActivity(int activityId, int activityType) {
        OrgWechatCustomActivity customActivity = this.customActivityDao.get(activityId, activityType);
        if (customActivity == null) {
            return null;
        }
        String relativePath = TemplateConstant.getTemplateUrl((Integer)activityType);
        CustomActivityDto dto = new CustomActivityDto();
        dto.setActivityId(activityId);
        dto.setActivityType(activityType);
        dto.setQrCodeUrl(customActivity.getQrCodeUrl());
        dto.setWebAuthUrl(WechatWebAuthLinkBuilder.customActivity(WebAuthScope.BASE, customActivity.getAuthorizerAppId(), activityId, activityType, relativePath));
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteCustomActivity(int activityId, int activityType) {
        this.customActivityDao.deleteBy(activityId, activityType);
    }
}

