/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.SubscribeQRCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.image.OrgQrImageUtils;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.FreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.SubscribeQRCodeService;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubscribeQRCodeServiceImpl
implements SubscribeQRCodeService {
    private static final Logger log = LoggerFactory.getLogger(SubscribeQRCodeServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private SubscribeQRCodeDao subscribeQRCodeDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private FreeVersionService freeVersionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getQRCodeHeadImgUrl(Integer orgId) {
        SubscribeQRCode code = this.getQRCode(orgId);
        return code != null ? code.getHeadQrCode() : null;
    }

    @Override
    public SubscribeQRCode getQRCode(Integer orgId) {
        SubscribeQRCode qrCode;
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        boolean isFreeAccount = false;
        if (authorizerInfo == null) {
            if (this.freeVersionService.isFreeAccount(orgId)) {
                authorizerInfo = this.freeVersionService.getFAAuthorizerInfo(orgId);
                isFreeAccount = true;
            } else {
                log.warn("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - authorizationInfo is null");
                return null;
            }
        }
        if ((qrCode = this.subscribeQRCodeDao.getQRCode(orgId, authorizerInfo.getAuthorizerAppId())) == null) {
            try {
                String qrCodeImgUrl = null;
                String headQRCodeImgUrl = null;
                if (isFreeAccount) {
                    String accessToken = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId()).getAuthorizerAccessToken();
                    qrCodeImgUrl = WechatQRCodeLinkHelper.getQRCodeDtoForSubscribeWithOrgId(accessToken, orgId).getUrl();
                } else if (authorizerInfo.getQrcodeStorageId() != null) {
                    OrgStorage orgStorage = this.orgStorageDao.getById(authorizerInfo.getQrcodeStorageId().intValue());
                    qrCodeImgUrl = orgStorage == null ? authorizerInfo.getQrcodeUrl() : StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
                } else {
                    log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - QrcodeStorageId is null");
                    return null;
                }
                headQRCodeImgUrl = this.makeHeadQRCodeImgUrl(orgId, qrCodeImgUrl, authorizerInfo.getNickName());
                qrCode = new SubscribeQRCode();
                qrCode.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                qrCode.setHeadQrCode(headQRCodeImgUrl);
                qrCode.setQrCode(qrCodeImgUrl);
                qrCode.setCreateTime(new Date());
                qrCode.setOrgId(Integer.valueOf(orgId));
                this.subscribeQRCodeDao.save((Object)qrCode, new String[0]);
            }
            catch (Exception e) {
                log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - exception", (Throwable)e);
                return null;
            }
        }
        return qrCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String makeHeadQRCodeImgUrl(Integer orgId, String qrCodeImgUrl, String wxNick) {
        String headQRCodeImgUrl = null;
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        File localFile = null;
        UploadResult result = null;
        String name = StringUtils.isNotBlank((CharSequence)orgInfo.getName()) ? orgInfo.getName() : orgInfo.getShortName();
        try {
            BufferedImage image = OrgQrImageUtils.generateOrgQrFingerPrintImg((String)name, (String)qrCodeImgUrl, (String)orgInfo.getExtension(), (String)wxNick);
            localFile = new File(LocalFileHelper.getTmpFileName(MIMEType.JPG.getExtension()));
            ImageIO.write((RenderedImage)image, MIMEType.JPG.getExtension(), localFile);
            result = FileUploadUtils.uploadToRemote(Long.parseLong(orgId + ""), localFile, false);
            headQRCodeImgUrl = ((UploadResult.UploadFile)result.getFiles().get(0)).getUrl();
            if (localFile == null) return headQRCodeImgUrl;
        }
        catch (Exception e) {
            log.error("makeHeadQRCodeImgUrl - exception", (Throwable)e);
            return headQRCodeImgUrl;
        }
        finally {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }
        LocalFileHelper.deleteFile(localFile);
        return headQRCodeImgUrl;
    }
}

