/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiCaller;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReplyHelper {
    private static final Logger log = LoggerFactory.getLogger(AutoReplyHelper.class);

    public static boolean sendSubscribeReply(String accessToken, String toOpenId, OrgWechatReplyForSubscribe reply) {
        if (reply == null) {
            return false;
        }
        try {
            WechatApiResponse result = null;
            MediaType type = MediaType.getByVaule(reply.getMediaType());
            if (MediaType.UNKNOWN == type) {
                return true;
            }
            if (MediaType.IMAGE == type) {
                result = CustomerServiceApiCaller.sendImageMsg(accessToken, toOpenId, reply.getMediaId());
            } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type) {
                if (MediaType.NEWS == type) {
                    if (reply.getMediaId() != null) {
                        result = CustomerServiceApiCaller.sendNewsMsg(accessToken, toOpenId, reply.getMediaId());
                    }
                } else if (MediaType.CONTENT == type) {
                    if (StringUtils.isNotBlank((CharSequence)reply.getContent())) {
                        result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, reply.getContent());
                    }
                } else if ((MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) && StringUtils.isNotBlank((CharSequence)reply.getUrl())) {
                    String fmt = "\u3010%s\u3011\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, fmt);
                }
            }
            return result != null && result.getCode() == 0;
        }
        catch (WechatException e) {
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - toOpenId:{}, reply:{}", (Object)toOpenId, (Object)reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - toOpenId:{}, reply:{}", (Object)toOpenId, (Object)reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", (Throwable)e);
            return false;
        }
    }

    public static boolean sendKeywordReply(String accessToken, String toOpenId, OrgWechatReplyForKeyword reply) {
        if (reply == null) {
            return false;
        }
        try {
            WechatApiResponse result = null;
            MediaType type = MediaType.getByVaule(reply.getMediaType());
            log.info("mediaType is : {} ", (Object)type);
            if (MediaType.UNKNOWN == type) {
                return true;
            }
            if (MediaType.IMAGE == type) {
                result = CustomerServiceApiCaller.sendImageMsg(accessToken, toOpenId, reply.getMediaId());
            } else if (MediaType.IMAGE != type && MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type) {
                if (MediaType.NEWS == type) {
                    if (reply.getMediaId() != null) {
                        result = CustomerServiceApiCaller.sendNewsMsg(accessToken, toOpenId, reply.getMediaId());
                    }
                } else if (MediaType.CONTENT == type) {
                    if (StringUtils.isNotBlank((CharSequence)reply.getContent())) {
                        result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, reply.getContent());
                    }
                } else if (MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) {
                    log.info("------------");
                    if (StringUtils.isNotBlank((CharSequence)reply.getUrl())) {
                        String fmt = "\u3010%s\u3011\n%s";
                        fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                        result = CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, fmt);
                    }
                }
            }
            return result != null && result.getCode() == 0;
        }
        catch (WechatException e) {
            log.warn("wechat - AutoReplyHelper - sendKeywordReply fail - toOpenId:{}, reply:{}", (Object)toOpenId, (Object)reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.warn("wechat - AutoReplyHelper - sendKeywordReply fail - toOpenId:{}, reply:{}", (Object)toOpenId, (Object)reply);
            log.warn("wechat - AutoReplyHelper - sendSubscribeReply fail - e:{}", (Throwable)e);
            return false;
        }
    }
}

