/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatTemplateDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatTemplate;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.TemplateMsgService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.courseplan.CoursePlanMsgToStu;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.coursesignin.CourseSigninSuccMsgToStu;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.coursestart.CourseStartMsgToStu;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.courseupdate.CourseUpdateMsgToStu;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.evaluation.CourseEvaluationMsgToStu;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.evaluation.TeacherEvaluationMsgToStu;
import com.baijia.tianxiao.sal.wechat.helper.template.TemplateMsgHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import java.util.Date;
import java.util.HashSet;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateMsgServiceImpl
implements TemplateMsgService {
    private static final Logger log = LoggerFactory.getLogger(TemplateMsgServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgWechatTemplateDao orgWechatTemplateDao;

    private OrgWechatTemplate bindOrgNoticeTemplate(String authorizerAppId, String accessToken, String originalTemplateId) {
        OrgWechatTemplate template = null;
        try {
            Date now = new Date();
            String templateId = TemplateMsgHelper.bindTemplate(accessToken, originalTemplateId);
            template = this.orgWechatTemplateDao.getByAppIdAndOriginalTemplateId(authorizerAppId, originalTemplateId);
            if (template == null) {
                template = new OrgWechatTemplate();
                template.setAuthorizerAppId(authorizerAppId);
                template.setAuthorizerTemplateId(templateId);
                template.setOriginalTemplateId(originalTemplateId);
                template.setCreateTime(now);
                this.orgWechatTemplateDao.save((Object)template, Boolean.valueOf(true), new String[0]);
            }
        }
        catch (Exception e) {
            log.error("wechat - bindOrgNoticeTemplate fail - e:{}", (Throwable)e);
        }
        return template;
    }

    @Override
    public void bindOrgNoticeTemplate(int orgId) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_TEMPLATE_SEND);
        HashSet originalTemplateIdList = new HashSet();
        for (String originalTemplateId : originalTemplateIdList) {
            this.bindOrgNoticeTemplate(authorizerInfo.getAuthorizerAppId(), authorizationInfo.getAuthorizerAccessToken(), originalTemplateId);
        }
    }

    @Override
    public void sendTemplateMsg(String msgJson) throws CustomException {
        JSONObject json = JSONObject.fromObject((Object)msgJson);
        int msgTypeValue = json.getInt("msgType");
        WechateTemplateMsgType msgType = WechateTemplateMsgType.getByVaule((int)msgTypeValue);
        OrgWechatTemplate template = null;
        AuthorizationInfo authorizationInfo = null;
        switch (msgType) {
            case COURSE_PLAN_TO_STU: {
                CoursePlanMsgToStu cpMsg2stu = CoursePlanMsgToStu.fromJsonStr(msgJson);
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(cpMsg2stu.getOrgId());
                template = this.templateCheck(cpMsg2stu.getOrgId(), WechateTemplateMsgType.COURSE_PLAN_TO_STU.getTemplateId(), authorizationInfo);
                TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), msgJson);
                break;
            }
            case COURSE_START_TO_STU: {
                CourseStartMsgToStu snMsg2stu = CourseStartMsgToStu.fromJsonStr(msgJson);
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(snMsg2stu.getOrgId());
                template = this.templateCheck(snMsg2stu.getOrgId(), WechateTemplateMsgType.COURSE_PLAN_TO_STU.getTemplateId(), authorizationInfo);
                TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), msgJson);
                break;
            }
            case COURSE_SIGNIN_TO_STU: {
                CourseSigninSuccMsgToStu csMsg2stu = CourseSigninSuccMsgToStu.fromJsonStr(msgJson);
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(csMsg2stu.getOrgId());
                template = this.templateCheck(csMsg2stu.getOrgId(), WechateTemplateMsgType.COURSE_SIGNIN_TO_STU.getTemplateId(), authorizationInfo);
                TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), msgJson);
                break;
            }
            case COURSE_EVALUATION_TO_STU: {
                CourseEvaluationMsgToStu ceMsg2stu = CourseEvaluationMsgToStu.fromJsonStr(msgJson);
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(ceMsg2stu.getOrgId());
                template = this.templateCheck(ceMsg2stu.getOrgId(), WechateTemplateMsgType.COURSE_EVALUATION_TO_STU.getTemplateId(), authorizationInfo);
                TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), msgJson);
                break;
            }
            case TEACHER_EVALUATION_TO_STU: {
                TeacherEvaluationMsgToStu jsMsg2stu = TeacherEvaluationMsgToStu.fromJsonStr(msgJson);
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(jsMsg2stu.getOrgId());
                template = this.templateCheck(jsMsg2stu.getOrgId(), WechateTemplateMsgType.TEACHER_EVALUATION_TO_STU.getTemplateId(), authorizationInfo);
                TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), msgJson);
                break;
            }
            case COURSE_UPDATE_TO_STU: {
                CourseUpdateMsgToStu cuMsg2stu = CourseUpdateMsgToStu.fromJsonStr(msgJson);
                authorizationInfo = this.authorizationInfoService.refreshAccessToken(cuMsg2stu.getOrgId());
                template = this.templateCheck(cuMsg2stu.getOrgId(), WechateTemplateMsgType.COURSE_UPDATE_TO_STU.getTemplateId(), authorizationInfo);
                TemplateMsgHelper.sendTemplateMsg(authorizationInfo.getAuthorizerAccessToken(), msgJson);
                break;
            }
            default: {
                return;
            }
        }
    }

    OrgWechatTemplate templateCheck(Integer orgId, String originalTemplateId, AuthorizationInfo authorizationInfo) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MSG_TEMPLATE_SEND);
        OrgWechatTemplate template = this.bindOrgNoticeTemplate(authorizationInfo.getAuthorizerAppId(), authorizationInfo.getAuthorizerAccessToken(), originalTemplateId);
        if (template == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_UNBIND_TEMPLATE);
        }
        return template;
    }

    @Override
    public boolean hasTemplatePermission(int orgId, WechateTemplateMsgType type, String openId) {
        return true;
    }
}

