/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.StatisticsService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import java.text.ParseException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;

    @Override
    @Transactional(value="yunyingTransactionManager", readOnly=true)
    public FansSCDto getFansStatistics(Integer orgId, Date beginDate, Date endDate) throws ParseException, BussinessException {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        if (authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_GET_INFO);
        return DataStatisticsApiHelper.getFansSCDto(authorizationInfo.getAuthorizerAccessToken(), beginDate, endDate);
    }
}

