/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansDetailDto;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansListDto;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansListRecordDto;
import com.baijia.tianxiao.sal.wechat.helper.user.FansServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FansServiceImpl
implements FansService {
    private static final Logger log = LoggerFactory.getLogger(FansServiceImpl.class);
    @Autowired
    private FansDao fansDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;

    @Override
    @Transactional(value="yunyingTransactionManager", rollbackFor={Exception.class})
    public boolean isNeedToSync(int orgId) {
        double diifRange = 0.1;
        try {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
            AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST, true);
            int fansCount = this.fansDao.countSubscribe(authorizationInfo.getAuthorizerAppId());
            int wechatFansCount = FansServiceApiHelper.getFansCount(authorizationInfo.getAuthorizerAccessToken());
            if (wechatFansCount == 0) {
                return fansCount != 0;
            }
            double diff = (fansCount - wechatFansCount) / wechatFansCount;
            if (diff > diifRange || diff < diifRange * -1.0) {
                return true;
            }
        }
        catch (BussinessException | WechatException e) {
            log.warn("wechat - FansServiceImpl - isNeedToSync CustomException", e);
        }
        catch (Exception e) {
            log.error("wechat - FansServiceImpl - isNeedToSync Exception", (Throwable)e);
        }
        return false;
    }

    @Override
    @Transactional(value="yunyingTransactionManager", readOnly=true)
    public FansListDto listFans(Integer orgId, String searchText, PageDto pageDto) throws CustomException {
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(orgId);
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_LIST);
        if (pageDto.getPageNum() == 1 && this.isNeedToSync(orgId)) {
            try {
                log.info("wechat - listFans - handle - add mediaNewsSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                TaskHelper.getInstance().addTask(new FansSyncJob(this, authorizerInfo.getAuthorizerAppId(), this.authorizerInfoService));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String authorizerAppId = authorizerInfo.getAuthorizerAppId();
        Integer count = this.fansDao.count(authorizerAppId);
        List fansList = null;
        fansList = count > 0 ? this.fansDao.search(authorizerAppId, searchText, pageDto) : new ArrayList();
        pageDto.setCurPageCount(Integer.valueOf(fansList.size()));
        pageDto.setCount(count);
        List<FansListRecordDto> recordList = FansListRecordDto.buildList(fansList);
        if (recordList != null && !recordList.isEmpty()) {
            ArrayList<String> openIdList = new ArrayList<String>();
            for (FansListRecordDto dto : recordList) {
                openIdList.add(dto.getOpenId());
            }
            Map keyOpenIdValueConsultUserIdMap = this.txConsultUserDao.mapKeyOpenIdValueId(orgId, openIdList);
            for (FansListRecordDto dto : recordList) {
                dto.setConsultUserId(MapUtils.getLong((Map)keyOpenIdValueConsultUserIdMap, (Object)dto.getOpenId(), (Long)-1L));
            }
        }
        FansListDto dto = new FansListDto(recordList);
        return dto;
    }

    @Override
    @Transactional(value="yunyingTransactionManager", readOnly=true)
    public FansDetailDto getFansDetail(String openId) {
        Fans fans = this.fansDao.getByOpenId(openId);
        return FansDetailDto.build(fans);
    }

    @Override
    @Transactional(value="yunyingTransactionManager", rollbackFor={Exception.class})
    public void syncFans(String authorizerAppId) throws CustomException {
        log.info("wechat - FansService - syncFans - start - authorizerAppId:{}", (Object)authorizerAppId);
        int fansNum = 0;
        int failNum = 0;
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(authorizerAppId);
        authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizationInfo.getOrgId());
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        List<String> openIds = FansServiceApiHelper.getAllFansOpenIdList(accessToken);
        if (openIds != null && !openIds.isEmpty()) {
            fansNum = openIds.size();
            ArrayList<String> tempOpendIds = new ArrayList<String>();
            for (int i = 0; i < openIds.size(); ++i) {
                tempOpendIds.add(openIds.get(i));
                if ((i == 0 || i % 100 != 0) && i != openIds.size() - 1) continue;
                Map openIdMap = this.fansDao.mapKeyOpenIdValueFans(tempOpendIds);
                ArrayList<Fans> fansList = new ArrayList<Fans>();
                Fans fans = null;
                for (String tempOpenId : tempOpendIds) {
                    try {
                        fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                    }
                    catch (WechatException e) {
                        if (e.getErrorCode() == SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID) {
                            accessToken = this.authorizationInfoService.forceRefreshAccessToken(authorizationInfo.getOrgId()).getAuthorizerAccessToken();
                            fans = FansServiceApiHelper.getFansInfo(accessToken, tempOpenId);
                        }
                        log.error("wechat - FansServiceImpl - syncFans - getFansInfo WechatException(all fail) - authorizerAppId:{},e:{}", (Object)authorizerAppId, (Object)e);
                        throw e;
                    }
                    catch (Exception e) {
                        log.error("wechat - FansServiceImpl - syncFans - getFansInfo Exception - authorizerAppId:{},openId:{},e:{}", new Object[]{authorizerAppId, tempOpenId, e});
                        ++failNum;
                        continue;
                    }
                    if (fans == null) continue;
                    Fans dbFans = (Fans)openIdMap.get(tempOpenId);
                    if (dbFans == null) {
                        fans.initBasicAttribute();
                        fans.setAuthorizerAppId(authorizerAppId);
                        fans.setLastCommunicationTime(new Date(0L));
                        fansList.add(fans);
                        continue;
                    }
                    if (!(dbFans.getNick().equals(fans.getNick()) && dbFans.getHeadImgUrl().equals(fans.getHeadImgUrl()) && dbFans.getSubscribe().equals(fans.getSubscribe()))) {
                        fans.setId(dbFans.getId());
                        fans.setLastCommunicationTime(dbFans.getLastCommunicationTime());
                        fans.setSubscribe(Integer.valueOf(1));
                        fans.setUpdateTime(new Date());
                        this.fansDao.update((Object)fans, new String[0]);
                        fansList.add(fans);
                        continue;
                    }
                    Fans oldFans = this.fansDao.getByOpenId(tempOpenId);
                    if (oldFans.getSubscribe() != 0) continue;
                    oldFans.setSubscribe(Integer.valueOf(1));
                    oldFans.setUpdateTime(new Date());
                    this.fansDao.update((Object)oldFans, new String[0]);
                }
                this.fansDao.saveAll(fansList, new String[0]);
                tempOpendIds = new ArrayList();
            }
        }
        log.info("wechat - FansService - syncFans - end - authorizerAppId:{}, fansNum:{}, failNum:{}", new Object[]{authorizerAppId, fansNum, failNum});
    }

    @Override
    @Transactional(value="yunyingTransactionManager", rollbackFor={Exception.class})
    public void remark(Integer orgId, String openId, String remark) {
        AuthorizationInfo authorizationInfo;
        if (remark == null) {
            remark = "";
        }
        if ((authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId)) == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        FansServiceApiHelper.remark(authorizationInfo.getAuthorizerAccessToken(), openId, remark);
        Fans fans = this.fansDao.getByOpenId(openId);
        fans.setRemark(remark);
        this.fansDao.update((Object)fans, Boolean.valueOf(true), new String[0]);
        log.info("wechat - FansService - remark - orgId:{}, openId:{}, remark:{}", new Object[]{orgId, openId, remark});
    }

    @Override
    @Transactional(value="yunyingTransactionManager", rollbackFor={Exception.class})
    public void saveOrUpdateFans(Fans fans) {
        Fans oldFans = this.fansDao.getByOpenId(fans.getOpenId());
        if (oldFans == null) {
            fans.initBasicAttribute();
            this.fansDao.save((Object)fans, Boolean.valueOf(true), new String[0]);
        } else {
            oldFans.refreshBy(fans);
            this.fansDao.update((Object)fans, new String[0]);
        }
    }
}

