/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.dao.ComponentVerifyTicketDao;
import com.baijia.tianxiao.dal.wechat.po.ComponentAccessToken;
import com.baijia.tianxiao.sal.wechat.api.ComponentAccessTokenService;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComponentAccessTokenServiceImpl
implements ComponentAccessTokenService {
    private static final Logger logger = LoggerFactory.getLogger(ComponentAccessTokenServiceImpl.class);
    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
    @Autowired
    private ComponentVerifyTicketDao componentVerifyTicketDao;

    @Override
    @Transactional(value="yunyingTransactionManager", readOnly=true)
    public ComponentAccessToken getByAppId(String appId) {
        return this.componentAccessTokenDao.getByAppId(appId);
    }

    @Override
    @Transactional(value="yunyingTransactionManager", rollbackFor={Exception.class})
    public void update() {
        OpenPlatformInfoDto openPlatformInfo = WechatProperties.getOpenPlatformInfo();
        String componentVerifyTicket = this.componentVerifyTicketDao.getByAppId(openPlatformInfo.getAppId()).getComponentVerifyTicket();
        ComponentAccessToken newToken = OpenPlatApiHelper.requestComponentAccessToken(openPlatformInfo.getAppId(), openPlatformInfo.getAppSecret(), componentVerifyTicket);
        ComponentAccessToken token = this.getByAppId(newToken.getAppId());
        if (token == null) {
            this.componentAccessTokenDao.save((Object)newToken, Boolean.valueOf(true), new String[0]);
            logger.info("wechat - add new component access token:{}", (Object)newToken);
            return;
        }
        token.setUpdateTime(new Date());
        token.setExpiresIn(newToken.getExpiresIn());
        token.setComponentAccessToken(newToken.getComponentAccessToken());
        this.componentAccessTokenDao.update((Object)token, Boolean.valueOf(true), new String[0]);
        logger.info("wechat - update new component access token:{}", (Object)newToken);
    }
}

