/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.statistics;

import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSummaryDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiCaller;
import com.baijia.tianxiao.util.date.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class DataStatisticsApiHelper {
    public static FansSCDto getFansSCDto(String accessToken, Date beginDate, Date endDate) throws ParseException {
        FansSCDto dto = new FansSCDto();
        dto.setStartDate(DateUtil.getStrByDate((Date)beginDate));
        dto.setEndDate(DateUtil.getStrByDate((Date)endDate));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date yesterDay = DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)-1);
        WechatApiResponse ytCumulateResp = DataStatisticsApiCaller.getFansCumulate(accessToken, yesterDay, yesterDay);
        WechatApiResponse ytSummaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, yesterDay, yesterDay);
        int ytCancelFans = 0;
        int ytNewFans = 0;
        int ytCumulateFans = 0;
        JSONObject ytSummaryRootNode = ytSummaryResp.getRootJSONObj();
        JSONArray ytSummaryArray = ytSummaryRootNode.getJSONArray("list");
        if (ytSummaryArray != null && ytSummaryArray.size() > 0) {
            for (int i = 0; i < ytSummaryArray.size(); ++i) {
                JSONObject obj = ytSummaryArray.getJSONObject(i);
                ytCancelFans += obj.getInt("cancel_user");
                ytNewFans += obj.getInt("new_user");
            }
        }
        JSONObject ytCumulateRootNode = ytCumulateResp.getRootJSONObj();
        JSONArray ytCumulateArray = ytCumulateRootNode.getJSONArray("list");
        ytCumulateFans = ytCumulateArray.getJSONObject(0).getInt("cumulate_user");
        dto.setYtDate(sdf.format(yesterDay));
        dto.setYtCancelFans(ytCancelFans);
        dto.setYtNewFans(ytNewFans);
        dto.setYtFansDiff(ytNewFans - ytCancelFans);
        dto.setYtCumulateFans(ytCumulateFans);
        ArrayList<FansSummaryDto> fansSummaryDtoList = new ArrayList<FansSummaryDto>();
        List dateList = DateUtil.getDateBetween((Date)beginDate, (Date)endDate);
        if (dateList != null && !dateList.isEmpty()) {
            LinkedHashMap<String, FansSummaryDto> symmaryMap = new LinkedHashMap<String, FansSummaryDto>();
            for (Date date : dateList) {
                FansSummaryDto fansSummaryDto = new FansSummaryDto(sdf.format(date));
                symmaryMap.put(sdf.format(date), fansSummaryDto);
            }
            WechatApiResponse summaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, beginDate, endDate);
            JSONObject summaryRootNode = summaryResp.getRootJSONObj();
            JSONArray summaryArray = summaryRootNode.getJSONArray("list");
            if (summaryArray != null & !summaryArray.isEmpty()) {
                for (int i = 0; i < summaryArray.size(); ++i) {
                    JSONObject obj = summaryArray.getJSONObject(i);
                    FansSummaryDto fsdto = (FansSummaryDto)symmaryMap.get(obj.getString("ref_date"));
                    fsdto.setCancelFans(fsdto.getCancelFans() + obj.getInt("cancel_user"));
                    fsdto.setNewFans(fsdto.getNewFans() + obj.getInt("new_user"));
                    fsdto.setFansDiff(fsdto.getNewFans() - fsdto.getCancelFans());
                }
            }
            for (FansSummaryDto fsdto : symmaryMap.values()) {
                fansSummaryDtoList.add(fsdto);
            }
        }
        dto.setSummary(fansSummaryDtoList);
        return dto;
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FansSCDto dto = DataStatisticsApiHelper.getFansSCDto("9ZwSriIRI2kBv7qr6h-GkjJbo4rTTkgDAryUVGjspqfkl0aePGQA-wnH7kq9_VWMYseQuIaLEv65z4u3umLj7rBnYHEn2u-CQbgNvTMteccUBZeAEACJH", sdf.parse("2015-12-28"), sdf.parse("2015-12-29"));
        System.out.println(dto);
    }
}

