/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.common;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.common.WXBizMsgCrypt;
import com.baijia.tianxiao.sal.wechat.helper.common.XMLParse;
import java.util.Date;
import java.util.Random;

public class WechatCryptUtils {
    public static String encryptMsg(String fromUserName, String toUserName, String msgType, String content) throws Exception {
        String appId = WechatProperties.getOpenAppId();
        String token = WechatProperties.getOpenMsgToken();
        String encodingAesKey = WechatProperties.getEncodingAesKey();
        WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);
        String timestamp = WechatCryptUtils.getTimestamp();
        String nonce = WechatCryptUtils.getNonce();
        String xmlMsg = WechatCryptUtils.generateXml(fromUserName, toUserName, msgType, content, timestamp);
        return pc.encryptMsg(xmlMsg, timestamp, nonce);
    }

    private static String getTimestamp() {
        return String.valueOf(new Date().getTime() / 1000L);
    }

    private static String getNonce() {
        Random random = new Random();
        return String.valueOf(random.nextInt(9000000) + 1000000);
    }

    private static String generateXml(String toUserName, String fromUserName, String msgType, String content, String createTime) {
        String format = "<xml><ToUserName><![CDATA[%1$s]]></ToUserName><FromUserName><![CDATA[%2$s]]></FromUserName><MsgType><![CDATA[%3$s]]></MsgType><Content><![CDATA[%4$s]]></Content><CreateTime>%5$s</CreateTime></xml>";
        return String.format(format, toUserName, fromUserName, msgType, content, createTime);
    }

    public static String decryptMsg(String msgSignature, String timestamp, String nonce, String plainText) {
        try {
            String appId = WechatProperties.getOpenAppId();
            String token = WechatProperties.getOpenMsgToken();
            String encodingAesKey = WechatProperties.getEncodingAesKey();
            WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);
            String[] encrytMsg = XMLParse.extractMessage(plainText);
            return pc.decryptMsg(msgSignature, timestamp, nonce, encrytMsg);
        }
        catch (Exception e) {
            throw new WebServiceException("parse response exception", (Throwable)e);
        }
    }
}

