/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.courseupdate;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class CourseUpdateMsgToStu
extends WechatTemplateMsg {
    private Integer orgId;
    private String openId;
    private String orgName;
    private String courseName;
    private String studentName;
    private Integer lessonNo;
    private Long oldLessonStartTime;
    private Long oldLessonEndTime;
    private Long newLessonStartTime;
    private Long newLessonEndTime;
    private String newTeacherName;
    private String newClassroom;
    private String orgMobile;

    public CourseUpdateMsgToStu() {
        this.msgType = WechateTemplateMsgType.COURSE_UPDATE_TO_STU;
    }

    public String buildTemplateMsg(String templateId) {
        SimpleDateFormat daySdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeSdf = new SimpleDateFormat("HH:mm");
        this.first = String.format("\u3010%s\u3011,\u60a8\u597d:\n\n\u60a8\u5728\u3010%s\u3011\u7684\u3010%s\u3011\u3010\u7b2c%s\u6b21\u8bfe\u3011\u7684\u4e0a\u8bfe\u4fe1\u606f\u6709\u53d8\u52a8\u3002", this.studentName, this.orgName, this.courseName, this.lessonNo);
        if (StringUtils.isNotBlank((CharSequence)this.newTeacherName) || StringUtils.isNotBlank((CharSequence)this.newClassroom)) {
            this.first = this.first + "\n\n\u8c03\u6574\u5185\u5bb9:";
            if (StringUtils.isNotBlank((CharSequence)this.newClassroom)) {
                this.first = this.first + "  \n\u6559\u5ba4,\u53d8\u66f4\u4e3a" + this.newClassroom;
            }
            if (StringUtils.isNotBlank((CharSequence)this.newTeacherName)) {
                this.first = this.first + "  \n\u8001\u5e08,\u53d8\u66f4\u4e3a" + this.newTeacherName;
            }
        }
        this.remark = String.format("\u8bf7\u53ca\u65f6\u786e\u8ba4\u8c03\u8bfe\u60c5\u51b5\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u81f4\u7535\u3010%s\u3011", this.orgMobile);
        JSONObject data = new JSONObject();
        data.put((Object)"keyword1", (Object)CourseUpdateMsgToStu.getTemplateMsgNode(this.courseName));
        data.put((Object)"keyword2", (Object)CourseUpdateMsgToStu.getTemplateMsgNode(String.format("%s %s - %s", daySdf.format(new Date(this.oldLessonStartTime)), timeSdf.format(new Date(this.oldLessonStartTime)), timeSdf.format(new Date(this.oldLessonEndTime)))));
        data.put((Object)"keyword3", (Object)CourseUpdateMsgToStu.getTemplateMsgNode(String.format("%s %s - %s", daySdf.format(new Date(this.newLessonStartTime)), timeSdf.format(new Date(this.newLessonStartTime)), timeSdf.format(new Date(this.newLessonEndTime)))));
        return super.buildBaseTemplateMsg(this.openId, templateId, data).toString();
    }

    public static CourseUpdateMsgToStu fromJsonStr(String jsonStr) {
        CourseUpdateMsgToStu msg = new CourseUpdateMsgToStu();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        msg.fillBaseInfo(jsonStr);
        msg.setOrgId(json.optInt("orgId"));
        msg.setOpenId(json.getString("openId"));
        msg.setOrgName(json.optString("orgName"));
        msg.setCourseName(json.optString("courseName"));
        msg.setCourseName(json.optString("studentName"));
        msg.setLessonNo(json.optInt("lessonNo"));
        msg.setOldLessonStartTime(json.optLong("oldLessonStartTime"));
        msg.setOldLessonEndTime(json.optLong("oldLessonEndTime"));
        msg.setNewLessonStartTime(json.optLong("newLessonStartTime"));
        msg.setNewLessonEndTime(json.optLong("newLessonEndTime"));
        msg.setNewClassroom(json.optString("newClassroom"));
        msg.setNewTeacherName(json.optString("newTeacherName"));
        msg.setOrgMobile(json.optString("orgMobile"));
        return msg;
    }

    public String toJsonStr() {
        JSONObject json = super.getBaseJson();
        json.put((Object)"orgId", this.checkNull(this.orgId));
        json.put((Object)"openId", this.checkNull(this.openId));
        json.put((Object)"orgName", this.checkNull(this.orgName));
        json.put((Object)"courseName", this.checkNull(this.courseName));
        json.put((Object)"studentName", this.checkNull(this.studentName));
        json.put((Object)"lessonNo", this.checkNull(this.lessonNo));
        json.put((Object)"oldLessonStartTime", this.checkNull(this.oldLessonStartTime));
        json.put((Object)"oldLessonEndTime", this.checkNull(this.oldLessonEndTime));
        json.put((Object)"newLessonStartTime", this.checkNull(this.newLessonStartTime));
        json.put((Object)"newLessonEndTime", this.checkNull(this.newLessonEndTime));
        json.put((Object)"newClassroom", this.checkNull(this.newClassroom));
        json.put((Object)"newTeacherName", this.checkNull(this.newTeacherName));
        json.put((Object)"orgMobile", this.checkNull(this.orgMobile));
        return json.toString();
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = Integer.parseInt(orgId.toString());
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public Integer getLessonNo() {
        return this.lessonNo;
    }

    public Long getOldLessonStartTime() {
        return this.oldLessonStartTime;
    }

    public Long getOldLessonEndTime() {
        return this.oldLessonEndTime;
    }

    public Long getNewLessonStartTime() {
        return this.newLessonStartTime;
    }

    public Long getNewLessonEndTime() {
        return this.newLessonEndTime;
    }

    public String getNewTeacherName() {
        return this.newTeacherName;
    }

    public String getNewClassroom() {
        return this.newClassroom;
    }

    public String getOrgMobile() {
        return this.orgMobile;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setLessonNo(Integer lessonNo) {
        this.lessonNo = lessonNo;
    }

    public void setOldLessonStartTime(Long oldLessonStartTime) {
        this.oldLessonStartTime = oldLessonStartTime;
    }

    public void setOldLessonEndTime(Long oldLessonEndTime) {
        this.oldLessonEndTime = oldLessonEndTime;
    }

    public void setNewLessonStartTime(Long newLessonStartTime) {
        this.newLessonStartTime = newLessonStartTime;
    }

    public void setNewLessonEndTime(Long newLessonEndTime) {
        this.newLessonEndTime = newLessonEndTime;
    }

    public void setNewTeacherName(String newTeacherName) {
        this.newTeacherName = newTeacherName;
    }

    public void setNewClassroom(String newClassroom) {
        this.newClassroom = newClassroom;
    }

    public void setOrgMobile(String orgMobile) {
        this.orgMobile = orgMobile;
    }

    @Override
    public String toString() {
        return "CourseUpdateMsgToStu(orgId=" + this.getOrgId() + ", openId=" + this.getOpenId() + ", orgName=" + this.getOrgName() + ", courseName=" + this.getCourseName() + ", studentName=" + this.getStudentName() + ", lessonNo=" + this.getLessonNo() + ", oldLessonStartTime=" + this.getOldLessonStartTime() + ", oldLessonEndTime=" + this.getOldLessonEndTime() + ", newLessonStartTime=" + this.getNewLessonStartTime() + ", newLessonEndTime=" + this.getNewLessonEndTime() + ", newTeacherName=" + this.getNewTeacherName() + ", newClassroom=" + this.getNewClassroom() + ", orgMobile=" + this.getOrgMobile() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CourseUpdateMsgToStu)) {
            return false;
        }
        CourseUpdateMsgToStu other = (CourseUpdateMsgToStu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$orgId = this.getOrgId();
        Integer other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        if (this$openId == null ? other$openId != null : !this$openId.equals(other$openId)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$courseName = this.getCourseName();
        String other$courseName = other.getCourseName();
        if (this$courseName == null ? other$courseName != null : !this$courseName.equals(other$courseName)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        Integer this$lessonNo = this.getLessonNo();
        Integer other$lessonNo = other.getLessonNo();
        if (this$lessonNo == null ? other$lessonNo != null : !((Object)this$lessonNo).equals(other$lessonNo)) {
            return false;
        }
        Long this$oldLessonStartTime = this.getOldLessonStartTime();
        Long other$oldLessonStartTime = other.getOldLessonStartTime();
        if (this$oldLessonStartTime == null ? other$oldLessonStartTime != null : !((Object)this$oldLessonStartTime).equals(other$oldLessonStartTime)) {
            return false;
        }
        Long this$oldLessonEndTime = this.getOldLessonEndTime();
        Long other$oldLessonEndTime = other.getOldLessonEndTime();
        if (this$oldLessonEndTime == null ? other$oldLessonEndTime != null : !((Object)this$oldLessonEndTime).equals(other$oldLessonEndTime)) {
            return false;
        }
        Long this$newLessonStartTime = this.getNewLessonStartTime();
        Long other$newLessonStartTime = other.getNewLessonStartTime();
        if (this$newLessonStartTime == null ? other$newLessonStartTime != null : !((Object)this$newLessonStartTime).equals(other$newLessonStartTime)) {
            return false;
        }
        Long this$newLessonEndTime = this.getNewLessonEndTime();
        Long other$newLessonEndTime = other.getNewLessonEndTime();
        if (this$newLessonEndTime == null ? other$newLessonEndTime != null : !((Object)this$newLessonEndTime).equals(other$newLessonEndTime)) {
            return false;
        }
        String this$newTeacherName = this.getNewTeacherName();
        String other$newTeacherName = other.getNewTeacherName();
        if (this$newTeacherName == null ? other$newTeacherName != null : !this$newTeacherName.equals(other$newTeacherName)) {
            return false;
        }
        String this$newClassroom = this.getNewClassroom();
        String other$newClassroom = other.getNewClassroom();
        if (this$newClassroom == null ? other$newClassroom != null : !this$newClassroom.equals(other$newClassroom)) {
            return false;
        }
        String this$orgMobile = this.getOrgMobile();
        String other$orgMobile = other.getOrgMobile();
        return !(this$orgMobile == null ? other$orgMobile != null : !this$orgMobile.equals(other$orgMobile));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CourseUpdateMsgToStu;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $courseName = this.getCourseName();
        result = result * 59 + ($courseName == null ? 43 : $courseName.hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        Integer $lessonNo = this.getLessonNo();
        result = result * 59 + ($lessonNo == null ? 43 : ((Object)$lessonNo).hashCode());
        Long $oldLessonStartTime = this.getOldLessonStartTime();
        result = result * 59 + ($oldLessonStartTime == null ? 43 : ((Object)$oldLessonStartTime).hashCode());
        Long $oldLessonEndTime = this.getOldLessonEndTime();
        result = result * 59 + ($oldLessonEndTime == null ? 43 : ((Object)$oldLessonEndTime).hashCode());
        Long $newLessonStartTime = this.getNewLessonStartTime();
        result = result * 59 + ($newLessonStartTime == null ? 43 : ((Object)$newLessonStartTime).hashCode());
        Long $newLessonEndTime = this.getNewLessonEndTime();
        result = result * 59 + ($newLessonEndTime == null ? 43 : ((Object)$newLessonEndTime).hashCode());
        String $newTeacherName = this.getNewTeacherName();
        result = result * 59 + ($newTeacherName == null ? 43 : $newTeacherName.hashCode());
        String $newClassroom = this.getNewClassroom();
        result = result * 59 + ($newClassroom == null ? 43 : $newClassroom.hashCode());
        String $orgMobile = this.getOrgMobile();
        result = result * 59 + ($orgMobile == null ? 43 : $orgMobile.hashCode());
        return result;
    }
}

