/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.coursestart;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONObject;

public class CourseStartMsgToStu
extends WechatTemplateMsg {
    private Integer orgId;
    private String openId;
    private String orgName;
    private String courseName;
    private String studentName;
    private String teacherName;
    private Integer lessonNo;
    private Long lessonStartTime;
    private Long lessonEndTime;
    private String classroom;

    public CourseStartMsgToStu() {
        this.msgType = WechateTemplateMsgType.COURSE_START_TO_STU;
    }

    public String buildTemplateMsg(String templateId) {
        SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat daySdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeSdf = new SimpleDateFormat("HH:mm");
        String firstFmt = "\u3010%s\u3011,\u60a8\u597d:\n\n\u60a8\u5728\u3010%s\u3011\u7684\u3010%s\u3011\u3010\u7b2c%s\u6b21\u8bfe\u3011\u5c06\u5728\u3010%s\u3011\u5f00\u59cb\u4e0a\u8bfe\u3002\u8d76\u5feb\u51fa\u53d1\u5427\u3002\n\u5730\u5740\uff1a\u3010%s\u3011";
        this.first = String.format(firstFmt, this.studentName, this.orgName, this.courseName, this.lessonNo, dateSdf.format(this.lessonStartTime), this.classroom);
        this.remark = "\u522b\u8fdf\u5230\u54e6~~";
        JSONObject data = new JSONObject();
        data.put((Object)"keyword1", (Object)CourseStartMsgToStu.getTemplateMsgNode(String.format("%s %s - %s", daySdf.format(new Date(this.lessonStartTime)), timeSdf.format(new Date(this.lessonStartTime)), timeSdf.format(new Date(this.lessonEndTime)))));
        data.put((Object)"keyword2", (Object)CourseStartMsgToStu.getTemplateMsgNode(this.teacherName));
        data.put((Object)"keyword3", (Object)CourseStartMsgToStu.getTemplateMsgNode(this.courseName));
        data.put((Object)"keyword4", (Object)CourseStartMsgToStu.getTemplateMsgNode(this.classroom));
        return super.buildBaseTemplateMsg(this.openId, templateId, data).toString();
    }

    public static CourseStartMsgToStu fromJsonStr(String jsonStr) {
        CourseStartMsgToStu msg = new CourseStartMsgToStu();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        msg.fillBaseInfo(jsonStr);
        msg.setOrgId(json.optInt("orgId"));
        msg.setOpenId(json.getString("openId"));
        msg.setOrgName(json.optString("orgName"));
        msg.setCourseName(json.optString("courseName"));
        msg.setStudentName(json.optString("studentName"));
        msg.setTeacherName(json.optString("teacherName"));
        msg.setLessonNo(json.optInt("lessonNo"));
        msg.setLessonStartTime(json.optLong("lessonStartTime"));
        msg.setLessonEndTime(json.optLong("lessonEndTime"));
        msg.setClassroom(json.optString("classroom"));
        return msg;
    }

    public String toJsonStr() {
        JSONObject json = super.getBaseJson();
        json.put((Object)"orgId", this.checkNull(this.orgId));
        json.put((Object)"openId", this.checkNull(this.openId));
        json.put((Object)"orgName", this.checkNull(this.orgName));
        json.put((Object)"courseName", this.checkNull(this.courseName));
        json.put((Object)"studentName", this.checkNull(this.studentName));
        json.put((Object)"teacherName", this.checkNull(this.teacherName));
        json.put((Object)"lessonNo", this.checkNull(this.lessonNo));
        json.put((Object)"lessonStartTime", this.checkNull(this.lessonStartTime));
        json.put((Object)"lessonEndTime", this.checkNull(this.lessonEndTime));
        json.put((Object)"classroom", this.checkNull(this.classroom));
        return json.toString();
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = Integer.parseInt(orgId.toString());
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public String getTeacherName() {
        return this.teacherName;
    }

    public Integer getLessonNo() {
        return this.lessonNo;
    }

    public Long getLessonStartTime() {
        return this.lessonStartTime;
    }

    public Long getLessonEndTime() {
        return this.lessonEndTime;
    }

    public String getClassroom() {
        return this.classroom;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setTeacherName(String teacherName) {
        this.teacherName = teacherName;
    }

    public void setLessonNo(Integer lessonNo) {
        this.lessonNo = lessonNo;
    }

    public void setLessonStartTime(Long lessonStartTime) {
        this.lessonStartTime = lessonStartTime;
    }

    public void setLessonEndTime(Long lessonEndTime) {
        this.lessonEndTime = lessonEndTime;
    }

    public void setClassroom(String classroom) {
        this.classroom = classroom;
    }

    @Override
    public String toString() {
        return "CourseStartMsgToStu(orgId=" + this.getOrgId() + ", openId=" + this.getOpenId() + ", orgName=" + this.getOrgName() + ", courseName=" + this.getCourseName() + ", studentName=" + this.getStudentName() + ", teacherName=" + this.getTeacherName() + ", lessonNo=" + this.getLessonNo() + ", lessonStartTime=" + this.getLessonStartTime() + ", lessonEndTime=" + this.getLessonEndTime() + ", classroom=" + this.getClassroom() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CourseStartMsgToStu)) {
            return false;
        }
        CourseStartMsgToStu other = (CourseStartMsgToStu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$orgId = this.getOrgId();
        Integer other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        if (this$openId == null ? other$openId != null : !this$openId.equals(other$openId)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$courseName = this.getCourseName();
        String other$courseName = other.getCourseName();
        if (this$courseName == null ? other$courseName != null : !this$courseName.equals(other$courseName)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        String this$teacherName = this.getTeacherName();
        String other$teacherName = other.getTeacherName();
        if (this$teacherName == null ? other$teacherName != null : !this$teacherName.equals(other$teacherName)) {
            return false;
        }
        Integer this$lessonNo = this.getLessonNo();
        Integer other$lessonNo = other.getLessonNo();
        if (this$lessonNo == null ? other$lessonNo != null : !((Object)this$lessonNo).equals(other$lessonNo)) {
            return false;
        }
        Long this$lessonStartTime = this.getLessonStartTime();
        Long other$lessonStartTime = other.getLessonStartTime();
        if (this$lessonStartTime == null ? other$lessonStartTime != null : !((Object)this$lessonStartTime).equals(other$lessonStartTime)) {
            return false;
        }
        Long this$lessonEndTime = this.getLessonEndTime();
        Long other$lessonEndTime = other.getLessonEndTime();
        if (this$lessonEndTime == null ? other$lessonEndTime != null : !((Object)this$lessonEndTime).equals(other$lessonEndTime)) {
            return false;
        }
        String this$classroom = this.getClassroom();
        String other$classroom = other.getClassroom();
        return !(this$classroom == null ? other$classroom != null : !this$classroom.equals(other$classroom));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CourseStartMsgToStu;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $courseName = this.getCourseName();
        result = result * 59 + ($courseName == null ? 43 : $courseName.hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        String $teacherName = this.getTeacherName();
        result = result * 59 + ($teacherName == null ? 43 : $teacherName.hashCode());
        Integer $lessonNo = this.getLessonNo();
        result = result * 59 + ($lessonNo == null ? 43 : ((Object)$lessonNo).hashCode());
        Long $lessonStartTime = this.getLessonStartTime();
        result = result * 59 + ($lessonStartTime == null ? 43 : ((Object)$lessonStartTime).hashCode());
        Long $lessonEndTime = this.getLessonEndTime();
        result = result * 59 + ($lessonEndTime == null ? 43 : ((Object)$lessonEndTime).hashCode());
        String $classroom = this.getClassroom();
        result = result * 59 + ($classroom == null ? 43 : $classroom.hashCode());
        return result;
    }
}

