/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.courseplan;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONObject;

public class CoursePlanMsgToStu
extends WechatTemplateMsg {
    private Integer orgId;
    private String openId;
    private String orgName;
    private String courseName;
    private String studentName;
    private String teacherName;
    private Long startTime;
    private Long endTime;
    private String orgMobile;

    public CoursePlanMsgToStu() {
        this.msgType = WechateTemplateMsgType.COURSE_PLAN_TO_STU;
    }

    public String buildTemplateMsg(String templateId) {
        String firstFmt = "\u3010%s\u3011,\u60a8\u597d:\n\n\u60a8\u5728\u3010%s\u3011\u7684\u3010%s\u3011\u5df2\u7ecf\u5b8c\u6210\u8bfe\u7a0b\u5b89\u6392";
        this.first = String.format(firstFmt, this.studentName, this.orgName, this.courseName);
        this.remark = "\u70b9\u51fb\u67e5\u770b\u8bfe\u8868\u3002";
        JSONObject data = new JSONObject();
        data.put((Object)"keyword1", (Object)CoursePlanMsgToStu.getTemplateMsgNode(this.orgName));
        if (this.startTime != null && this.endTime != null) {
            SimpleDateFormat daySdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeSdf = new SimpleDateFormat("hh:mm");
            data.put((Object)"keyword2", (Object)CoursePlanMsgToStu.getTemplateMsgNode(String.format("%s %s - %s", daySdf.format(new Date(this.startTime)), timeSdf.format(new Date(this.endTime)), timeSdf.format(new Date(this.endTime)))));
        } else {
            data.put((Object)"keyword2", (Object)CoursePlanMsgToStu.getTemplateMsgNode("-"));
        }
        data.put((Object)"keyword3", (Object)CoursePlanMsgToStu.getTemplateMsgNode(this.courseName));
        data.put((Object)"keyword4", (Object)CoursePlanMsgToStu.getTemplateMsgNode(this.teacherName != null ? this.teacherName : "-"));
        data.put((Object)"keyword5", (Object)CoursePlanMsgToStu.getTemplateMsgNode("\u5982\u6709\u7591\u95ee,\u8bf7\u8054\u7cfb\u673a\u6784:" + this.orgMobile));
        return super.buildBaseTemplateMsg(this.openId, templateId, data).toString();
    }

    public static CoursePlanMsgToStu fromJsonStr(String jsonStr) {
        CoursePlanMsgToStu msg = new CoursePlanMsgToStu();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        msg.fillBaseInfo(jsonStr);
        msg.setOrgId(json.optInt("orgId"));
        msg.setOpenId(json.optString("openId"));
        msg.setOrgName(json.optString("orgName"));
        msg.setCourseName(json.optString("courseName"));
        msg.setStudentName(json.optString("studentName"));
        msg.setTeacherName(json.optString("teacherName"));
        msg.setStartTime(json.optLong("startTime"));
        msg.setEndTime(json.optLong("endTime"));
        msg.setOrgMobile(json.optString("orgMobile"));
        return msg;
    }

    public String toJsonStr() {
        JSONObject json = super.getBaseJson();
        json.put((Object)"orgId", this.checkNull(this.orgId));
        json.put((Object)"openId", this.checkNull(this.openId));
        json.put((Object)"orgName", this.checkNull(this.orgName));
        json.put((Object)"courseName", this.checkNull(this.courseName));
        json.put((Object)"studentName", this.checkNull(this.studentName));
        json.put((Object)"teacherName", this.checkNull(this.teacherName));
        json.put((Object)"startTime", this.checkNull(this.startTime));
        json.put((Object)"endTime", this.checkNull(this.endTime));
        json.put((Object)"orgMobile", this.checkNull(this.orgMobile));
        return json.toString();
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = Integer.parseInt(orgId.toString());
    }

    public Integer getOrgId() {
        return this.orgId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public String getTeacherName() {
        return this.teacherName;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getOrgMobile() {
        return this.orgMobile;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setTeacherName(String teacherName) {
        this.teacherName = teacherName;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setOrgMobile(String orgMobile) {
        this.orgMobile = orgMobile;
    }

    @Override
    public String toString() {
        return "CoursePlanMsgToStu(orgId=" + this.getOrgId() + ", openId=" + this.getOpenId() + ", orgName=" + this.getOrgName() + ", courseName=" + this.getCourseName() + ", studentName=" + this.getStudentName() + ", teacherName=" + this.getTeacherName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", orgMobile=" + this.getOrgMobile() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoursePlanMsgToStu)) {
            return false;
        }
        CoursePlanMsgToStu other = (CoursePlanMsgToStu)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$orgId = this.getOrgId();
        Integer other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        if (this$openId == null ? other$openId != null : !this$openId.equals(other$openId)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$courseName = this.getCourseName();
        String other$courseName = other.getCourseName();
        if (this$courseName == null ? other$courseName != null : !this$courseName.equals(other$courseName)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        String this$teacherName = this.getTeacherName();
        String other$teacherName = other.getTeacherName();
        if (this$teacherName == null ? other$teacherName != null : !this$teacherName.equals(other$teacherName)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$orgMobile = this.getOrgMobile();
        String other$orgMobile = other.getOrgMobile();
        return !(this$orgMobile == null ? other$orgMobile != null : !this$orgMobile.equals(other$orgMobile));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CoursePlanMsgToStu;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $courseName = this.getCourseName();
        result = result * 59 + ($courseName == null ? 43 : $courseName.hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        String $teacherName = this.getTeacherName();
        result = result * 59 + ($teacherName == null ? 43 : $teacherName.hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $orgMobile = this.getOrgMobile();
        result = result * 59 + ($orgMobile == null ? 43 : $orgMobile.hashCode());
        return result;
    }
}

