/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.mediatype;

import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MediaTypeDto {
    private String name;
    private int mediaType;
    private String url;

    public MediaTypeDto(MediaType type, OrgWechatDto orgWechatDto) {
        this.name = type.getLabel();
        this.mediaType = type.getValue();
        this.url = type.getUrl(orgWechatDto);
    }

    public static List<MediaTypeDto> buildMediaTypeList(List<Integer> mediaTypeIds, AuthorizerInfo authorizerInfo, OrgWechatDto orgWechatDto) {
        ArrayList<MediaTypeDto> list = new ArrayList<MediaTypeDto>();
        MediaTypeDto dto = null;
        if (mediaTypeIds != null && !mediaTypeIds.isEmpty()) {
            for (Integer mediaTypeValue : mediaTypeIds) {
                MediaType type = MediaType.getByVaule(mediaTypeValue);
                if (type.isWebauth() && !authorizerInfo.hasWebAuthPermission()) continue;
                dto = new MediaTypeDto(type, orgWechatDto);
                list.add(dto);
            }
        }
        return list;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String getName() {
        return this.name;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMediaType(int mediaType) {
        this.mediaType = mediaType;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

