/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.task;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.FansService;

/**   
 * @Title       : FansHeadImgSyncJob.java 
 * @Description :粉丝头像同步（将微信的url同步成跟谁学url）
 * @Author      : zhenyujian
 * @Date        : 2016年8月8日 上午11:48:14 
 */
@Slf4j
public class FansHeadImgSyncJob implements Runnable{
	
	private FansService fansService;
	private String authorizerAppId;
	
	public FansHeadImgSyncJob(FansService fansService, String authorizerAppId){
		this.fansService = fansService;
		this.authorizerAppId = authorizerAppId;
	}


	@Override
	public void run() {
		log.info("Wechat - FansHeadImgSyncJob - run - start - authorizerAppId:{}",authorizerAppId);
		
		try{
			fansService.batchConvertFansHeadImg(authorizerAppId);
		}catch(WechatException e){
			log.error("Wechat - FansHeadImgSyncJob - WechatException - e:{}",e);
		}catch(Exception e){
			log.error("Wechat - FansHeadImgSyncJob - Exception - e:{}",e);
		}finally{
		}
		log.info("Wechat - FansHeadImgSyncJob - run - end authorizerAppId:{}",authorizerAppId);
	}

}

