/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.SubscribeQRCodeDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.SubscribeQRCode;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.image.OrgQrImageUtils;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatQRCodeService;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.HeadQRCodeInfoDto;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.util.FileUploadUtils;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;

import javax.imageio.ImageIO;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class WechatQRCodeServiceImpl implements WechatQRCodeService{
	
	@Autowired
	private AuthorizationInfoService authorizationInfoService;
	
	@Autowired
	private AuthorizerInfoDao authorizerInfoDao;
	@Autowired
	private SubscribeQRCodeDao subscribeQRCodeDao;
	@Autowired
	private OrgInfoDao orgInfoDao;
	@Autowired
	private OrgStorageDao orgStorageDao;
	
	@Autowired
	private WechatFreeVersionService freeVersionService;
	
	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public String getQRCodeHeadImgUrl(Integer orgId) {
		SubscribeQRCode code = getQRCode(orgId);
		return code!=null ? code.getHeadQrCode():null;
	}

	
	
	
	@Override
	public SubscribeQRCode getQRCode(Integer orgId) {
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		boolean isFreeAccount = false;
		if(authorizerInfo == null){
			if(freeVersionService.isFreeAccount(orgId)){
				//是免费版
				authorizerInfo = freeVersionService.getFAAuthorizerInfo();
				isFreeAccount = true;
			}else{
				log.warn("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - authorizationInfo is null");
				//返回
				return null;
			}
		}
		
		SubscribeQRCode qrCode = subscribeQRCodeDao.getQRCode(orgId, authorizerInfo.getAuthorizerAppId());
		String qrCodeImgUrl = null;
		String headQRCodeImgUrl = null;
		if(qrCode==null){
			try {
		        //关注二维码
				if(isFreeAccount){
					//免费版(大众版)
					String accessToken = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId()).getAuthorizerAccessToken();
					QRCodeDto qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForSubscribeWithOrgId(accessToken, orgId);
					qrCodeImgUrl = WechatQRCodeLinkHelper.getGsxImgUrl(qrCodeDto);
				}else{//正式版
					if( authorizerInfo.getQrcodeStorageId()!=null ){
				        OrgStorage orgStorage = orgStorageDao.getById(authorizerInfo.getQrcodeStorageId());
				        if (orgStorage == null) {
				        	qrCodeImgUrl =  authorizerInfo.getQrcodeUrl();
				        } else {
				        	qrCodeImgUrl = StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
				        }
			        }else{
			        	log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - QrcodeStorageId is null");
			        	return null;
			        }
				}
		        
		        //微信文章底部 拼图二维码
		        headQRCodeImgUrl = makeHeadQRCodeImgUrl(orgId, qrCodeImgUrl, authorizerInfo.getNickName());
	            
            	qrCode = new SubscribeQRCode();
            	qrCode.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
            	qrCode.setHeadQrCode(headQRCodeImgUrl);
            	qrCode.setQrCode(qrCodeImgUrl);
            	qrCode.setCreateTime(new Date());
            	qrCode.setOrgId(orgId.intValue());
            	qrCode.setHeadQrCode( makeHeadQRCodeInfo(orgId, authorizerInfo.getNickName()).toJsonStr() );
            	subscribeQRCodeDao.save(qrCode);
            	
	        } catch (Exception e) {
	        	log.error("wechat - SubscribeQRCodeServiceImpl - getQRCodeUrl - exception",e);
	        	return null;
	        }
		}else{
			//检查 headOrCode 图片内信息是否发生了变化
			String newHeadQrCodeInfo = makeHeadQRCodeInfo(orgId, authorizerInfo.getNickName()).toJsonStr();
			if( !qrCode.getHeadQrCodeInfo().equals(newHeadQrCodeInfo) ){
				headQRCodeImgUrl = makeHeadQRCodeImgUrl(orgId, qrCode.getQrCode(), authorizerInfo.getNickName());
				qrCode.setHeadQrCode(headQRCodeImgUrl);
				qrCode.setHeadQrCodeInfo(newHeadQrCodeInfo);
				subscribeQRCodeDao.update(qrCode);
			}
		}
		
		return qrCode;
	}
	
	
	
	String makeHeadQRCodeImgUrl(Integer orgId,String qrCodeImgUrl, String wxNick){
		String headQRCodeImgUrl = null;
		
		OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
		File localFile = null;
		UploadResult result = null;
        String name = StringUtils.isNotBlank(orgInfo.getName()) ? orgInfo.getName() : orgInfo.getShortName();
        
        try{
	        BufferedImage image = OrgQrImageUtils.generateOrgQrFingerPrintImg(name, qrCodeImgUrl, orgInfo.getExtension(), wxNick);
	        localFile = new File( LocalFileHelper.getTmpFileName(MIMEType.JPG.getExtension()) );
	        ImageIO.write(image, MIMEType.JPG.getExtension(), localFile);
	        
	        result = FileUploadUtils.uploadToRemote(Long.parseLong(orgId+""), localFile, false);
	        headQRCodeImgUrl = result.getFiles().get(0).getUrl();
        
        }catch(Exception e){
        	log.error("makeHeadQRCodeImgUrl - exception",e);
        }finally{
        	if (localFile != null) {
            	LocalFileHelper.deleteFile(localFile);
            }
        }
        
        return headQRCodeImgUrl;
	}

	
	HeadQRCodeInfoDto makeHeadQRCodeInfo(Integer orgId, String wxNick){
		OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
		String name = StringUtils.isNotBlank(orgInfo.getName()) ? orgInfo.getName() : orgInfo.getShortName();
		 
		HeadQRCodeInfoDto dto = new HeadQRCodeInfoDto();
		dto.setOrgShowName(name);
		dto.setWechatAppNick(wxNick);
		
        return dto;
	}
}

