/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;


import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;

@Service
@Slf4j
public class FreeVersionServiceImpl implements WechatFreeVersionService{
	
	@Autowired
	private OrgSubAccountDao orgSubAccountDao;
	@Autowired
	private TXAccountDao txAccountDao;
	@Autowired
	private AuthorizerInfoDao authorizerInfoDao;

	@Autowired
	private AuthorizationInfoDao authorizationInfoDao;
	
	
	@Override
	public boolean isFreeAccount(Integer orgId) {
		
		Integer target = orgId.intValue();
		OrgSubAccount subAccount = orgSubAccountDao.getByOrgId(orgId);
		if(subAccount!=null && subAccount.getPid()!=null && subAccount.getPid()>0){
			target = subAccount.getPid(); 
		}
		
		TXAccount txAccount = txAccountDao.getByOrgId(target);
		if(txAccount==null){
			log.error("txAccount is null orgId:{},target:{}", orgId, target);
			return false;
		}
		if(txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()){
			return true;
		} 
		
		return false;
	}

	
	
	@Override
	public boolean isFreeAccount(String appId) {
		if(appId.equals(WechatProperties.getWechatAppidForFreeVersion())){
			return true;
		}
		return false;
	}
	

	@Override
	public AuthorizerInfo getFAAuthorizerInfo() {
		String appid = WechatProperties.getWechatAppidForFreeVersion(); 
		return authorizerInfoDao.getByAuthorizerAppId(appid);
	}



	@Override
	public boolean isFreeAccountOrUnBindWechatApp(Integer orgId) {
		if(isFreeAccount(orgId)){
			return true;
		}
		
		if(authorizationInfoDao.getByOrgId(orgId)==null){
			return true;
		}
		
		return false;
		
	}


	
	
	
}


