/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.dao.ComponentAccessTokenDao;
import com.baijia.tianxiao.dal.wechat.dao.ComponentVerifyTicketDao;
import com.baijia.tianxiao.dal.wechat.po.ComponentAccessToken;
import com.baijia.tianxiao.sal.wechat.api.ComponentAccessTokenService;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.openplat.OpenPlatApiHelper;

/**   
 * @Title       : ComponentAccessTokenServiceImpl 
 * @Description : 见 https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318587&lang=zh_CN
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午2:05:55 
 */
@Service
public class ComponentAccessTokenServiceImpl implements ComponentAccessTokenService {

    private static final Logger logger = LoggerFactory.getLogger(ComponentAccessTokenServiceImpl.class);

    @Autowired
    private ComponentAccessTokenDao componentAccessTokenDao;
    @Autowired
    private ComponentVerifyTicketDao componentVerifyTicketDao;

    
    @Transactional(readOnly = true)
    @Override
    public ComponentAccessToken getByAppId(String appId) {
        return componentAccessTokenDao.getByAppId(appId);
    }

    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update() {
    	OpenPlatformInfoDto openPlatformInfo = WechatProperties.getOpenPlatformInfo();
    	String componentVerifyTicket = componentVerifyTicketDao.getByAppId(openPlatformInfo.getAppId()).getComponentVerifyTicket();;
    	ComponentAccessToken newToken = OpenPlatApiHelper.requestComponentAccessToken(openPlatformInfo.getAppId(), openPlatformInfo.getAppSecret(), componentVerifyTicket);

        ComponentAccessToken token = getByAppId(newToken.getAppId());
        if (token == null) {
            componentAccessTokenDao.save(newToken,true);
            logger.info("wechat - add new component access token:{}", newToken);
            return;
        }else{
        	token.setUpdateTime(new Date());
            token.setExpiresIn(newToken.getExpiresIn());
            token.setComponentAccessToken(newToken.getComponentAccessToken());
            componentAccessTokenDao.update(token,true);
            logger.info("wechat - update new component access token:{}", newToken);
            return;
        }
    }
}
