/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.webauth;

import java.util.HashMap;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;

/**   
 * @title       : WechatWebAuthCaller 
 * @description : 微信网页授权
 * 				  https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318590&token=&lang=zh_CN
 * @author      : zhenyujian
 * @date        : 2016年1月6日 下午6:00:40 
 */
@Slf4j
public class WechatWebAuthCaller {
	
	
	/**
	 * @Description  : 通过微信 '网页授权' 的code换取 '用户网页授权token'
	 * @Author       : zhenyujian
	 * @CreationDate : 2016年1月6日 下午4:14:33 
	 *
	 * @Return       : String
	 */
	public static WechatApiResponse getWebAuthorization(String appId, String code, String compAppId, String compAccessToken){
		try{
			String url = "https://api.weixin.qq.com/sns/oauth2/component/access_token";
			Map<String,Object> parameterMap = new HashMap<String,Object>();
			parameterMap.put("appid", appId );
			parameterMap.put("code", code);
			parameterMap.put("grant_type", "authorization_code");
			parameterMap.put("component_appid", compAppId );
			parameterMap.put("component_access_token", compAccessToken );
			
			return WechatRemoteCallHelper.get(url, parameterMap);
		}catch(Exception e){
			log.warn("getWebAuthorization - exception - appId:{},code:{}",appId,code);
			return null;
		}
	}
	

	
	/**
	 * @Description  : 查询通过 '网页授权' 用户的基本信息   这里的accessToken是网页授权获得的 '用户网页授权token', 不是'服务号的accessToken'
	 * 				   见 http://mp.weixin.qq.com/wiki/17/c0f37d5704f0b64713d5d2c37b468d75.html
	 * @Author       : zhenyujian
	 * @CreationDate : 2016年1月6日 下午2:05:49 
	 *
	 * @Return       : String
	 */
	public static WechatApiResponse getUserInfoByWebAuth(String webAuthAccessToken, String openId){
		try{
			String url = "https://api.weixin.qq.com/sns/userinfo";
			
			Map<String,Object> params = new HashMap<String,Object>();
			params.put("access_token", webAuthAccessToken);
			params.put("openid", openId);
			params.put("lang", "zh_CN");
			
			return WechatRemoteCallHelper.get(url, params);
		}catch(Exception e){
			log.warn("getUserInfoByWebAuth - exception - accessToken:{},openId:{},e:{}",webAuthAccessToken, openId,e);
			return null;
		}
	}

}

