/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.statistics;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSummaryDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.util.date.DateUtil;

/**
 * @author : zhenyujian
 * @title : DataStatisticsApiHelper
 * @description : 微信公众平台 数据统计相关接口
 * @date : 2015年12月17日 下午1:59:14
 */
public class DataStatisticsApiHelper {

    public static FansSCDto getFansSCDto(String accessToken, Date beginDate, Date endDate, Date dateForCumulate) throws ParseException {
        FansSCDto dto = new FansSCDto();
        dto.setStartDate(DateUtil.getStrByDate(beginDate));
        dto.setEndDate(DateUtil.getStrByDate(endDate));

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        //查询昨日数据统计
        //累计数据
        WechatApiResponse ytCumulateResp = DataStatisticsApiCaller.getFansCumulate(accessToken, dateForCumulate, dateForCumulate);
        //分日数据
        WechatApiResponse ytSummaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, dateForCumulate, dateForCumulate);

        int cancelFansForCumulate = 0;
        int newFansForCumulate = 0;
        int totalFansForCumulate = 0;

        JSONObject ytSummaryRootNode = ytSummaryResp.getRootJSONObj();
        JSONArray ytSummaryArray = ytSummaryRootNode.getJSONArray("list");
        if (ytSummaryArray != null && ytSummaryArray.size() > 0) {
            JSONObject obj;
            for (int i = 0; i < ytSummaryArray.size(); i++) {
                obj = ytSummaryArray.getJSONObject(i);
                cancelFansForCumulate += obj.getInt("cancel_user");
                newFansForCumulate += obj.getInt("new_user");
            }
        }

        JSONObject ytCumulateRootNode = ytCumulateResp.getRootJSONObj();
        JSONArray ytCumulateArray = ytCumulateRootNode.getJSONArray("list");
        if (ytCumulateArray != null && !ytCumulateArray.isEmpty()) {
            totalFansForCumulate = ytCumulateArray.getJSONObject(0).getInt("cumulate_user");
            dto.setYtDate(sdf.format(dateForCumulate));
            dto.setYtCancelFans(cancelFansForCumulate);
            dto.setYtNewFans(newFansForCumulate);
            dto.setYtFansDiff(newFansForCumulate - cancelFansForCumulate);
            dto.setYtCumulateFans(totalFansForCumulate);
        }
        

        //查询分日数据统计
        List<FansSummaryDto> fansSummaryDtoList = new ArrayList<FansSummaryDto>();
        List<Date> dateList = DateUtil.getDateBetween(beginDate, endDate);

        if (dateList != null && !dateList.isEmpty()) {
            LinkedHashMap<String, FansSummaryDto> symmaryMap = new LinkedHashMap<String, FansSummaryDto>();
            FansSummaryDto fansSummaryDto;
            for (Date date : dateList) {
                fansSummaryDto = new FansSummaryDto(sdf.format(date));
                symmaryMap.put(sdf.format(date), fansSummaryDto);
            }

            WechatApiResponse summaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, beginDate, endDate);
            JSONObject summaryRootNode = summaryResp.getRootJSONObj();
            JSONArray summaryArray = summaryRootNode.getJSONArray("list");
            if (summaryArray != null & !summaryArray.isEmpty()) {
                JSONObject obj;
                FansSummaryDto fsdto;
                for (int i = 0; i < summaryArray.size(); i++) {
                    obj = summaryArray.getJSONObject(i);
                    fsdto = symmaryMap.get(obj.getString("ref_date"));
                    fsdto.setCancelFans(fsdto.getCancelFans() + obj.getInt("cancel_user"));
                    
                    fsdto.setNewFans(fsdto.getNewFans() + obj.getInt("new_user"));
                    fsdto.setFansDiff(fsdto.getNewFans() - fsdto.getCancelFans());
                    fsdto.setFlag(true);
                }
            }

            for (FansSummaryDto fsdto : symmaryMap.values()) {
                fansSummaryDtoList.add(fsdto);
            }
        }
        dto.setSummary(fansSummaryDtoList);
        return dto;
    }

}

