/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.common;

import java.util.Date;
import java.util.Random;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;


/**
 * @title WechatCryptUtils
 * @desc TODO
 * @author wangzhigang
 * @date 2015年8月22日
 * @version 1.0
 */
public class WechatCryptUtils {

	public static String encryptMsg(String xmlMsg)
	        throws Exception {
	        String appId = WechatProperties.getOpenAppId();
	        String token = WechatProperties.getOpenMsgToken();
	        String encodingAesKey = WechatProperties.getEncodingAesKey();
	        WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);

	        String timestamp = getTimestamp();
	        String nonce = getNonce();
	        
	        return pc.encryptMsg(xmlMsg, timestamp, nonce);
	    }
	
    public static String encryptMsg(String fromUserName, String toUserName, String msgType, String content)
        throws Exception {
        String appId = WechatProperties.getOpenAppId();
        String token = WechatProperties.getOpenMsgToken();
        String encodingAesKey = WechatProperties.getEncodingAesKey();
        WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);

        String timestamp = getTimestamp();
        String nonce = getNonce();

        String xmlMsg = generateXml(fromUserName, toUserName, msgType, content, timestamp);
        return pc.encryptMsg(xmlMsg, timestamp, nonce);
    }

    private static String getTimestamp() {
        return String.valueOf(new Date().getTime() / 1000);
    }

    private static String getNonce() {
        Random random = new Random();
        return String.valueOf(random.nextInt(9000000) + 1000000);
    }

    private static String generateXml(String toUserName, String fromUserName, String msgType, String content,
        String createTime) {
        String format =
            "<xml>" + "<ToUserName><![CDATA[%1$s]]></ToUserName>" + "<FromUserName><![CDATA[%2$s]]></FromUserName>"
                + "<MsgType><![CDATA[%3$s]]></MsgType>" + "<Content><![CDATA[%4$s]]></Content>"
                + "<CreateTime>%5$s</CreateTime>" + "</xml>";

        return String.format(format, toUserName, fromUserName, msgType, content, createTime);
    }

    public static String decryptMsg(String msgSignature, String timestamp, String nonce, String plainText) {
        try {
        	String appId = WechatProperties.getOpenAppId();
            String token = WechatProperties.getOpenMsgToken();
            String encodingAesKey = WechatProperties.getEncodingAesKey();
            WXBizMsgCrypt pc = new WXBizMsgCrypt(token, encodingAesKey, appId);

            String[] encrytMsg = XMLParse.extractMessage(plainText);
            return pc.decryptMsg(msgSignature, timestamp, nonce, encrytMsg);

        } catch (Exception e) {
            throw new WebServiceException("parse response exception", e);
        }
    }

}
