/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import java.io.UnsupportedEncodingException;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.util.ShortUrlUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * @title : PassiveReplyMsgHelper
 * @description : 自动回复 (通过返回字符串形式 不需要任何权限)
 * @author : zhenyujian
 * @date : 2016年1月13日 下午2:42:37
 */
@Slf4j
public class PassiveReplyMsgHelper {
    /**
     * @Description : 发送关注回复消息
     * @Author : zhenyujian
     * @Date : 2016年1月5日 上午11:58:36
     *
     * @Return : boolean
     */
    public static String getSubscribeReply(String fromUser, String toUser, OrgWechatReplyForSubscribe reply) {
        String result = "success";
        if (reply == null) {
            return result;
        }

        try {
            MediaType type = MediaType.getByVaule(reply.getMediaType());

            if (MediaType.UNKNOWN == type) {// 占位元素
                return result;

            } else if (MediaType.IMAGE == type) {// 图片消息
                if (StringUtils.isNotBlank(reply.getMediaId())) {
                    result = PassiveReplyMsgBuilder.imageMsg(fromUser, toUser, reply.getMediaId());
                }

            } else if (MediaType.VOICE == type) {

            } else if (MediaType.VIDEO == type) {

            } else if (MediaType.THUMB == type) {

            } else if (MediaType.NEWS == type) {// 图文消息

            } else if (MediaType.CONTENT == type) {// 文本消息
                if (StringUtils.isNotBlank(reply.getContent())) {
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, reply.getContent());
                }

            } else if (MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type
                || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type
                || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) {
                if (StringUtils.isNotBlank(reply.getUrl())) {
                    String fmt = "【%s】\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, fmt);
                }

            }
        } catch (Exception e) {
            log.error("wechat - PassiveReplyMsgHelper - sendSubscribeReply fail - fromUser:{}, toUser:{}, reply:{}",
                fromUser, toUser, reply);
        }

        return result;
    }

    /**
     * @Description : 发送关键词回复消息
     * @Author : zhenyujian
     * @Date : 2016年1月5日 下午3:46:23
     *
     * @Return : boolean
     */
    public static String getKeywordReply(String fromUser, String toUser, OrgWechatReplyForKeyword reply) {

        log.info("from user : {} and to User:{} ", fromUser, toUser);

        String result = "success";
        if (reply == null) {
            return result;
        }

        try {
            MediaType type = MediaType.getByVaule(reply.getMediaType());

            if (MediaType.UNKNOWN == type) {// 占位元素
                return result;

            } else if (MediaType.IMAGE == type) {// 图片消息
                if (StringUtils.isNotBlank(reply.getMediaId())) {
                    result = PassiveReplyMsgBuilder.imageMsg(fromUser, toUser, reply.getMediaId());
                }

            } else if (MediaType.VOICE == type) {

            } else if (MediaType.VIDEO == type) {

            } else if (MediaType.THUMB == type) {

            } else if (MediaType.NEWS == type) {// 图文消息

            } else if (MediaType.CONTENT == type) {// 文本消息
                if (StringUtils.isNotBlank(reply.getContent())) {
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, reply.getContent());
                }

            } else if (MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type
                || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type
                || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) {
                if (StringUtils.isNotBlank(reply.getUrl())) {
                    String fmt = "【%s】\n%s";
                    fmt = String.format(fmt, type.getLabel(), toShortUrl(reply.getUrl()));
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, fmt);
                }
            }
        } catch (Exception e) {
            log.error("error is : ", e);
            log.error("wechat - getKeywordReply - sendSubscribeReply fail - fromUser:{}, toUser:{}, reply:{}", fromUser,
                toUser, reply);
        }

        return result;
    }

    public static String toShortUrl(String url) throws UnsupportedEncodingException {
        // 这种判断不靠谱,这种情况针对营销活动
        if (url.contains("activityId") && url.contains("activityType")) {
            if (url.startsWith("http://") && url.contains("https://")) {
                url = url.substring("http://".length());
            }
            url = ShortUrlUtil.getShortUrl(url);
        } else {
            log.info("need not to change for url : {} ", url);
        }
        return url;
    }

}
