/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2014 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper;

import java.util.Properties;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.sal.wechat.dto.wechatapi.OpenPlatformInfoDto;
import com.baijia.tianxiao.util.properties.PropertiesReader;


/**   
 * @Title       : WechatProperties 
 * @Description : 
 * @Author      : zhenyujian
 * @Date        : 2015年12月2日 下午4:14:31 
 */
public class WechatProperties {
	
	static final String PROPERTIES_FILE_NAME   = "wechat.properties";
	
	//upload
	static final String KEY_UPLOAD_DEFAULT_TMPDIR = "upload.defult.tmpdir";
	static final String KEY_UPLOAD_UID_PREFIX  = "upload.uid.prefix";
	static final String KEY_UPLOAD_SERVER      = "upload.server";
	
	//server
	static final String KEY_IMG_SERVER         = "img.server";
	static final String KEY_FILE_SERVER        = "file.server";
	static final String KEY_REDIS_DB           = "redis.db"; 
	
	//web domain
	static final String KEY_WBE_ERP_URL_PREFXI = "web.erp.url.prefix";
	static final String KEY_WBE_M_URL_PREFXI = "web.m.url.prefix";
	static final String KEY_WBE_CRM_URL_PREFXI = "web.crm.url.prefix";
	static final String KEY_WBE_MARKETING_URL_PREFXI = "web.marketing.url.prefix";
	static final String KEY_WBE_M_TIANXIAO_URL_PREFXI = "web.m.tianxiao.url.prefix";
	
	//wechat open platform
	static final String KEY_OEPN_APP_ID        = "wechat.open.app_id";
	static final String KEY_OEPN_APP_SECRET    = "wechat.open.app_secret";
	static final String KEY_OEPN_APP_MSG_TOKEN = "wechat.open.message.token";
	static final String KEY_OEPN_APP_MSG_KEY   = "wechat.open.message.key";
	static final String KEY_OPEN_AUTHCODE_CALLBACK_TEST_NUM = "wechat.open.auth_code.callback.testnumber";
	
	//wechat url
	static final String KEY_REGIST_URL         = "wechat.url.regist";
	static final String KEY_URL_PREFIX_BINDINGPAGE= "wechat.url.bindingpage.prefix";
	static final String KEY_WECHAT_WEBAUTH_URL_PREFIX = "wechat.url.webauth.prefix";
	
	//wechat free version
	static final String KEY_WECHAT_APPID_FREEVERSION = "wechat.appid.freeversion";
	
	//wechat media_type list
	static final String KEY_MEDIA_TYPE_LIST_MENU = "wechat.media_type.list.menu";
	static final String KEY_MEDIA_TYPE_LIST_AUTOREPLY = "wechat.media_type.list.autoreply";
	
	//wechat image
	static final String KEY_BUILTIN_MEDIA_NEWS_IMAGE = "wechat.image.builtin.media.news";
	static final String KEY_QRCODE_NOBIND_IMAGE = "wechat.image.qrcode.nobind";
	static final String KEY_ORG_CENTER_IMAGE = "wechat.image.org.center";
	
	static final String KEY_MOBILE_NUMBER_400_MAIN = "mobile.number.400.main";
	
	
	
    private static Properties prop = PropertiesReader.getProperties(PROPERTIES_FILE_NAME);

//    public static String getProperty(String name) {
//        return prop.getProperty(name);
//    }
    
    public static OpenPlatformInfoDto getOpenPlatformInfo(){
    	OpenPlatformInfoDto info = new OpenPlatformInfoDto();
    	info.setAppId( prop.getProperty(KEY_OEPN_APP_ID) );
    	info.setAppSecret( prop.getProperty(KEY_OEPN_APP_SECRET) );
    	return info;
    }
    
    public static String getWebAuthUrlPrefix(){
    	return prop.getProperty(KEY_WECHAT_WEBAUTH_URL_PREFIX);
    }
    
    public static String getOpenAppId(){
    	return prop.getProperty(KEY_OEPN_APP_ID);
    }
    
    public static String getOpenMsgToken(){
    	return prop.getProperty(KEY_OEPN_APP_MSG_TOKEN);
    }
    
    public static String getEncodingAesKey(){
    	return prop.getProperty(KEY_OEPN_APP_MSG_KEY);
    }
    
    public static String getImageServer(){
    	return prop.getProperty(KEY_IMG_SERVER);
    }
    
    public static String getFileServer(){
    	return prop.getProperty(KEY_FILE_SERVER);
    }
    
    public static String getKeyOpenAuthCodeCallBackTestNum(){
    	return prop.getProperty(KEY_OPEN_AUTHCODE_CALLBACK_TEST_NUM);
    }
    
    public static String getUpLoadDefaultTmpdir(){
    	return prop.getProperty(KEY_UPLOAD_DEFAULT_TMPDIR);
    } 
    
    public static String getUploadServer(){
    	return prop.getProperty(KEY_UPLOAD_SERVER);
    }
    
    public static String getUploadUidPrefix(){
    	return prop.getProperty(KEY_UPLOAD_UID_PREFIX);
    }
    
    public static String getRegistURL(){
    	return prop.getProperty(KEY_REGIST_URL);
    }
    
    public static String getBindPageUrlPrefix(){
    	return prop.getProperty(KEY_URL_PREFIX_BINDINGPAGE);
    }
    
    public static Integer getRedisDB(){
    	if( StringUtils.isBlank(prop.getProperty(KEY_REDIS_DB)) ){
    		return 6;
    	}
    	return Integer.parseInt(prop.getProperty(KEY_REDIS_DB));
    }
    
    
    public static String getWebERPUrlPrefix(){
    	return prop.getProperty(KEY_WBE_ERP_URL_PREFXI);
    }
    
    public static String getWebMUrlPrefix(){
    	return prop.getProperty(KEY_WBE_M_URL_PREFXI);
    }
    
    public static String getWebCRMUrlPrefix(){
    	return prop.getProperty(KEY_WBE_CRM_URL_PREFXI);
    }
    
    public static String getMediaTypeListForMenu(){
    	return prop.getProperty(KEY_MEDIA_TYPE_LIST_MENU);
    }
    
    public static String getMediaTypeListForAutoReply(){
    	return prop.getProperty(KEY_MEDIA_TYPE_LIST_AUTOREPLY);
    }
    
    public static String getWebMarketingUrlPrefix(){
    	return prop.getProperty(KEY_WBE_MARKETING_URL_PREFXI);
    }
    
    public static String getBuilitnMediaNewsImage(){
    	return prop.getProperty(KEY_BUILTIN_MEDIA_NEWS_IMAGE);
    }
    
    public static String getMobileNumber400Main(){
    	return prop.getProperty(KEY_MOBILE_NUMBER_400_MAIN);
    }
    
    public static String getWebMTianXiaoUrlPrefix(){
    	return prop.getProperty(KEY_WBE_M_TIANXIAO_URL_PREFXI);
    }
    
    public static String getWechatAppidForFreeVersion(){
    	return prop.getProperty(KEY_WECHAT_APPID_FREEVERSION);
    }
    
    public static String getWechatQrCodeNoBind(){
    	return prop.getProperty(KEY_QRCODE_NOBIND_IMAGE);
    }
    
    public static String getOrgCenterImg(){
    	return prop.getProperty(KEY_ORG_CENTER_IMAGE);
    }
    
}
