/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.coursestart;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;

import net.sf.json.JSONObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**   
 * @title       : CourseStartNoticeMsg 
 * @description : 上课提醒 - 学生
 * @author      : zhenyujian
 * @date        : 2016年1月5日 下午9:05:03 
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class CourseStartMsgToStu extends WechatTemplateMsg{
	
	private Integer orgId;
	private String openId;
	
	private String orgName;
	private String courseName;
	private String studentName;
	private String teacherName;
	private Integer lessonNo;//第几节课
	private Long lessonStartTime;
	private Long lessonEndTime;
	private String classroom;//教室名称
	
	
	
	public CourseStartMsgToStu(){
		this.msgType = WechateTemplateMsgType.COURSE_START_TO_STU;
	}
	
	
	/**
	 * @Description  : 创建微信模板消息 用于调用微信api
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:50:29 
	 *
	 * @Return       : String
	 */
	public String buildTemplateMsg(String templateId){
		SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		SimpleDateFormat daySdf = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat timeSdf = new SimpleDateFormat("HH:mm");
		
		String firstFmt = "【%s】,您好:\n\n您在【%s】的【%s】【第%s次课】将在【%s】开始上课。赶快出发吧。\n\n地址：【%s】";
		this.first = String.format(firstFmt, studentName, orgName, courseName, lessonNo, dateSdf.format(lessonStartTime), classroom);
		this.remark = "\n别迟到哦~~";
		
		JSONObject data = new JSONObject();
		data.put("keyword1", getTemplateMsgNode( String.format( "%s %s - %s", 
																daySdf.format(new Date(lessonStartTime)), 
																timeSdf.format(new Date(lessonStartTime)), 
																timeSdf.format(new Date(lessonEndTime)))) );
		data.put("keyword2", getTemplateMsgNode( teacherName ) );
		data.put("keyword3", getTemplateMsgNode( courseName ) );
		data.put("keyword4", getTemplateMsgNode( classroom ) );
		
		return super.buildBaseTemplateMsg(openId, templateId, data).toString();
	}
	
	
	
	/**
	 * @Description  : json转换成对象
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:30 
	 *
	 * @Return       : CourseStartNoticeMsg
	 */
	public static CourseStartMsgToStu fromJsonStr(String jsonStr){
		CourseStartMsgToStu msg = new CourseStartMsgToStu();
		
		JSONObject json = JSONObject.fromObject(jsonStr);
		msg.fillBaseInfo(jsonStr);
		msg.setOrgId( json.optInt("orgId") );
		msg.setOpenId( json.getString("openId"));
		
		msg.setOrgName( json.optString("orgName") );
		msg.setCourseName( json.optString("courseName") );
		msg.setStudentName( json.optString("studentName") );
		msg.setTeacherName( json.optString("teacherName") );
		msg.setLessonNo( json.optInt("lessonNo") );
		msg.setLessonStartTime( json.optLong("lessonStartTime") );
		msg.setLessonEndTime( json.optLong("lessonEndTime"));
		msg.setClassroom( json.optString("classroom") );

		return msg;
	}
	
	
	
	/**
	 * @Description  : 对象转换成json
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午12:29:38 
	 *
	 * @Return       : String
	 */
	public String toJsonStr(){
		JSONObject json = super.getBaseJson();
		json.put("orgId", checkNull(this.orgId) );
		json.put("openId", checkNull(this.openId));
		
		json.put("orgName", checkNull(this.orgName));
		json.put("courseName", checkNull(this.courseName));
		json.put("studentName", checkNull(this.studentName));
		json.put("teacherName", checkNull(this.teacherName));
		json.put("lessonNo", checkNull(this.lessonNo));
		json.put("lessonStartTime", checkNull(this.lessonStartTime));
		json.put("lessonEndTime", checkNull(this.lessonEndTime));
		json.put("classroom", checkNull(this.classroom));
		
		return json.toString();
	}
	
	public void setOrgId(Integer orgId){
		this.orgId = orgId;
	}
	public void setOrgId(Long orgId){
		this.orgId = Integer.parseInt(orgId.toString());
	}
}

