/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.msgtoapp;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import net.sf.json.JSONObject;
import lombok.Data;

/**   
 * @title       : MessagePushDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午1:53:09 
 */
@Data
public class MessageDto {

	private int msgT;
	private Long time;
	private int orgId;
	private String wechatAppid;
	private String wechatOpenId;
	private String nick;
	private String avatar;
	private MessageContentDto content;
	
	public MessageDto(){
	}
	
	public MessageDto(int msgT, Long time, int orgId, String wechatAppid, String wechatOpenId, String nick, String avatar){
		this.msgT = msgT;
		this.time = time;
		this.orgId = orgId;
		this.wechatAppid = wechatAppid;
		this.wechatOpenId = wechatOpenId;
		this.nick=nick;
		this.avatar=avatar;
	}
	
	public void setTextContent(String text){
		this.setContent( MessageContentDto.buildTextContent(text) );
	}

	public void setVoiceContent(int storageId, String url, int length){
		this.setContent( MessageContentDto.buildVoiceContent(storageId, url, length) );
	}
	
	public void setImageContent(int storageId, String url, int height, int width){
		this.setContent( MessageContentDto.buildImageContent(storageId, url, height, width));
	}
	
	public JSONObject toJson(){
		JSONObject json = new JSONObject();
		json.put("msgT", msgT);
		json.put("time", time);
		json.put("orgId", orgId);
		json.put("wechatAppid", wechatAppid);
		json.put("wechatOpenId", wechatOpenId);
		json.put("nick", nick );
		json.put("content", content.toJson());
		return json;
	}
	
	
	public String toJsonStr(){
		JSONObject json = toJson();
		String str = json.toString();
		return str.replace("\"text\":null", "\"text\":\"null\"");
	}
	
	
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

