/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.msgtoapp;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import net.sf.json.JSONObject;
import lombok.Data;

/**   
 * @title       : MessagePushContentDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午1:53:13 
 */
@Data
public class MessageContentDto {
	private String text;
	private int storageId;
	private String url;
	private int width;
	private int height;
	private int length;
	
	public MessageContentDto(){
	}
	
	static MessageContentDto buildTextContent(String text){
		MessageContentDto dto = new MessageContentDto();
		dto.setText(text);
		return dto;
	}
	
	static MessageContentDto buildVoiceContent(int storageId, String url, int length){
		MessageContentDto dto = new MessageContentDto();
		dto.setStorageId(storageId);
		dto.setUrl(url);
		dto.setLength(length);
		return dto;
	}

	static MessageContentDto buildImageContent(int storageId, String url, int height, int width){
		MessageContentDto dto = new MessageContentDto();
		dto.setStorageId(storageId);
		dto.setUrl(url);
		dto.setHeight(height);
		dto.setWidth(width);
		return dto;
	}
	
	public JSONObject toJson(){
		JSONObject json = new JSONObject();
		json.put("text", text);
		json.put("storageId", storageId);
		json.put("url", url);
		json.put("width", width);
		json.put("height", height);
		json.put("length", length );
		return json;
	}
	
	
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
	
    public static void main(String args[]){
    	JSONObject json = new JSONObject();
    	json.put("a", "null8");
    	System.out.println(json);
    }
}

