/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import java.util.List;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.sal.wechat.dto.autoreply.KeywordReplyDto;
import com.baijia.tianxiao.sal.wechat.dto.autoreply.SubscribeReplyDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**   
 * @title       : AutoReplyService 
 * @description : 自动回复
 * @author      : zhenyujian
 * @date        : 2016年1月3日 下午4:41:54 
 */
public interface AutoReplyService {

	/**
	 * @Description  : 保存 关键词自动回复
	 * @Author       : zhenyujian
	 */
	public OrgWechatReplyForKeyword saveOrUpdateKeywordReply(Integer orgId, Integer id, String keywords, int mediaType, String mediaId, String url, String content, String note);
	
	
	/**
	 * @Description  : 删除 关键词自动回复
	 * @Author       : zhenyujian
	 */
	public void delKeywordReply(Integer orgId, Integer id);
	
	
	/**
	 * @Description  : 分页查询 关键词自动回复
	 * @Author       : zhenyujian
	 */
	public List<KeywordReplyDto> listKeywordReply(Integer orgId, PageDto pageDto);
	
	
	/**
	 * @Description  : 保存 关注自动回复
	 * @Author       : zhenyujian
	 */
	public void saveOrUpdateSubscribeReply(Integer orgId, int mediaType, String mediaId, String url, String content, String note);
	
	
	/**
	 * @Description  : 查询 关键词自动回复
	 * @Author       : zhenyujian
	 */
	public SubscribeReplyDto getSubscribeReply(Integer orgId);
	
}

