/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.exception.BussinessException;


/**   
 * @title       : AuthorizationInfoService 
 * @description : 公众号授权 - 授权信息
 * @author      : zhenyujian
 * @date        : 2015年12月12日 下午8:40:45 
 */
public interface AuthorizationInfoService {

	/**
     * @Description  : 查询 AuthorizationInfo (授权信息)
     * @Author       : zhenyujian
     */
    AuthorizationInfo getByOrgId(Integer orgId);

    
    /**
     * @Description  : 查询 AuthorizationInfo (授权信息)
     * @Author       : zhenyujian
     */
    AuthorizationInfo getByAuthorizerAppId(String appId);
    
    
    /**
     * @Description  : 添加 AuthorizationInfo (授权信息)
     * @Author       : zhenyujian
     */
    AuthorizationInfo addAuthorizationInfo(Integer orgId, String authCode);

    
    /**
     * @Description  : 获取公众号的accessToken 方法内部判断accessToken是否失效 若失效则刷新token
     * @Author       : zhenyujian
     */
    AuthorizationInfo refreshAccessToken(Integer orgId) throws BussinessException;
    
    
    /**
     * @Description  : 获取公众号的accessToken 强制刷新accessToken
     * @Author       : zhenyujian
     * @Date         : 2016年1月20日 下午3:44:08 
     *
     * @Return       : AuthorizationInfo
     */
    AuthorizationInfo forceRefreshAccessToken(Integer orgId) throws BussinessException;
    
    
    AuthorizationInfo refreshAccessToken(String appId) throws BussinessException;
}
