/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuBtnType;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuBtnBuilder;
import com.baijia.tianxiao.sal.wechat.util.RandomUtil;
import com.baijia.tianxiao.sal.wechat.validator.CustomMenuValidator;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class WechatMenuJsonConverter {
    public static MenuConvertResult customJsonToWechatMenuJson(OrgWechatDto orgWechatDto, String menuJsonStr) {
        if (StringUtils.isBlank((CharSequence)menuJsonStr) || menuJsonStr.equals("{}")) {
            return new MenuConvertResult(menuJsonStr, null);
        }
        JSONObject wechatMenuJson = new JSONObject();
        JSONArray wechatBtnArray = new JSONArray();
        JSONObject menuJson = JSONObject.fromObject((Object)menuJsonStr);
        JSONArray btnArray = menuJson.optJSONArray("list");
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(menuJsonStr, null);
        }
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject wechatBtn = null;
                JSONObject btn = btnArray.getJSONObject(i);
                if (btn.get("subButton") == null || btn.get("subButton").equals("null") || btn.getJSONArray("subButton").size() == 0) {
                    CustomMenuValidator._4ButtonName(btn.getString("name"));
                    wechatBtn = WechatMenuJsonConverter.btnToWechatBtn(orgWechatDto, btn);
                } else {
                    wechatBtn = new JSONObject();
                    wechatBtn.put((Object)"name", (Object)btn.getString("name"));
                    wechatBtn.put((Object)"sub_button", (Object)WechatMenuJsonConverter.subBtnToWechatSubBtn(orgWechatDto, btn.getJSONArray("subButton")));
                    btn.remove("mediaType");
                    btn.remove("mediaId");
                    btn.remove("content");
                    btn.remove("url");
                }
                wechatBtnArray.add((Object)wechatBtn);
            }
        }
        wechatMenuJson.put((Object)"button", (Object)wechatBtnArray);
        return new MenuConvertResult(menuJson.toString(), wechatMenuJson.toString());
    }

    private static JSONArray subBtnToWechatSubBtn(OrgWechatDto orgWechatDto, JSONArray subBtnArray) {
        JSONArray wechatSubBtnArray = new JSONArray();
        if (subBtnArray != null && !subBtnArray.isEmpty()) {
            for (int i = 0; i < subBtnArray.size(); ++i) {
                CustomMenuValidator._4SubButtonName(subBtnArray.getJSONObject(i).getString("name"));
                JSONObject wechatSubBtn = WechatMenuJsonConverter.btnToWechatBtn(orgWechatDto, subBtnArray.getJSONObject(i));
                if (wechatSubBtn == null) continue;
                wechatSubBtnArray.add((Object)wechatSubBtn);
            }
        }
        return wechatSubBtnArray;
    }

    private static JSONObject btnToWechatBtn(OrgWechatDto orgWechatDto, JSONObject btn) {
        JSONObject wechatBtn = null;
        MediaType type = MediaType.getByVaule(btn.getInt("mediaType"));
        if (MediaType.UNKNOWN == type) {
            return null;
        }
        String name = btn.optString("name", "");
        String mediaId = btn.optString("mediaId", "");
        String url = btn.optString("url", "");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = type.getLabel();
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = type.getUrl(orgWechatDto);
        }
        if (MediaType.IMAGE == type) {
            wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
        } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type) {
            if (MediaType.NEWS == type) {
                wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
            } else if (WechatMenuJsonConverter.isContent(type.getValue())) {
                String key = RandomUtil.str(10);
                wechatBtn = WechatMenuBtnBuilder.clickBtn(name, key);
                btn.put((Object)"clickKey", (Object)key);
            } else {
                if (!url.startsWith("http") && !url.startsWith("https")) {
                    url = "http://" + url;
                }
                wechatBtn = WechatMenuBtnBuilder.viewBtn(name, url);
                btn.put((Object)"url", (Object)wechatBtn.getString("url"));
            }
        }
        return wechatBtn;
    }

    public static Map<String, String> mapClickKeyVsContent(String menuJsonStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        JSONObject menuJson = JSONObject.fromObject((Object)menuJsonStr);
        JSONArray btnArray = menuJson.optJSONArray("list");
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject btn = btnArray.getJSONObject(i);
                int type = btn.optInt("mediaType", -1);
                if (type == -1) {
                    JSONArray subBtnArray = btn.getJSONArray("subButton");
                    if (subBtnArray == null || subBtnArray.isEmpty()) continue;
                    for (int j = 0; j < subBtnArray.size(); ++j) {
                        btn = subBtnArray.getJSONObject(j);
                        type = btn.optInt("mediaType", -1);
                        if (!WechatMenuJsonConverter.isContent(type)) continue;
                        map.put(btn.getString("clickKey"), btn.optString("content"));
                    }
                    continue;
                }
                if (!WechatMenuJsonConverter.isContent(type)) continue;
                map.put(btn.getString("clickKey"), btn.optString("content"));
            }
        }
        return map;
    }

    private static boolean isContent(int mtype) {
        return mtype == MediaType.CONTENT.getValue() || mtype == MediaType.DIANHUA.getValue() || mtype == MediaType.ZAIXIANZIXUN.getValue();
    }

    public static MenuConvertResult wechatMenuJsonToCustomJson(String wechatMenuJsonStr) {
        if (StringUtils.isBlank((CharSequence)wechatMenuJsonStr) || wechatMenuJsonStr.equals("{}")) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }
        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();
        JSONObject wechatMenuJson = JSONObject.fromObject((Object)wechatMenuJsonStr);
        JSONArray btnArray = wechatMenuJson.getJSONObject("menu").optJSONArray("button");
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); ++i) {
                JSONObject customBtn = null;
                JSONObject wechatBtn = btnArray.getJSONObject(i);
                if (wechatBtn.get("sub_button") == null || wechatBtn.get("sub_button").equals("null") || wechatBtn.getJSONArray("sub_button").size() == 0) {
                    if (wechatBtn.get("type").equals(WechatMenuBtnType.VIEW.getValue())) {
                        customBtn = new JSONObject();
                        customBtn.put((Object)"name", wechatBtn.get("name"));
                        customBtn.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
                        customBtn.put((Object)"url", wechatBtn.get("url"));
                        customBtn.put((Object)"note", wechatBtn.get("url"));
                    }
                } else {
                    JSONArray cutomSubBtnArray = null;
                    JSONArray wechatSubBtnArray = wechatBtn.getJSONArray("sub_button");
                    if (wechatSubBtnArray != null && !wechatSubBtnArray.isEmpty()) {
                        for (int j = 0; j < wechatSubBtnArray.size(); ++j) {
                            wechatBtn = wechatSubBtnArray.getJSONObject(j);
                            if (!wechatBtn.get("type").equals(WechatMenuBtnType.VIEW.getValue())) continue;
                            JSONObject customSubBtn = new JSONObject();
                            customSubBtn.put((Object)"name", wechatBtn.get("name"));
                            customSubBtn.put((Object)"mediaType", (Object)MediaType.ZIDINGYILIANJIE.getValue());
                            customSubBtn.put((Object)"url", wechatBtn.get("url"));
                            customSubBtn.put((Object)"note", wechatBtn.get("url"));
                            if (customSubBtn == null) continue;
                            if (customBtn == null) {
                                customBtn = new JSONObject();
                                cutomSubBtnArray = new JSONArray();
                            }
                            cutomSubBtnArray.add((Object)customSubBtn);
                        }
                    }
                    if (customBtn != null) {
                        customBtn.put((Object)"name", (Object)wechatBtn.getString("name"));
                        customBtn.put((Object)"note", (Object)wechatBtn.getString("name"));
                        customBtn.put((Object)"subButton", cutomSubBtnArray);
                    }
                }
                if (customBtn == null) continue;
                customBtnArray.add((Object)customBtn);
            }
        }
        customMenuJson.put((Object)"list", (Object)customBtnArray);
        return new MenuConvertResult(customMenuJson.toString(), wechatMenuJson.toString());
    }

    public static void main(String[] args) {
        String a = "{\"menu\":{\"button\":[{\"type\":\"click\",\"name\":\"\u4eca\u65e5\u6b4c\u66f2\",\"key\":\"V1001_TODAY_MUSIC\"},{\"type\":\"view\",\"name\":\"\u4eca\u65e5\u94fe\u63a5\",\"url\":\"V1001_TODAY_MUSIC\"},{\"name\":\"\u83dc\u5355\",\"sub_button\":[{\"type\":\"view\",\"name\":\"\u641c\u7d22\",\"url\":\"http://www.soso.com/\"},{\"type\":\"view\",\"name\":\"\u89c6\u9891\",\"url\":\"http://v.qq.com/\"},{\"type\":\"click\",\"name\":\"\u8d5e\u4e00\u4e0b\u6211\u4eec\",\"key\":\"V1001_GOOD\"}]}]}}";
        System.out.println(WechatMenuJsonConverter.wechatMenuJsonToCustomJson(a).getCustomJson());
    }
}

