/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.JsAPISDKService;
import com.baijia.tianxiao.sal.wechat.dto.JSSDK.JsApiTicket;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.util.JSSDKUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class JsAPISDKServiceImpl
implements JsAPISDKService {
    private static final Logger log = LoggerFactory.getLogger(JsAPISDKServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsApiTicket retrievalJsApiTicket(Integer orgId) {
        RedisConnection connection;
        block15: {
            JsApiTicket jsApiTicket;
            block14: {
                JsApiTicket jsApiTicket2;
                block13: {
                    JsApiTicket jsApiTicket3;
                    block12: {
                        connection = null;
                        try {
                            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
                            if (authorizationInfo == null) {
                                log.info("current org can not retrieval the jsApiTicket cause by no bind");
                                jsApiTicket3 = null;
                                if (connection == null) return jsApiTicket3;
                                break block12;
                            }
                            if (this.redisTemplate != null) {
                                connection = this.redisTemplate.getConnectionFactory().getConnection();
                                connection.select(WechatProperties.getRedisDB().intValue());
                                String redisKey = this.generateKey(authorizationInfo);
                                byte[] bs = connection.get(redisKey.getBytes());
                                RedisSerializer redisSerializer = this.redisTemplate.getDefaultSerializer();
                                Object deserialize = redisSerializer.deserialize(bs);
                                if (deserialize != null) {
                                    jsApiTicket2 = (JsApiTicket)deserialize;
                                    if (connection == null) return jsApiTicket2;
                                    break block13;
                                }
                                log.info("can not find any jsApiTicket from redis or it is expired , will lock and refresh api_ticket");
                                jsApiTicket = this.refreshTicket(connection, authorizationInfo);
                                if (connection == null) return jsApiTicket;
                                break block14;
                            }
                            log.info("find a null instance for redisTemplate and can not retrieval the jsApiTicket");
                            if (connection == null) return null;
                            break block15;
                        }
                        catch (Exception e) {
                            log.error("can not retrieval jsapitTicket cause by : ", (Throwable)e);
                            return null;
                        }
                    }
                    RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                    return jsApiTicket3;
                }
                RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                return jsApiTicket2;
            }
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
            return jsApiTicket;
        }
        RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        return null;
        finally {
            if (connection != null) {
                RedisConnectionUtils.releaseConnection(connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsApiTicket refreshTicket(RedisConnection connection, AuthorizationInfo authorizationInfo) {
        String lockKey = this.getLockKey(authorizationInfo);
        JsApiTicket jat = null;
        if (connection.setNX(lockKey.getBytes(), "".getBytes()).booleanValue()) {
            try {
                connection.expire(lockKey.getBytes(), 20L);
                String accessToken = authorizationInfo.getAuthorizerAccessToken();
                String apiTicket = JSSDKUtils.trievalJsApiTicket(accessToken);
                jat = new JsApiTicket();
                jat.setExpiresIn(JsAPISDKService.JS_API_EXPIRED);
                jat.setJsApiTicket(apiTicket);
                jat.setOrgId(authorizationInfo.getOrgId());
                RedisSerializer redisSerializer = this.redisTemplate.getDefaultSerializer();
                connection.set(this.generateKey(authorizationInfo).getBytes(), redisSerializer.serialize((Object)jat));
            }
            catch (Exception ex) {
                try {
                    log.error("refresh ticket failure ", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    connection.del((byte[][])new byte[][]{lockKey.getBytes()});
                    throw throwable;
                }
                connection.del((byte[][])new byte[][]{lockKey.getBytes()});
            }
            connection.del((byte[][])new byte[][]{lockKey.getBytes()});
        }
        return jat;
    }

    private String getLockKey(AuthorizationInfo authorizationInfo) {
        return "lock.jsApiTicket." + authorizationInfo.getOrgId();
    }

    private String generateKey(AuthorizationInfo authorizationInfo) {
        return "key.jsApiTicket." + authorizationInfo.getOrgId();
    }
}

