/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.constant;

import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import org.apache.commons.lang3.StringUtils;

public enum MediaType {
    UNKNOWN(0, "", "\u672a\u77e5", false, false),
    IMAGE(1, "image", "\u56fe\u7247", false, false),
    VOICE(2, "voice", "\u8bed\u97f3", false, false),
    VIDEO(3, "video", "\u89c6\u9891", false, false),
    THUMB(4, "thumb", "\u7f29\u7565\u56fe", false, false),
    NEWS(5, "news", "\u56fe\u6587\u7d20\u6750", false, false),
    CONTENT(6, "", "\u6587\u672c", false, false),
    ZIDINGYILIANJIE(15, "", "\u81ea\u5b9a\u4e49\u94fe\u63a5", true, false),
    WANGXIAOZHUYE(11, "", "\u7f51\u6821\u4e3b\u9875", true, false),
    KECHENGDANYE(12, "", "\u8bfe\u7a0b\u5355\u9875", true, false),
    HUODONG(13, "", "\u6d3b\u52a8", true, false),
    KECHENGLIEBIAO(14, "", "\u8bfe\u7a0b\u5217\u8868", true, false),
    WODEKEBIAO(16, "", "\u6211\u7684\u8bfe\u8868", true, true),
    WODEQIANDAO(17, "", "\u6211\u7684\u7b7e\u5230", true, true),
    WODEPINGJIA(18, "", "\u6211\u7684\u8bc4\u4ef7", true, true),
    WEIGUANWANG(19, "", "\u5fae\u5b98\u7f51", true, false),
    XIAOQUDIZHI(20, "", "\u6821\u533a\u5730\u5740", true, false),
    DIANHUA(21, "", "400\u7535\u8bdd", false, false),
    ZAIXIANZIXUN(22, "", "\u5728\u7ebf\u54a8\u8be2", false, false),
    YUYUESHITING(23, "", "\u9884\u7ea6\u8bd5\u542c", true, false),
    GERENZHONGXIN(24, "", "\u4e2a\u4eba\u4e2d\u5fc3", true, true),
    XUESHENGZHONGXIN(25, "", "\u5b66\u751f\u4e2d\u5fc3", true, true),
    LAOSHIZHONGXIN(26, "", "\u8001\u5e08\u4e2d\u5fc3", true, true);

    private int value;
    private String str;
    private String label;
    private boolean needUrl;
    private boolean webauth;

    public static MediaType getByVaule(int value) {
        for (MediaType type : MediaType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        return null;
    }

    private MediaType(int value, String str, String label, boolean needUrl, boolean webauth) {
        this.value = value;
        this.str = str;
        this.label = label;
        this.webauth = webauth;
    }

    public int getValue() {
        return this.value;
    }

    public String getStr() {
        return this.str;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isNeedUrl() {
        return this.needUrl;
    }

    public void setNeedUrl(boolean needUrl) {
        this.needUrl = needUrl;
    }

    public boolean isWebauth() {
        return this.webauth;
    }

    public void setWebauth(boolean webauth) {
        this.webauth = webauth;
    }

    public String getNote() {
        String fmt = "[%s]";
        return String.format(fmt, this.label);
    }

    public String getUrl(OrgWechatDto orgWechatDto) {
        switch (this) {
            case WANGXIAOZHUYE: {
                String fmt1 = "%s%s%s";
                return String.format(fmt1, WechatProperties.getWebMTianXiaoUrlPrefix(), "i/", orgWechatDto.getOrgNumber());
            }
            case KECHENGLIEBIAO: {
                String fmt2 = "%s%s%s";
                return String.format(fmt2, WechatProperties.getWebMTianXiaoUrlPrefix(), "course/", orgWechatDto.getOrgNumber());
            }
            case WODEKEBIAO: {
                return WechatWebAuthLinkBuilder.schedule(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case WODEQIANDAO: {
                return WechatWebAuthLinkBuilder.mySigninRecord(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case WODEPINGJIA: {
                return WechatWebAuthLinkBuilder.rating(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case XUESHENGZHONGXIN: {
                return WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case LAOSHIZHONGXIN: {
                return WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, orgWechatDto.getAppId());
            }
            case XIAOQUDIZHI: {
                String fmt3 = "%s%s%s";
                return String.format(fmt3, WechatProperties.getWebMTianXiaoUrlPrefix(), "branch/", orgWechatDto.getOrgNumber());
            }
            case YUYUESHITING: {
                String fmt4 = "%s%s?orgNumber=%s";
                return String.format(fmt4, WechatProperties.getWebCRMUrlPrefix(), "consult/view.do", orgWechatDto.getOrgNumber());
            }
        }
        return null;
    }

    public static String fillUrlWithHttp(String url) {
        if (StringUtils.isNotBlank((CharSequence)url) && !url.startsWith("http://")) {
            url = "http://" + url;
        }
        return url;
    }
}

