/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtils.class);

    public static UploadResult uploadToRemote(Long uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();
        HashMap files = Maps.newHashMap();
        HashMap params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", WechatProperties.getUploadUidPrefix() + uid);
        String url = WechatProperties.getUploadServer();
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles((String)url, (Map)params, (Map)files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", new Object[]{uid, file, response});
        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", (Object)uid, (Object)(end - start));
        return FileUploadUtils.parseResponse(response);
    }

    private static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank((CharSequence)response)) {
            return null;
        }
        UploadResult uploadResult = null;
        try {
            JSONObject rootNode = JSONObject.fromObject((Object)response);
            uploadResult = new UploadResult();
            uploadResult.setFail(rootNode.getInt("fail"));
            uploadResult.setOk(rootNode.getInt("ok"));
            uploadResult.setTotal(rootNode.getInt("total"));
            JSONArray filesArray = rootNode.getJSONArray("files");
            if (filesArray != null && filesArray.size() > 0) {
                ArrayList<UploadResult.UploadFile> list = new ArrayList<UploadResult.UploadFile>();
                UploadResult.UploadFile uFile = null;
                JSONObject fileNode = null;
                for (int i = 0; i < filesArray.size(); ++i) {
                    uFile = new UploadResult.UploadFile(uploadResult);
                    fileNode = filesArray.getJSONObject(i);
                    uFile.setFid(fileNode.getString("fid"));
                    uFile.setKey(fileNode.getString("key"));
                    uFile.setSize(fileNode.getInt("size"));
                    uFile.setSn(fileNode.getString("sn"));
                    list.add(uFile);
                }
                uploadResult.setFiles(list);
            }
        }
        catch (Exception e) {
            log.error("parse response :{} catch error:{}", (Object)response, (Object)e);
        }
        log.info("parseResponse - response:{}, uploadResult:{}", (Object)response, (Object)uploadResult);
        return uploadResult;
    }
}

