/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.constant.WechatFansSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoCallbackHandler;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationInfoCallbackRequest;
import com.baijia.tianxiao.sal.wechat.task.FansSyncJob;
import com.baijia.tianxiao.sal.wechat.task.TaskHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationInfoCallbackHandlerImpl
implements AuthorizationInfoCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationInfoCallbackHandlerImpl.class);
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private FansService fansService;

    @Override
    public void handle(AuthorizationInfoCallbackRequest request) {
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.addAuthorizationInfo(request.getOrgId(), request.getAuthCode());
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.syncAuthorizerInfo(request.getOrgId(), authorizationInfo.getAuthorizerAppId());
        if (authorizationInfo == null || authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        if (authorizerInfo.isPassedVerify() && authorizationInfo.hasFunc(Integer.valueOf(WechatPermission.USER_MANAGE.getValue())) && authorizerInfo.getFansSyncStatus().intValue() != WechatFansSyncStatus.ONGOING.getValue()) {
            try {
                log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - add fansSync task - appId:{}", (Object)authorizerInfo.getAuthorizerAppId());
                TaskHelper.getInstance().addTask(new FansSyncJob(this.fansService, authorizerInfo.getAuthorizerAppId(), this.authorizerInfoService));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.info("wechat - AuthorizationInfoCallbackHandlerImpl - handle - request:{}", (Object)request);
    }
}

