/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.statistics;

import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSymmaryDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiCaller;
import com.baijia.tianxiao.util.date.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class DataStatisticsApiHelper {
    public static FansSCDto getFansSCDto(String accessToken, Date beginDate, Date endDate) throws ParseException {
        FansSCDto dto = new FansSCDto();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date yesterDay = DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)-1);
        WechatApiResponse ytCumulateResp = DataStatisticsApiCaller.getFansCumulate(accessToken, yesterDay, yesterDay);
        WechatApiResponse ytSummaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, yesterDay, yesterDay);
        int ytCancelFans = 0;
        int ytNewFans = 0;
        int ytCumulateFans = 0;
        JSONObject ytCumulateRootNode = ytCumulateResp.getRootJSONObj();
        JSONArray ytCumulateArray = ytCumulateRootNode.getJSONArray("list");
        if (ytCumulateArray != null && ytCumulateArray.size() > 0) {
            for (int i = 0; i < ytCumulateArray.size(); ++i) {
                JSONObject obj = ytCumulateArray.getJSONObject(i);
                ytCancelFans += obj.getInt("cancel_user");
                ytNewFans += obj.getInt("new_user");
            }
        }
        JSONObject ytSummaryRootNode = ytSummaryResp.getRootJSONObj();
        JSONArray ytSummaryArray = ytSummaryRootNode.getJSONArray("list");
        ytCumulateFans = ytSummaryArray.getJSONObject(0).getInt("cumulate_user");
        dto.setYtDate(sdf.format(yesterDay));
        dto.setYtCancelFans(ytCancelFans);
        dto.setYtNewFans(ytNewFans - ytCancelFans);
        dto.setYtCumulateFans(ytCumulateFans);
        ArrayList<FansSymmaryDto> fansSymmaryDtoList = new ArrayList<FansSymmaryDto>();
        List dateList = DateUtil.getDateBetween((Date)beginDate, (Date)endDate);
        if (dateList != null && !dateList.isEmpty()) {
            LinkedHashMap<String, FansSymmaryDto> symmaryMap = new LinkedHashMap<String, FansSymmaryDto>();
            for (Date date : dateList) {
                FansSymmaryDto fansSymmaryDto = new FansSymmaryDto(sdf.format(date));
                symmaryMap.put(sdf.format(date), fansSymmaryDto);
            }
            WechatApiResponse summaryResp = DataStatisticsApiCaller.getFansSummary(accessToken, beginDate, endDate);
            JSONObject summaryRootNode = summaryResp.getRootJSONObj();
            JSONArray summaryArray = summaryRootNode.getJSONArray("list");
            if (summaryArray != null & !summaryArray.isEmpty()) {
                for (int i = 0; i < summaryArray.size(); ++i) {
                    JSONObject obj = summaryArray.getJSONObject(i);
                    FansSymmaryDto fsdto = (FansSymmaryDto)symmaryMap.get(sdf.parse(obj.getString("ref_date")));
                    fsdto.setCancelFans(fsdto.getCancelFans() + obj.getInt("cancel_user"));
                    fsdto.setNewFans(fsdto.getNewFans() + obj.getInt("new_user"));
                    fsdto.setFansDiff(fsdto.getNewFans() - fsdto.getCancelFans());
                }
            }
            for (FansSymmaryDto fsdto : symmaryMap.values()) {
                fansSymmaryDtoList.add(fsdto);
            }
        }
        dto.setSymmary(fansSymmaryDtoList);
        return dto;
    }
}

