/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatRemoteCallHelper {
    private static final Logger log = LoggerFactory.getLogger(WechatRemoteCallHelper.class);

    public static WechatApiResponse get(String url) throws WechatException, WebServiceException {
        try {
            String response = HttpClientUtils.doGet((String)url, null);
            log.info("WechatRemoteCallHelper - url:{}, response:{}", (Object)url, (Object)response);
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("WechatRemoteCallHelper - get - url:{}", (Object)url);
            log.error("WechatRemoteCallHelper - get - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse get(String url, Map<String, Object> params) throws WechatException, WebServiceException {
        try {
            if (params != null && !params.isEmpty()) {
                StringBuilder builder = new StringBuilder(url);
                if (!url.contains("?")) {
                    builder.append("?");
                }
                for (String key : params.keySet()) {
                    builder.append("&").append(key).append("=").append(params.get(key));
                }
                url = builder.toString();
            }
            String response = HttpClientUtils.doGet((String)url, null);
            log.info("request - url:{}, response:{}", (Object)url, (Object)response);
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("WechatRemoteCallHelper - get - url:{}", (Object)url);
            log.error("WechatRemoteCallHelper - get - exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse postJson(String url, Map<String, Object> params) throws WechatException, WebServiceException {
        try {
            String response = HttpClientUtils.doJsonPost((String)url, params, (String)"UTF-8");
            log.info("request - url:{}, params:{}, response:{}", new Object[]{url, params, response});
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("WechatRemoteCallHelper - postJson - url:{}, params", (Object)url, params);
            log.error("WechatRemoteCallHelper - postJson - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse postJsonA(String url, Map<String, Object> params) throws WechatException, WebServiceException {
        try {
            System.out.println("111");
            String response = WechatRemoteCallHelper.doPostJSON(url, JSONObject.fromObject(params).toString());
            System.out.println(response);
            log.info("request - url:{}, params:{}, response:{}", new Object[]{url, params, response});
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("WechatRemoteCallHelper - postJson - url:{}, params", (Object)url, params);
            log.error("WechatRemoteCallHelper - postJson - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse postFile(String url, Map<String, String> params, File file) throws WechatException, WebServiceException {
        try {
            if (file == null) {
                throw new RuntimeException("postFile - file is null");
            }
            if (params == null) {
                params = new HashMap<String, String>();
            }
            HashMap<String, File> files = new HashMap<String, File>();
            files.put(file.getName(), file);
            String response = com.baijia.tianxiao.util.httpclient.HttpClientUtils.doPostFiles((String)url, params, files);
            log.info("request - url:{}, params:{}, fileName:{}, response:{}", new Object[]{url, params, file.getName(), response});
            return WechatRemoteCallHelper.convertJson(response);
        }
        catch (WechatException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("WechatRemoteCallHelper - postFile - url:{}, fileName:{}", (Object)url, (Object)file.getName());
            log.error("WechatRemoteCallHelper - postFile - Exception - ", (Throwable)e);
            throw new WebServiceException((Throwable)e);
        }
    }

    public static WechatApiResponse convertJson(String jsonData) throws WechatException {
        int errorCode = 0;
        String errorMsg = "";
        if (StringUtils.isNotBlank((String)jsonData)) {
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonData);
            errorCode = jsonObj.optInt("errcode", 0);
            errorMsg = jsonObj.optString("errmsg", "");
            if (errorCode != 0) {
                log.error("ERROR - WechatJsonConverter convertJson json:{}", (Object)jsonData);
                if (errorCode == -1) {
                    throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SYSTEM_ERROR);
                }
                if (errorCode == 40001 || errorCode == 40014 || errorCode == 42001) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID);
                }
                if (errorCode == 48001) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_PERMISSION_DENIED);
                }
                if (errorCode == 61007) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_AUTHORIZATION_DENIED);
                }
                if (errorCode == 45015) {
                    throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_CANNOT_SENDMSG_TO_FANS);
                }
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.WECHAT_API_RETURN_ERROR, errorMsg);
            }
        } else {
            log.error("ERROR - WechatJsonConverter convertJson json:{}", (Object)jsonData);
            throw new WebServiceException("\u5fae\u4fe1\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u7a7a\u503c");
        }
        return new WechatApiResponse(errorCode, errorMsg, jsonData);
    }

    public static String doPostJSON(String url, String jsonStr) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            StringEntity postEntity = new StringEntity(jsonStr, "utf-8");
            postEntity.setContentEncoding("utf-8");
            postEntity.setContentType("application/json");
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)postEntity);
            CloseableHttpClient httpClient = WechatRemoteCallHelper.getHttpClient();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }
}

