package com.baijia.tianxiao.sal.vzhibo.vo;

import com.baijia.tianxiao.dal.wechat.po.QRCodeScene;

import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

import lombok.Data;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 07/06/2017 9:48 PM
 */
@Data
public class TxVZhiBoInviteCardVO {
    private String inviterName;
    private String inviterAvatar;
    private String cardTitle;
    private Date date;
    private String location;
    private String base64Img;
    private QRCodeScene qrCodeScene;
    private Date picCreateTime = new Date();

    public void setCardTitle(String cardTitle) {
        int i = 0;
        if (StringUtils.isNotEmpty(cardTitle)) {
            int showLength = 0;
            for (; i < cardTitle.length() && showLength < 37 && i < 37; i++) {
                if (CharUtils.isAscii(cardTitle.charAt(i))) {
                    showLength++;
                } else {
                    showLength += 2;
                }
            }
        }
        this.cardTitle = cardTitle.length() > i ? cardTitle.substring(0, i) + "..." : cardTitle;
    }

    private static final String PLH_SB_SUFFIX = "的直播间";
    public void setLocation(String location) {
        int i = 0;
        if (StringUtils.isNotEmpty(location)) {
            // FIXME 傻逼逻辑
            if (location.endsWith(PLH_SB_SUFFIX) && location.length() - PLH_SB_SUFFIX.length() > 0) {
                location = location.substring(0, location.length() - PLH_SB_SUFFIX.length());
            }

            int showLength = 0;
            for (; i < location.length() && showLength < 20 && i < 20; i++) {
                if (CharUtils.isAscii(location.charAt(i))) {
                    showLength++;
                } else {
                    showLength += 2;
                }
            }
        }
        this.location = location.length() > i ? location.substring(0, i) + "..." : location;
    }
}
