/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.vo;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoLessonFieldEnums;

import org.apache.commons.lang.math.NumberUtils;

import lombok.Data;

/**
 * @title FieldUpdateVO
 * @desc TODO
 * @author fubaokui
 * @date 2016年12月7日
 * @version 1.0
 */
@Data
public class FieldUpdateVO {

    private int id;

    private int field;

    private String value;

    private String ext;

    @Override
    public String toString() {
        return "FieldUpdateVO [id=" + id + ", field=" + field + ", value=" + value + ", ext=" + ext + "]";
    }

    public boolean isValidate() {
        String textMaxLengthConfig = PropertiesReader.getValue("config-common", "text_max_length");
        int textMaxLength = 1000;
        if (NumberUtils.isNumber(textMaxLengthConfig)) {
            textMaxLength = Integer.parseInt(textMaxLengthConfig);
        }
        if (TxVZhiBoLessonFieldEnums.isTextType(this.field)
            && (value == null || value.toString().length() > textMaxLength)) {
            return false;
        }
        return true;
    }

}
