package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoEventLogDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoEventLog;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.Constant;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class TxVZhiBoEventLogServiceImpl implements TxVZhiBoEventLogService {

    @Autowired
    private TxVZhiBoEventLogDao txVZhiBoEventLogDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    /**
     * 主帐号,子帐号, 进入,退出直播间事件log. 进入时, 退出时, getccurl时, 关闭时.
     * 
     * @param lessonId
     * @param uId
     * @param userType
     * @param eventType
     */
    @Override
    public void saveEvent(int lessonId, int uId, TxVZhiBoUserType userType, TxVZhiBoEventType eventType) {
        TxVZhiBoEventLog eventLog = new TxVZhiBoEventLog();
        eventLog.setCreateTime(new Date());
        eventLog.setEvent(eventType.getCode());
        eventLog.setLessonId(lessonId);
        eventLog.setUId(uId);
        eventLog.setUType(userType.getCode());
        txVZhiBoEventLogDao.save(eventLog);
    }

    @Override
    public void saveEvents(List<TxVZhiBoEventLog> eventLogs) {
        if (CollectionUtils.isEmpty(eventLogs)) {
            return;
        } else {
            this.txVZhiBoEventLogDao.saveAll(eventLogs, false);
        }
    }

    // /**
    // * 学生进入,ping log, 放缓存里
    // *
    // * @param uId
    // * @param uType
    // * @param lessonId
    // * @param openId
    // */
    // @Override
    // public void markEvent(final Integer uId, final Integer uType, final Integer lessonId, final String openId) {
    // StringBuilder sb = new StringBuilder();
    // sb.append(RedisKeyEnums.VZB.EVENT_KEY_PREFIX.getRedisKey()).append(lessonId).append(Constant.EVENT_KEY_SEP)
    // .append(uId).append(Constant.EVENT_KEY_SEP).append(uType).append(Constant.EVENT_KEY_SEP).append(openId);
    // final String key = sb.toString();
    // // 放入event队列
    // redisTemplate.opsForList().leftPush(RedisKeyEnums.VZB.EVENT_KEY.getRedisKey(), key);
    // // 给key一个存活时间 时间戳
    // redisTemplate.execute((RedisCallback<Boolean>) connection -> {
    // connection.setEx(key.getBytes(), Constant.TIME_OUT, String.valueOf(System.currentTimeMillis()).getBytes());
    // return true;
    // });
    // }
    /**
     * 学生进入,ping log, 放缓存里
     * 
     * @param uid
     * @param uType
     * @param lessonId
     * @param openId
     */
    @Override
    public void markEvent(final Integer uid, final Integer uType, final Integer lessonId, final String openId) {
        StringBuilder sb = new StringBuilder();
        sb.append(RedisKeyEnums.VZB.EVENT_KEY.getRedisKey()).append(lessonId).append(Constant.EVENT_KEY_SEP).append(uid)
            .append(Constant.EVENT_KEY_SEP).append(uType).append(Constant.EVENT_KEY_SEP).append(openId);
        final String key = sb.toString();
        // 放入event zset 分值为时间戳
        redisTemplate.opsForZSet().add(RedisKeyEnums.VZB.EVENT_KEY.getRedisKey(), key,
            new Double(System.currentTimeMillis()));
    }

}
