/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.vzhibo.constant;

/**
 * 
 * @title OrderTypeEnums
 * @desc 消息获取次序 
 * @author fubaokui
 * @date 2016年11月28日
 * @version 1.0
 */
public enum OrderTypeEnums {
    POSITIVE(0),    //正序 ，[index,index+count]
    REVERSE(1);     //逆序 , [index-count,index]

    private int code;

    OrderTypeEnums(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static final OrderTypeEnums parse(Integer code) {
        if (null == code) {
            return null;
        }
        for (OrderTypeEnums enums : OrderTypeEnums.values()) {
            if (enums.getCode() == code) {
                return enums;
            }
        }
        return null;
    }

}
