/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.util;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DateUtils {
    private static Date date;
    private static Calendar CALENDAR;
    private static SimpleDateFormat simpleDateFormat;
    private static SimpleDateFormat weekFormate;
    public static final String DATE_PATTERN_1 = "yyyyMMdd";
    public static final String DATETIME_PATTERN_1 = "yyyyMMddHHmmss";
    public static final String DATETIME_PATTERN_2 = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DDHHMM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Date getYesterdayDate() {
        return new Date(DateUtils.getCurTimeMillis() - 86400000L);
    }

    public static Date getPastdayDate(int i) {
        return new Date(DateUtils.getCurTimeMillis() - 86400000L * (long)i);
    }

    public static Date getPastdayDate(Date date, int i) {
        return new Date(date.getTime() - 86400000L * (long)i);
    }

    public static long getCurTimeMillis() {
        return System.currentTimeMillis();
    }

    public static Timestamp getCurTimestamp() {
        return new Timestamp(DateUtils.getCurTimeMillis());
    }

    public static String getCurrentDateStr() {
        return DateUtils.getCurFormatDate(DATETIME_PATTERN_2);
    }

    public static synchronized String getCurFormatDate(String formatDate) {
        date = DateUtils.getCurrentDate();
        simpleDateFormat.applyPattern(formatDate);
        return simpleDateFormat.format(date);
    }

    public static synchronized String getDate2Str(String format, Date date) {
        simpleDateFormat.applyPattern(format);
        return simpleDateFormat.format(date);
    }

    public static String getDate2LStr(Date date) {
        return DateUtils.getDate2Str(DATETIME_PATTERN_2, date);
    }

    public static String getDate2LStr2(Date date) {
        return DateUtils.getDate2Str("yyyy/MM/dd HH:mm:ss", date);
    }

    public static String getDate2MStr(Date date) {
        return DateUtils.getDate2Str("yyyy-MM-dd HH:mm", date);
    }

    public static String getDate2MDStr(Date date) {
        return DateUtils.getDate2Str("MM-dd", date);
    }

    public static String getDate2LMDStr(Date date) {
        return DateUtils.getDate2Str("MM-dd HH:mm", date);
    }

    public static String getDate2MStr2(Date date) {
        return DateUtils.getDate2Str("yyyy/MM/dd HH:mm", date);
    }

    public static String getDate2SStr(Date date) {
        return DateUtils.getDate2Str("yyyy-MM-dd", date);
    }

    public static String getDate2SStr2(Date date) {
        return DateUtils.getDate2Str("yyyy/MM/dd", date);
    }

    public static String getDate2All(Date date) {
        return DateUtils.getDate2Str(DATETIME_PATTERN_1, date);
    }

    public static String getDate2YMDStr(Date date) {
        return DateUtils.getDate2Str(DATE_PATTERN_1, date);
    }

    public static String getDate2Message(Date date) {
        return DateUtils.getDate2Str("MM\u6708dd\u65e5HH:mm", date);
    }

    public static String getLong2LStr(long l) {
        date = DateUtils.getLongToDate(l);
        return DateUtils.getDate2LStr(date);
    }

    public static String getLong2SStr(long l) {
        date = DateUtils.getLongToDate(l);
        return DateUtils.getDate2SStr(date);
    }

    public static synchronized String getLong2SStr(long l, String formatDate) {
        date = DateUtils.getLongToDate(l);
        simpleDateFormat.applyPattern(formatDate);
        return simpleDateFormat.format(date);
    }

    public static synchronized Date getStrToDate(String format, String str) {
        simpleDateFormat.applyPattern(format);
        try {
            return simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getStr2Str(String format, String str) {
        Date date = DateUtils.getStrToDate(format, str);
        return DateUtils.getDate2Str(format, date);
    }

    public static Date getStr2LDate(String str) {
        return DateUtils.getStrToDate(DATETIME_PATTERN_2, str);
    }

    public static Date getStr2LDate2(String format, String str) {
        return DateUtils.getStrToDate(format, str);
    }

    public static Date getStr2SDate(String str) {
        return DateUtils.getStrToDate("yyyy-MM-dd", str);
    }

    public static Date getLongToDate(long l) {
        return new Date(l);
    }

    public static int getOffMinutes(long l) {
        return DateUtils.getOffMinutes(l, DateUtils.getCurTimeMillis());
    }

    public static int getOffMinutes(long from, long to) {
        return (int)((to - from) / 60000L);
    }

    public static void setCalendar(long l) {
        CALENDAR.clear();
        CALENDAR.setTimeInMillis(l);
    }

    public static void setCalendar(Date date) {
        CALENDAR.clear();
        CALENDAR.setTime(date);
    }

    public static int getYear() {
        return CALENDAR.get(1);
    }

    public static int getMonth() {
        return CALENDAR.get(2) + 1;
    }

    public static int getDay() {
        return CALENDAR.get(5);
    }

    public static int getHour() {
        return CALENDAR.get(11);
    }

    public static int getMinute() {
        return CALENDAR.get(12);
    }

    public static int getSecond() {
        return CALENDAR.get(13);
    }

    public static Timestamp stringToTimestamp(String dateTime) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Timestamp ts = new Timestamp(dateFormat.parse(dateTime).getTime());
        return ts;
    }

    public static synchronized Timestamp getStr2Timestamp(String dateStr, String pattern) throws ParseException {
        simpleDateFormat.applyPattern(pattern);
        Timestamp ts = new Timestamp(simpleDateFormat.parse(dateStr).getTime());
        return ts;
    }

    public static String getMinMonthDate(String date, int offset) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(2, offset);
        calendar.set(5, calendar.getActualMinimum(5));
        return dateFormat.format(calendar.getTime());
    }

    public static String getMaxMonthDate(String date, int offset) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(2, offset);
        calendar.set(5, calendar.getActualMaximum(5));
        return dateFormat.format(calendar.getTime());
    }

    public static Timestamp getNextHourByDay(String date, int nextHour) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(11, nextHour);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static String getNextHourStartTimeByDay(String date, int nextHour) throws ParseException {
        date = date.substring(0, 14) + "00:00";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(11, nextHour);
        return dateFormat.format(calendar.getTime());
    }

    public static String getNextHourEndTimeByDay(String date, int nextHour) throws ParseException {
        date = date.substring(0, 14) + "59:59";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(11, nextHour);
        return dateFormat.format(calendar.getTime());
    }

    public static String getNextDayStartTime(String date, int nextDay) throws ParseException {
        date = date.substring(0, 10) + " 00:00:00";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(5, nextDay);
        return dateFormat.format(calendar.getTime());
    }

    public static String getNextDayEndTime(String date, int nextDay) throws ParseException {
        date = date.substring(0, 10) + " 23:59:59";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(5, nextDay);
        return dateFormat.format(calendar.getTime());
    }

    public static String getNextMinTime(String date, int nextMin) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN_2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateFormat.parse(date));
        calendar.add(12, nextMin);
        return dateFormat.format(calendar.getTime());
    }

    public static int compareByDay(Date fDate, Date oDate) {
        if (null == fDate || null == oDate) {
            return -1;
        }
        long intervalMilli = oDate.getTime() - fDate.getTime();
        return (int)(intervalMilli / 86400000L);
    }

    public static String getDateStart(String dateStr, String pattern) {
        Date date = DateUtils.getStrToDate(pattern, dateStr);
        return DateUtils.getDate2Str(DATETIME_PATTERN_2, date);
    }

    public static String getDateEnd(String dateStr, String pattern) {
        Date date = DateUtils.getStrToDate(pattern, dateStr);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        c.add(13, -1);
        return DateUtils.getDate2Str(DATETIME_PATTERN_2, c.getTime());
    }

    public static String getDateStart(long dateL) {
        Date date = DateUtils.getLongToDate(dateL);
        return DateUtils.getDate2Str(DATETIME_PATTERN_2, date);
    }

    public static String getDateEnd(long dateL) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(dateL);
        c.add(5, 1);
        c.add(13, -1);
        return DateUtils.getDate2Str(DATETIME_PATTERN_2, c.getTime());
    }

    public static long getDateEndLong(long dateL) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(dateL);
        c.add(5, 1);
        c.add(13, -1);
        return c.getTimeInMillis();
    }

    public static String getStr2Str(String dateStr, String srcPattern, String tarPattern) {
        Date date = DateUtils.getStrToDate(srcPattern, dateStr);
        return DateUtils.getDate2Str(tarPattern, date);
    }

    public static long getDateLong2Long(Long dateLong) {
        String dateStr = String.valueOf(dateLong);
        Date date = DateUtils.getStrToDate(DATE_PATTERN_1, dateStr);
        return date.getTime();
    }

    public static long getDatetimeLong2Long(Long dateLong) {
        String dateStr = String.valueOf(dateLong);
        Date date = DateUtils.getStrToDate(DATETIME_PATTERN_1, dateStr);
        return date.getTime();
    }

    public static int getDaysBetween(Timestamp before, Timestamp after) {
        long beforeLong = before.getTime();
        long afterLong = after.getTime();
        return Integer.parseInt(String.valueOf((afterLong - beforeLong) / 86400000L));
    }

    public static int getHoursBetween(Timestamp before, Timestamp after) {
        long beforeLong = before.getTime();
        long afterLong = after.getTime();
        return Integer.parseInt(String.valueOf((afterLong - beforeLong) / 3600000L));
    }

    public static int getMinsBetween(Timestamp before, Timestamp after) {
        long beforeLong = before.getTime();
        long afterLong = after.getTime();
        return Integer.parseInt(String.valueOf((afterLong - beforeLong) / 60000L));
    }

    public static int getWeekByCurrentTime() {
        return DateUtils.getWeekByTime(System.currentTimeMillis());
    }

    public static int getWeekByTime(long time) {
        int[] days = new int[]{7, 1, 2, 3, 4, 5, 6};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(time));
        int i = calendar.get(7);
        return days[i - 1];
    }

    public static String formatYYYY_MM_DD_HH_MM(Date time) {
        Preconditions.checkNotNull((Object)time);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return dateFormat.format(time);
    }

    public static Date addDays(Date date, int amount) {
        Preconditions.checkNotNull((Object)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, amount);
        return cal.getTime();
    }

    public static final Date truncate(Date creatTime, int field) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)creatTime, (int)field);
    }

    public static String toGMTString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.UK);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtils.toGMTString(new Date()));
        System.out.println(DateUtils.getDate4Wechat(new Date()));
    }

    public static String getWeek(Date date) {
        return weekFormate.format(date);
    }

    public static String getDate4Wechat(Date date) {
        String dateReturen = DateUtils.getDate2Str("y/M/d {}h:m:s", date);
        Calendar calendar = Calendar.getInstance();
        int amPm = calendar.get(9);
        dateReturen = amPm == 0 ? dateReturen.replace("{}", "\u4e0a\u5348") : dateReturen.replace("{}", "\u4e0b\u5348");
        return dateReturen;
    }

    static {
        CALENDAR = Calendar.getInstance();
        simpleDateFormat = new SimpleDateFormat();
        weekFormate = new SimpleDateFormat("EEEE", Locale.CHINA);
    }
}

