/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.dal.vzhibo.constant.TxVZhiBoLessonStudentStatus;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.baijia.tianxiao.sal.vzhibo.util.WebSocketUtil;
import com.baijia.tianxiao.sal.vzhibo.vo.WsBaseMessage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxVZhiBoLessonStudentServiceImpl
implements TxVZhiBoLessonStudentService {
    private static final Logger log = LoggerFactory.getLogger(TxVZhiBoLessonStudentServiceImpl.class);
    @Autowired
    TxVZhiBoLessonStudentDao txVZhiBoLessonStudentDao;
    @Autowired
    TxVZhiBoLessonService txVZhiBoLessonService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private FansDao fansDao;
    @Autowired
    RedisTemplate<String, String> redisTemplate;

    @Override
    @Transactional
    public void changeStudentNoNeedPwd(@NonNull Integer roomId, @NonNull Integer lessonId, @NonNull String openId, int noNeedPwd) {
        TxVZhiBoLessonStudent txVZhiBoLessonStudent;
        List consultUsers;
        if (roomId == null) {
            throw new NullPointerException("roomId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (openId == null) {
            throw new NullPointerException("openId");
        }
        TxVZhiBoLesson lesson = this.txVZhiBoLessonService.getById(lessonId.intValue());
        Fans fans = this.fansDao.getByOpenId(openId);
        if (fans == null) {
            try {
                TimeUnit.SECONDS.sleep(3L);
                fans = this.fansDao.getByOpenId(openId);
                if (fans == null) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u5206\u4fe1\u606f\u52a0\u8f7d\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u9875\u9762");
                }
            }
            catch (InterruptedException e) {
                log.error("wait fans data save to db error!", (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(consultUsers = this.consultUserDao.lookByWeixinOpenId(Long.valueOf(lesson.getOrgId().longValue()), openId, new String[0])))) {
            TxConsultUser consult = new TxConsultUser();
            consult.setOrgId(Long.valueOf(lesson.getOrgId().longValue()));
            consult.setWeixinOpenId(openId);
            consult.setWeixinNickName(fans.getNick());
            consult.setName(fans.getNick());
            consult.setConsultSource(Integer.valueOf(MessageSource.VZHIBO.getValue()));
            DBResultDto resultDto = this.consulterAPIService.saveOrUpdateByWechatOpenId(consult);
            consult.setId(((TxConsultUser)resultDto.getData()).getId());
        }
        if ((txVZhiBoLessonStudent = this.getByOpenId(openId, lessonId)) == null) {
            Long studentCount = this.getStudentCountbyLessonId(lessonId);
            txVZhiBoLessonStudent = new TxVZhiBoLessonStudent();
            txVZhiBoLessonStudent.setCreateTime(new Date());
            txVZhiBoLessonStudent.setLessonId(lessonId);
            txVZhiBoLessonStudent.setRoomId(roomId);
            txVZhiBoLessonStudent.setOpenId(openId);
            txVZhiBoLessonStudent.setUpdateTime(new Date());
            txVZhiBoLessonStudent.setStatus(Integer.valueOf(TxVZhiBoLessonStudentStatus.NORMAL.getCode()));
            txVZhiBoLessonStudent.setNoNeedPwd(Integer.valueOf(noNeedPwd));
            txVZhiBoLessonStudent.setInvitePicUrl("");
            txVZhiBoLessonStudent.setInvitePicReady(Integer.valueOf(Flag.FALSE.getInt()));
            this.saveStudent(txVZhiBoLessonStudent);
            InviteCardTaskDto taskDto = new InviteCardTaskDto(lessonId, openId, Boolean.valueOf(false));
            this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
            Set deviceIds = this.redisTemplate.opsForHash().keys((Object)(RedisKeyEnums.VZB.LESSON_DEVICEID_PREFIX.getRedisKey() + lessonId));
            WsBaseMessage studentCountNotice = new WsBaseMessage();
            studentCountNotice.setMsgType(MessageTypeEnums.STUDENTCOUNT.getCode());
            studentCountNotice.setStudentCount(studentCount + 1L);
            studentCountNotice.setLessonId((int)lessonId);
            if (deviceIds != null && deviceIds.size() > 0) {
                WebSocketUtil.sendBatchWsMessage(studentCountNotice, deviceIds);
            }
        } else {
            txVZhiBoLessonStudent.setNoNeedPwd(Integer.valueOf(noNeedPwd));
            this.saveStudent(txVZhiBoLessonStudent);
        }
    }

    @Override
    public Map<Integer, Integer> statStudentCountByRoomId(Integer roomId) {
        log.info("[statStudentCountByRoomId]roomId:{}", (Object)roomId);
        HashMap resutlMap = Maps.newHashMap();
        if (roomId == null) {
            return resutlMap;
        }
        List<TxVZhiBoLesson> lessons = this.txVZhiBoLessonService.getByRoomId(roomId);
        if (CollectionUtils.isEmpty(lessons)) {
            return resutlMap;
        }
        ArrayList doneLessonIds = Lists.newArrayList();
        for (TxVZhiBoLesson boLesson : lessons) {
            if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == boLesson.getStatus().intValue()) {
                long count = this.getStudentCountbyLessonId(boLesson.getId().intValue());
                resutlMap.put(boLesson.getId().intValue(), (int)count);
                continue;
            }
            doneLessonIds.add(boLesson.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)doneLessonIds)) {
            HashMap countCondition = Maps.newHashMap();
            countCondition.put("lessonId", doneLessonIds);
            Map resutlMapDone = this.txVZhiBoLessonStudentDao.groupCount((Map)countCondition, "open_id", "lesson_id", true, Integer.class);
            if (resutlMap != null && resutlMapDone.size() > 0) {
                resutlMap.putAll(resutlMapDone);
            }
        }
        return resutlMap;
    }

    @Override
    public List<TxVZhiBoLessonStudent> getAllByLessonId(Integer lessonId) {
        return this.txVZhiBoLessonStudentDao.getAllByLessonId(lessonId);
    }

    @Override
    public TxVZhiBoLessonStudent getByOpenId(String openId, Integer lessonId) {
        TxVZhiBoLessonStudent data = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
        return data;
    }

    @Override
    public void saveStudent(TxVZhiBoLessonStudent student) {
        this.txVZhiBoLessonStudentDao.saveOrUpdate((Object)student, new String[0]);
    }

    @Override
    public long getStudentCountbyLessonId(Integer lessonId) {
        if (lessonId == null) {
            return 0L;
        }
        Integer count = this.txVZhiBoLessonStudentDao.queryStudentOpenIdCountByLessonId(lessonId);
        return null == count ? 0L : (long)count.intValue();
    }

    @Override
    public long entryLesson(Integer lessonId, String openid) {
        if (lessonId == null) {
            return 0L;
        }
        TxVZhiBoLesson lesson = this.txVZhiBoLessonService.getById(lessonId.intValue());
        if (lesson == null) {
            return 0L;
        }
        return this.getStudentCountbyLessonId(lessonId);
    }

    @Override
    public List<TxVZhiBoLessonStudent> getByLessonId(Integer lessonId, Integer lastId, Integer pageSize) {
        return this.txVZhiBoLessonStudentDao.getByLessonId(lessonId, lastId, pageSize);
    }

    @Override
    public List<TxVZhiBoLessonStudent> listLatestByLessonId(Integer lessonId, Integer pageSize) {
        return this.txVZhiBoLessonStudentDao.listLatestByLessonId(lessonId, pageSize);
    }

    @Override
    public boolean canSpeakCheck(Integer lessonId, String openid) {
        TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.getByOpenId(openid, lessonId);
        return null != txVZhiBoLessonStudent && txVZhiBoLessonStudent.getStatus().intValue() != TxVZhiBoLessonStudentStatus.NO_SPEAK.getCode();
    }
}

