/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.TxVZhiBoLessonStatusEnums;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.vzhibo.constant.MessageTypeEnums;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoRoom;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.vzhibo.constant.AreaTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.InviteCardStatus;
import com.baijia.tianxiao.sal.vzhibo.constant.OwnerTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoEventType;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoLessonFieldEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoLessonListTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.constant.TxVZhiBoUserType;
import com.baijia.tianxiao.sal.vzhibo.constant.UserTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.service.AudienceService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoEventLogService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoInviteCardService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoLessonStudentService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoMessageService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoRoomService;
import com.baijia.tianxiao.sal.vzhibo.vo.AudienceDto;
import com.baijia.tianxiao.sal.vzhibo.vo.FieldUpdateVO;
import com.baijia.tianxiao.sal.vzhibo.vo.LessonDetailVO;
import com.baijia.tianxiao.sal.vzhibo.vo.ListRequestDto;
import com.baijia.tianxiao.sal.vzhibo.vo.MessageInfo;
import com.baijia.tianxiao.sal.vzhibo.vo.ShareDataVO;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoLessonListVO;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TxVZhiBoLessonServiceImpl
implements TxVZhiBoLessonService {
    private static final Logger log = LoggerFactory.getLogger(TxVZhiBoLessonServiceImpl.class);
    @Autowired
    private TxVZhiBoInviteCardService txVZhiBoInviteCardService;
    @Autowired
    private AudienceService audienceService;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    AuthorizationInfoService authorizationInfoService;
    @Autowired
    OrgAccountService orgAccountService;
    @Autowired
    TxVZhiBoLessonDao txVZhiBoLessonDao;
    @Autowired
    TxVZhiBoLessonStudentService txVZhiBoLessonStudentService;
    @Autowired
    TxVZhiBoEventLogService txVZhiBoEventLogService;
    @Autowired
    TxVZhiBoRoomService txVZhiBoRoomService;
    @Value(value="${lesson_detail_url}")
    private String LESSON_DETAIL_URL;
    @Value(value="${room_detail_url}")
    private String ROOM_DETAIL_URL;
    @Value(value="${room_expire_time}")
    private String roomExpireTime;
    @Value(value="${tianxiaojia_app_id}")
    private String tianXiaoJiaAppId;
    @Autowired
    TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    OrgInfoService orgInfoService;
    @Autowired
    TxVZhiBoMessageService txVZhiBoMessageService;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Value(value="${msg_queue_pos}")
    String MSG_QUEUE_POS;
    private static final String YET_START_SHARE_TITLE = "\u5fae\u76f4\u64ad | %s\u5c06\u4e8e%s\u5f00\u8bfe\uff0c\u522b\u5fd8\u8bb0\u4e0a\u8bfe\u54e6~";
    private static final String ONGOING_MANY_PEOPLE_SHARE_TITLE = "\u76f4\u64ad\u4e2d | %s%s\u4eba\u6b63\u5728\u542c\u8bfe\uff0c\u9a6c\u4e0a\u8fdb\u5165\u6559\u5ba4\u5427\uff01";
    private static final String ONGOING_FEW_PEOPLE_SHARE_TITLE = "\u76f4\u64ad\u4e2d | %s\u6b63\u5728\u4e0a\u8bfe\uff0c\u9a6c\u4e0a\u8fdb\u5165\u6559\u5ba4\u5427\uff01";
    private static final int MANY_FEW_THRESHOLD = 5;
    private LoadingCache<Integer, OrgInfoSimpleDto> orgInfoSimpleDtoCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(120L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, OrgInfoSimpleDto>(){

        public OrgInfoSimpleDto load(Integer orgId) throws Exception {
            Preconditions.checkNotNull((Object)orgId);
            return TxVZhiBoLessonServiceImpl.this.orgInfoService.getOrgInfo(new Long(orgId.intValue()));
        }
    });
    private LoadingCache<Integer, TxVZhiBoLesson> lessonCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Integer, TxVZhiBoLesson>(){

        public TxVZhiBoLesson load(Integer lessonId) throws Exception {
            Preconditions.checkNotNull((Object)lessonId);
            return TxVZhiBoLessonServiceImpl.this.getById(lessonId.intValue());
        }
    });

    @Override
    public boolean validateLessonPassword(Integer lessonId, String password) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        if (null == txVZhiBoLesson) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u76f4\u64ad\u8bfe\u8282\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)txVZhiBoLesson.getPassword())) {
            return true;
        }
        return StringUtils.equals((CharSequence)txVZhiBoLesson.getPassword(), (CharSequence)password);
    }

    @Override
    public String getLiveLessonUrl(Integer OrgNumber, Integer lessonId) {
        log.info("[getLiveLessonUrl]OrgNumber:{},lessonId:{}", (Object)OrgNumber, (Object)lessonId);
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(OrgNumber, new String[0]);
        if (orgAccount == null) {
            return "";
        }
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.getByOrgId(orgAccount.getId());
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(orgAccount.getId());
        String appId = "";
        if (authorizationInfo == null || StringUtils.isBlank((CharSequence)authorizationInfo.getAuthorizerAppId())) {
            appId = this.tianXiaoJiaAppId;
        } else {
            try {
                WechatApiValidator._4CallApi((AuthorizationInfo)authorizationInfo, (AuthorizerInfo)authorizerInfo, (WechatApi)WechatApi.USER_WEBAUTH);
                appId = authorizationInfo.getAuthorizerAppId();
            }
            catch (Exception e) {
                log.warn("orgId:{}, bind wechat no webauth permission. try to use tianxiaojia exception:{}", (Object)orgAccount.getId(), (Object)e);
                appId = this.tianXiaoJiaAppId;
            }
        }
        String lessonLiveUrl = PropertiesReader.getValue((String)"config", (String)"lesson_live_url");
        String redirectUrl = lessonLiveUrl.replace("{orgNumber}", orgAccount.getNumber().toString()).replace("{lessonId}", lessonId.toString());
        log.info("redirectUrl is:{} ", (Object)redirectUrl);
        return WechatWebAuthLinkBuilder.fansinfo((WebAuthScope)WebAuthScope.BASE, (String)appId, (String)redirectUrl);
    }

    @Override
    public List<TxVZhiBoLessonListVO> list(Integer roomId, Integer ownerId, Integer ownerType, Integer status, Integer hidden, String key, ListRequestDto pageDto, boolean all) {
        log.info("[list]roomId:{},ownerId:{},pageDto:{}, all:{}", new Object[]{roomId, ownerId, pageDto, all});
        List txVZhiBoLessons = null;
        txVZhiBoLessons = all ? this.txVZhiBoLessonDao.list(roomId, null, null, status, hidden, key, pageDto.getLastId(), pageDto.getPageSize()) : this.txVZhiBoLessonDao.list(roomId, ownerId, ownerType, status, hidden, key, pageDto.getLastId(), pageDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)txVZhiBoLessons)) {
            return Lists.newArrayList();
        }
        return this.buildTxVZhiBoLessonListVO(txVZhiBoLessons, roomId, ownerId, ownerType);
    }

    private List<TxVZhiBoLessonListVO> buildTxVZhiBoLessonListVO(List<TxVZhiBoLesson> txVZhiBoLessons, Integer roomId, Integer ownerId, Integer ownerType) {
        List cascadeIdList = Lists.transform(txVZhiBoLessons, (Function)new Function<TxVZhiBoLesson, Integer>(){

            public Integer apply(TxVZhiBoLesson input) {
                if (OwnerTypeEnums.CASCADE_ACCOUNT.getCode() == input.getOwnerType().intValue()) {
                    return input.getOwnerId();
                }
                return null;
            }
        });
        Map teacherNameMap = this.txCascadeCredentialService.getNameMapByAccountIds((Collection)cascadeIdList);
        Map<Integer, Integer> studentStat = this.txVZhiBoLessonStudentService.statStudentCountByRoomId(roomId);
        return this.buildTxVZhiBoLessonListVO(txVZhiBoLessons, studentStat, teacherNameMap, ownerId, ownerType);
    }

    private List<TxVZhiBoLessonListVO> buildTxVZhiBoLessonListVO(List<TxVZhiBoLesson> txVZhiBoLessons, Map<Integer, Integer> studentStat, Map<Integer, String> teacherNameMap, Integer ownerId, Integer ownerType) {
        ArrayList lessonListVOs = Lists.newArrayListWithExpectedSize((int)txVZhiBoLessons.size());
        for (TxVZhiBoLesson txVZhiBoLesson : txVZhiBoLessons) {
            TxVZhiBoLessonListVO txVZhiBoLessonListVO = new TxVZhiBoLessonListVO();
            lessonListVOs.add(txVZhiBoLessonListVO);
            txVZhiBoLessonListVO.setOrgId(txVZhiBoLesson.getOrgId());
            txVZhiBoLessonListVO.setOrgNumber(txVZhiBoLesson.getOrgNumber());
            txVZhiBoLessonListVO.setHidden(txVZhiBoLesson.getHidden());
            txVZhiBoLessonListVO.setId(txVZhiBoLesson.getId());
            txVZhiBoLessonListVO.setRoomId(txVZhiBoLesson.getRoomId().intValue());
            txVZhiBoLessonListVO.setName(txVZhiBoLesson.getName());
            if (txVZhiBoLesson.getStartTime() != null) {
                txVZhiBoLessonListVO.setStartTime(txVZhiBoLesson.getStartTime().getTime());
            }
            txVZhiBoLessonListVO.setCreateTime(txVZhiBoLesson.getCreateTime());
            txVZhiBoLessonListVO.setAvatar(txVZhiBoLesson.getAvatar());
            txVZhiBoLessonListVO.setDetailUrl(this.getDetailUrl(txVZhiBoLesson.getId()));
            String liveUrl = this.getLiveLessonUrl(txVZhiBoLesson.getOrgNumber(), txVZhiBoLesson.getId().intValue());
            txVZhiBoLessonListVO.setLiveUrl(liveUrl);
            txVZhiBoLessonListVO.setStatus(txVZhiBoLesson.getStatus());
            if (studentStat.containsKey(txVZhiBoLesson.getId().intValue())) {
                txVZhiBoLessonListVO.setStudentCount(studentStat.get(txVZhiBoLesson.getId().intValue()));
            }
            if (teacherNameMap.containsKey(txVZhiBoLesson.getOwnerId())) {
                txVZhiBoLessonListVO.setTeacherName(teacherNameMap.get(txVZhiBoLesson.getOwnerId()));
            } else {
                try {
                    OrgInfoSimpleDto simpleDto = (OrgInfoSimpleDto)this.orgInfoSimpleDtoCache.get((Object)txVZhiBoLesson.getOrgId());
                    txVZhiBoLessonListVO.setTeacherName(simpleDto.getShortName());
                }
                catch (Exception e) {
                    log.error("Error in Get OrgInfoSimpleDto", (Throwable)e);
                }
            }
            if (null == ownerId || null == ownerType || ownerId.intValue() != txVZhiBoLesson.getOwnerId().intValue() || ownerType.intValue() != txVZhiBoLesson.getOwnerType().intValue()) continue;
            txVZhiBoLessonListVO.setOwnType(TxVZhiBoLessonListTypeEnums.OWN.getCode());
        }
        return lessonListVOs;
    }

    @Override
    public List<TxVZhiBoLessonListVO> listOthers(Integer roomId, Integer ownerId, Integer ownerType, Integer status, Integer hidden, String key, ListRequestDto pageDto) {
        log.info("[listOthers]roomId:{},ownerId:{},pageDto:{}", new Object[]{roomId, ownerId, pageDto});
        List txVZhiBoLessons = this.txVZhiBoLessonDao.listOthers(roomId, ownerId, ownerType, status, hidden, key, pageDto.getLastId(), pageDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)txVZhiBoLessons)) {
            return Lists.newArrayList();
        }
        List<TxVZhiBoLessonListVO> boLessonListVOs = this.buildTxVZhiBoLessonListVO(txVZhiBoLessons, roomId, ownerId, ownerType);
        return boLessonListVOs;
    }

    private void initWithoutAuthLiveUrl(List<TxVZhiBoLessonListVO> boLessonListVOs) {
        for (TxVZhiBoLessonListVO lessonListVO : boLessonListVOs) {
            String lessonLiveUrl = PropertiesReader.getValue((String)"config", (String)"lesson_live_url");
            String liveUrl = lessonLiveUrl.replace("{orgNumber}", lessonListVO.getOrgNumber().toString()).replace("{lessonId}", lessonListVO.getId() + "");
            lessonListVO.setLiveUrl(liveUrl);
        }
    }

    @Override
    public Long create(Integer orgId, Integer txCascadeId, TxVZhiBoLesson txVZhiBoLesson) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        if (orgAccount == null) {
            return null;
        }
        txVZhiBoLesson.setOrgId(orgId);
        txVZhiBoLesson.setOrgNumber(orgAccount.getNumber());
        if (txCascadeId == null) {
            txVZhiBoLesson.setOwnerId(orgId);
            txVZhiBoLesson.setOwnerType(Integer.valueOf(OwnerTypeEnums.MAIN.getCode()));
        } else {
            txVZhiBoLesson.setOwnerId(txCascadeId);
            txVZhiBoLesson.setOwnerType(Integer.valueOf(OwnerTypeEnums.CASCADE_ACCOUNT.getCode()));
        }
        this.txVZhiBoLessonDao.save((Object)txVZhiBoLesson, new String[0]);
        try {
            MessageInfo messageInfo = this.initLessonMessage(txVZhiBoLesson.getId(), orgAccount);
            this.txVZhiBoMessageService.send(messageInfo, null);
        }
        catch (Exception e) {
            log.info("Error in \u521d\u59cb\u5316\u76f4\u64ad\u95f4\u6d88\u606f\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u521d\u59cb\u5316\u76f4\u64ad\u95f4\u6d88\u606f\u5931\u8d25!");
        }
        InviteCardTaskDto taskDto = new InviteCardTaskDto(Integer.valueOf(txVZhiBoLesson.getId().intValue()), "", Boolean.valueOf(false));
        this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
        return txVZhiBoLesson.getId();
    }

    private MessageInfo initLessonMessage(Long lessonId, OrgAccount orgAccount) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setAreaType(AreaTypeEnums.ZHIBO.getCode());
        messageInfo.setMsgType(MessageTypeEnums.TEXT.getCode());
        messageInfo.setLessonId(lessonId.intValue());
        messageInfo.setOrgId(orgAccount.getId());
        messageInfo.setContent(PropertiesReader.getValue((String)"config-common", (String)"lesson_init_msg"));
        return messageInfo;
    }

    @Override
    public long getExpireTime(Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        if (txVZhiBoLesson == null) {
            return -1L;
        }
        Calendar endTime = Calendar.getInstance();
        endTime.setTime(txVZhiBoLesson.getStartTime());
        endTime.add(5, Integer.parseInt(this.roomExpireTime));
        endTime.add(11, 2);
        Calendar currentTime = Calendar.getInstance();
        return endTime.getTimeInMillis() - currentTime.getTimeInMillis();
    }

    @Override
    public TxVZhiBoLesson getByOrgIdAndId(Integer orgId, int lessonId) {
        log.info("[getByOrgIdAndId]orgId:{},lessonId:{}", (Object)orgId, (Object)lessonId);
        return this.txVZhiBoLessonDao.getByOrgIdAndId(orgId, lessonId);
    }

    @Override
    public boolean end(Integer orgId, Integer txCascadeId, int lessonId) {
        int mod;
        TxVZhiBoLesson txVZhiBoLesson = this.getByOrgIdAndId(orgId, lessonId);
        if (txVZhiBoLesson != null && (mod = this.txVZhiBoLessonDao.updateColumnValueById((Serializable)Integer.valueOf(lessonId), "status", (Object)TxVZhiBoLessonStatusEnums.DONE.getCode())) > 0) {
            TxVZhiBoUserType userType = TxVZhiBoUserType.CASCADE_ACCOUNT;
            Integer uId = txCascadeId;
            if (txCascadeId == null) {
                uId = orgId;
                userType = TxVZhiBoUserType.JIGOU;
            }
            this.txVZhiBoMessageService.persistMessage(lessonId);
            this.txVZhiBoEventLogService.saveEvent(lessonId, uId, userType, TxVZhiBoEventType.SELF_EXIT);
            this.txVZhiBoMessageService.persistRecallAll(lessonId);
            this.removeMessageQuque(lessonId);
            txVZhiBoLesson.setStatus(Integer.valueOf(TxVZhiBoLessonStatusEnums.DONE.getCode()));
            this.lessonCache.put((Object)txVZhiBoLesson.getId().intValue(), (Object)txVZhiBoLesson);
            return true;
        }
        return false;
    }

    @Override
    public void removeMessageQuque(int lessonId) {
        this.redisTemplate.delete((Object)(AreaTypeEnums.ZHIBO.getPrefix() + lessonId));
        this.redisTemplate.delete((Object)(AreaTypeEnums.ZHIBO.getPrefix() + lessonId + this.MSG_QUEUE_POS));
        this.redisTemplate.delete((Object)(AreaTypeEnums.ZHIBO.getDeleteIndexListPrefix() + lessonId));
        this.redisTemplate.delete((Object)(AreaTypeEnums.ZHIBO.getDeleteIndexListPrefix() + lessonId + this.MSG_QUEUE_POS));
        this.redisTemplate.delete((Object)(AreaTypeEnums.DISCUSS.getPrefix() + lessonId));
        this.redisTemplate.delete((Object)(AreaTypeEnums.DISCUSS.getPrefix() + lessonId + this.MSG_QUEUE_POS));
        this.redisTemplate.delete((Object)(AreaTypeEnums.DISCUSS.getDeleteIndexListPrefix() + lessonId));
        this.redisTemplate.delete((Object)(AreaTypeEnums.DISCUSS.getDeleteIndexListPrefix() + lessonId + this.MSG_QUEUE_POS));
    }

    @Override
    public TxVZhiBoLesson getById(long lessonId) {
        log.info("[getById]id:{}", (Object)lessonId);
        return (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)Long.valueOf(lessonId), new String[0]);
    }

    @Override
    public int syncLessonStatus() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        log.info("[syncLessonStatus]currentTime:{}", (Object)calendar.getTime());
        calendar.add(5, -7);
        calendar.add(11, -2);
        log.info("[syncLessonStatus]time before:{}", (Object)calendar.getTime());
        return this.txVZhiBoLessonDao.syncLessonStatus(calendar.getTime(), TxVZhiBoLessonStatusEnums.DONE.getCode());
    }

    @Override
    public ShareDataVO getShareData(int lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)Integer.valueOf(lessonId), new String[0]);
        if (txVZhiBoLesson == null) {
            return null;
        }
        ShareDataVO shareDataVO = new ShareDataVO();
        shareDataVO.setTitle(txVZhiBoLesson.getName());
        shareDataVO.setImageUrl(txVZhiBoLesson.getAvatar());
        shareDataVO.setContent(txVZhiBoLesson.getDescription());
        String liveUrl = this.getLiveLessonUrl(txVZhiBoLesson.getOrgNumber(), lessonId);
        shareDataVO.setShareUrl(liveUrl);
        return shareDataVO;
    }

    @Override
    public ShareDataVO getShareData(int lessonId, long studentCount) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)Integer.valueOf(lessonId), new String[0]);
        if (txVZhiBoLesson == null) {
            return null;
        }
        ShareDataVO shareDataVO = new ShareDataVO();
        shareDataVO.setImageUrl(txVZhiBoLesson.getAvatar());
        shareDataVO.setContent(txVZhiBoLesson.getDescription());
        String liveUrl = this.getLiveLessonUrl(txVZhiBoLesson.getOrgNumber(), lessonId);
        shareDataVO.setShareUrl(liveUrl);
        if (txVZhiBoLesson.getStartTime().after(new Date())) {
            String dateStr = DateUtil.getStrByDateFormate((Date)txVZhiBoLesson.getStartTime(), (String)"M\u6708d\u65e5HH:mm");
            shareDataVO.setTitle(String.format(YET_START_SHARE_TITLE, txVZhiBoLesson.getName(), dateStr));
        } else if (studentCount < 5L) {
            shareDataVO.setTitle(String.format(ONGOING_FEW_PEOPLE_SHARE_TITLE, txVZhiBoLesson.getName()));
        } else {
            shareDataVO.setTitle(String.format(ONGOING_MANY_PEOPLE_SHARE_TITLE, txVZhiBoLesson.getName(), studentCount));
        }
        return shareDataVO;
    }

    @Override
    public LessonDetailVO getDetailById(Integer lessonId) throws BussinessException, NumberFormatException, Exception {
        String msgQuqueKey;
        TxVZhiBoLesson zhiBoLesson = this.getById(lessonId.intValue());
        if (zhiBoLesson == null) {
            return null;
        }
        if (zhiBoLesson.getStatus().intValue() == TxVZhiBoLessonStatusEnums.LIVE.getCode() && !this.redisTemplate.hasKey((Object)(msgQuqueKey = AreaTypeEnums.ZHIBO.getPrefix() + lessonId)).booleanValue()) {
            log.info("[getDetailById]lessonId:{} \u6d88\u606f\u961f\u5217\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86\uff0ckey:{}", (Object)lessonId, (Object)msgQuqueKey);
            zhiBoLesson.setStatus(Integer.valueOf(TxVZhiBoLessonStatusEnums.DONE.getCode()));
            this.txVZhiBoLessonDao.updateColumnValueById((Serializable)zhiBoLesson.getId(), "status", (Object)TxVZhiBoLessonStatusEnums.DONE.getCode());
        }
        return this.convert2DetailVO(zhiBoLesson);
    }

    private LessonDetailVO convert2DetailVO(TxVZhiBoLesson zhiBoLesson) throws BussinessException, NumberFormatException, Exception {
        LessonDetailVO lessonDetailVO = new LessonDetailVO();
        lessonDetailVO.setId(zhiBoLesson.getId());
        lessonDetailVO.setAvatar(zhiBoLesson.getAvatar());
        lessonDetailVO.setDescription(zhiBoLesson.getDescription());
        lessonDetailVO.setName(zhiBoLesson.getName());
        lessonDetailVO.setOrgNumber(zhiBoLesson.getOrgNumber());
        lessonDetailVO.setPassword(zhiBoLesson.getPassword());
        lessonDetailVO.setHidden(zhiBoLesson.getHidden());
        if (zhiBoLesson.getStartTime() != null) {
            lessonDetailVO.setStartTime(zhiBoLesson.getStartTime().getTime());
        }
        lessonDetailVO.setRoomId(zhiBoLesson.getRoomId());
        OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(Long.parseLong(zhiBoLesson.getOrgId().toString())));
        lessonDetailVO.setOrgName(orgInfo.getShortName());
        lessonDetailVO.setOrgAvatar(orgInfo.getLogo());
        if (orgInfo != null && OwnerTypeEnums.MAIN.getCode() == zhiBoLesson.getOwnerType().intValue()) {
            lessonDetailVO.setOrgName(orgInfo.getShortName());
            lessonDetailVO.setTeacherName(orgInfo.getShortName());
            lessonDetailVO.setTeacherAvatar(orgInfo.getLogo());
        } else {
            TxCascadeCredentialDto credentialDto = this.txCascadeCredentialService.getByTxCasCade(Long.valueOf(Long.parseLong(zhiBoLesson.getOrgId().toString())), zhiBoLesson.getOwnerId());
            if (credentialDto != null) {
                lessonDetailVO.setTeacherName(credentialDto.getName());
                if (StringUtils.isNotBlank((CharSequence)credentialDto.getAvatarUrl())) {
                    lessonDetailVO.setTeacherAvatar(credentialDto.getAvatarUrl());
                } else {
                    lessonDetailVO.setTeacherAvatar("https://imgs.genshuixue.com/21644918_xqjeiipb.png");
                }
            }
        }
        TxVZhiBoRoom txVZhiBoRoom = this.txVZhiBoRoomService.getById(zhiBoLesson.getRoomId());
        if (txVZhiBoRoom != null) {
            lessonDetailVO.setRoomName(StringUtils.isNotBlank((CharSequence)txVZhiBoRoom.getName()) ? txVZhiBoRoom.getName() : lessonDetailVO.getOrgName());
            lessonDetailVO.setRoomAvatar(StringUtils.isNotBlank((CharSequence)txVZhiBoRoom.getAvatar()) ? txVZhiBoRoom.getAvatar() : lessonDetailVO.getOrgAvatar());
        }
        lessonDetailVO.setStatus(zhiBoLesson.getStatus());
        String liveUrl = this.getLiveLessonUrl(zhiBoLesson.getOrgNumber(), zhiBoLesson.getId().intValue());
        lessonDetailVO.setLiveUrl(liveUrl);
        String roomUrl = this.ROOM_DETAIL_URL + zhiBoLesson.getOrgNumber();
        lessonDetailVO.setRoomUrl(roomUrl);
        ShareDataVO shareDataVO = new ShareDataVO();
        shareDataVO.setTitle(lessonDetailVO.getName());
        shareDataVO.setImageUrl(lessonDetailVO.getAvatar());
        shareDataVO.setContent(lessonDetailVO.getDescription());
        shareDataVO.setShareUrl(this.LESSON_DETAIL_URL + lessonDetailVO.getId());
        lessonDetailVO.setShareData(shareDataVO);
        List<AudienceDto> audienceList = this.audienceService.latestAudienceByCourseId(zhiBoLesson.getId().intValue(), zhiBoLesson.getOrgId(), 5);
        try {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(zhiBoLesson.getOrgId());
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(zhiBoLesson.getOrgId());
            WechatApiValidator._4CallApi((AuthorizationInfo)authorizationInfo, (AuthorizerInfo)authorizerInfo, (WechatApi)WechatApi.USER_WEBAUTH);
        }
        catch (Exception e) {
            log.info("lesson:{} find no auth wechat. no invite card! e:{}", (Object)zhiBoLesson, (Object)e.getMessage());
            lessonDetailVO.setCardStatus(InviteCardStatus.WECHAT_NO_AUTH.getCode());
            lessonDetailVO.setCardStatusStr(InviteCardStatus.WECHAT_NO_AUTH.getDesc());
        }
        lessonDetailVO.setAudienceNum(this.txVZhiBoLessonStudentService.getStudentCountbyLessonId(zhiBoLesson.getId().intValue()));
        lessonDetailVO.setAudienceList(audienceList);
        return lessonDetailVO;
    }

    @Override
    public int update(Integer orgId, FieldUpdateVO updateVO) {
        HashMap countCondition = Maps.newHashMap();
        countCondition.put("orgId", orgId);
        countCondition.put("id", updateVO.getId());
        int count = this.txVZhiBoLessonDao.countByCondition((Map)countCondition, "id", true);
        if (count < 1) {
            return -1;
        }
        TxVZhiBoLessonFieldEnums fieldEnums = TxVZhiBoLessonFieldEnums.parse(updateVO.getField());
        if (fieldEnums == null) {
            return -1;
        }
        HashMap updateCondtion = Maps.newHashMap();
        if (TxVZhiBoLessonFieldEnums.STARTTIME.equals((Object)fieldEnums)) {
            updateCondtion.put(fieldEnums.getName(), new Date(Long.parseLong(updateVO.getValue())));
        } else if (TxVZhiBoLessonFieldEnums.HIDDEN.equals((Object)fieldEnums)) {
            Preconditions.checkArgument((updateVO.getValue().toString().equals("1") || updateVO.getValue().equals("0") ? 1 : 0) != 0, (Object)"hidden\u5b57\u6bb5\u4f20\u503c\u9519\u8bef");
            updateCondtion.put(fieldEnums.getName(), updateVO.getValue());
        } else if (TxVZhiBoLessonFieldEnums.PASSWORD.equals((Object)fieldEnums)) {
            String newPwd = updateVO.getValue();
            Preconditions.checkArgument((null == newPwd || !StringUtils.containsWhitespace((CharSequence)newPwd) && (newPwd.length() == 6 || newPwd.length() == 0) ? 1 : 0) != 0, (Object)"\u8bf7\u8f93\u5165\u516d\u4f4d\u4e0d\u542b\u7a7a\u683c\u5bc6\u7801");
            updateCondtion.put(fieldEnums.getName(), updateVO.getValue());
        } else {
            updateCondtion.put(fieldEnums.getName(), updateVO.getValue());
        }
        ArrayList updateProps = Lists.newArrayList();
        updateProps.add(fieldEnums.getName());
        if (TxVZhiBoLessonFieldEnums.AVATAR.equals((Object)fieldEnums) && updateVO != null && updateVO.getExt() != null && NumberUtils.isDigits((String)updateVO.getExt())) {
            updateCondtion.put("storageId", updateVO.getExt());
            updateProps.add("storageId");
        }
        updateCondtion.put("id", updateVO.getId());
        int mod = this.txVZhiBoLessonDao.update((Map)updateCondtion, updateProps.toArray(new String[updateProps.size()]));
        if (mod > 0) {
            // empty if block
        }
        return mod;
    }

    private void refreshCache(FieldUpdateVO updateVO, TxVZhiBoLessonFieldEnums fieldEnums) {
    }

    @Override
    public Map<String, List<TxVZhiBoLessonListVO>> listAll(Integer roomId, Integer ownerId, int lessonListType, Integer hidden, String key, ListRequestDto pageDto) {
        List<TxVZhiBoLessonListVO> boLessonListVOs = null;
        if (TxVZhiBoLessonListTypeEnums.ALL.getCode() == lessonListType) {
            boLessonListVOs = this.list(roomId, null, null, TxVZhiBoLessonStatusEnums.ALL.getCode(), hidden, key, pageDto, true);
        } else if (TxVZhiBoLessonListTypeEnums.OWN.getCode() == lessonListType) {
            boLessonListVOs = this.list(roomId, ownerId, null, TxVZhiBoLessonStatusEnums.ALL.getCode(), hidden, key, pageDto, false);
        } else {
            boLessonListVOs = this.listOthers(roomId, ownerId, null, TxVZhiBoLessonStatusEnums.ALL.getCode(), hidden, key, pageDto);
            this.initWithoutAuthLiveUrl(boLessonListVOs);
        }
        if (CollectionUtils.isEmpty(boLessonListVOs)) {
            return Maps.newHashMap();
        }
        ArrayList liveList = Lists.newArrayListWithExpectedSize((int)boLessonListVOs.size());
        ArrayList doneList = Lists.newArrayListWithExpectedSize((int)boLessonListVOs.size());
        for (TxVZhiBoLessonListVO listVO : boLessonListVOs) {
            if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == listVO.getStatus()) {
                String msgQuqueKey = AreaTypeEnums.ZHIBO.getPrefix() + listVO.getId();
                if (DateUtil.getMinuteDiff((Date)new Date(), (Date)listVO.getCreateTime()) > 5 && !this.redisTemplate.hasKey((Object)msgQuqueKey).booleanValue()) {
                    log.info("[getDetailById]lessonId:{} \u6d88\u606f\u961f\u5217\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86\uff0ckey:{}", (Object)listVO.getId(), (Object)msgQuqueKey);
                    listVO.setStatus(TxVZhiBoLessonStatusEnums.DONE.getCode());
                    this.txVZhiBoLessonDao.updateColumnValueById((Serializable)Long.valueOf(listVO.getId()), "status", (Object)TxVZhiBoLessonStatusEnums.DONE.getCode());
                }
            }
            if (TxVZhiBoLessonStatusEnums.LIVE.getCode() == listVO.getStatus()) {
                liveList.add(listVO);
                continue;
            }
            doneList.add(listVO);
        }
        HashMap statusGroupedMap = Maps.newHashMap();
        statusGroupedMap.put("live", liveList);
        statusGroupedMap.put("done", doneList);
        return statusGroupedMap;
    }

    @Override
    public List<TxVZhiBoLessonListVO> listLessons(int lessonListType, Integer ownerId, Integer ownerType, Integer roomId, Integer hidden, Integer status, String key, ListRequestDto pageDto) {
        List<TxVZhiBoLessonListVO> boLessonListVOs = null;
        if (TxVZhiBoLessonListTypeEnums.ALL.getCode() == lessonListType) {
            boLessonListVOs = this.list(roomId, ownerId, ownerType, status, hidden, key, pageDto, true);
        } else if (TxVZhiBoLessonListTypeEnums.OWN.getCode() == lessonListType) {
            boLessonListVOs = this.list(roomId, ownerId, ownerType, status, hidden, key, pageDto, false);
        } else if (TxVZhiBoLessonListTypeEnums.OTHERS.getCode() == lessonListType) {
            boLessonListVOs = this.listOthers(roomId, ownerId, ownerType, status, hidden, key, pageDto);
        }
        this.initWithoutAuthLiveUrl(boLessonListVOs);
        return boLessonListVOs;
    }

    @Override
    public String getDetailUrl(Long id) {
        return this.LESSON_DETAIL_URL + id;
    }

    @Override
    public int checkLessonStatus(long lessonId) {
        TxVZhiBoLesson detailVO = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)Long.valueOf(lessonId), new String[0]);
        if (detailVO == null) {
            return TxVZhiBoLessonStatusEnums.DELETED.getCode();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(5, -7);
        calendar.add(11, -2);
        Date startTime = detailVO.getStartTime();
        if (startTime != null) {
            Long startT = startTime.getTime();
            if (startT > calendar.getTimeInMillis()) {
                return TxVZhiBoLessonStatusEnums.LIVE.getCode();
            }
            return TxVZhiBoLessonStatusEnums.DONE.getCode();
        }
        return TxVZhiBoLessonStatusEnums.DELETED.getCode();
    }

    @Override
    public boolean delete(Integer orgId, Integer txCascadeId, int lessonId) {
        TxVZhiBoLesson detailVO = this.txVZhiBoLessonDao.getByOrgIdAndId(orgId, lessonId);
        if (detailVO == null) {
            return false;
        }
        int mod = this.txVZhiBoLessonDao.updateColumnValueById((Serializable)Integer.valueOf(lessonId), "status", (Object)TxVZhiBoLessonStatusEnums.DELETED.getCode());
        return mod > 0;
    }

    @Override
    public Map<String, Integer> countByStatus(Integer roomId) {
        HashMap countCondition = Maps.newHashMap();
        countCondition.put("roomId", roomId);
        countCondition.put("hidden", Flag.FALSE.getInt());
        Map map = this.txVZhiBoLessonDao.groupCount((Map)countCondition, "id", "status", true, Integer.class);
        HashMap resultMap = Maps.newHashMap();
        if (map == null || map.size() == 0) {
            return resultMap;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((Integer)entry.getKey()).intValue() == TxVZhiBoLessonStatusEnums.LIVE.getCode()) {
                resultMap.put("live", entry.getValue());
                continue;
            }
            if (((Integer)entry.getKey()).intValue() != TxVZhiBoLessonStatusEnums.DONE.getCode()) continue;
            resultMap.put("done", entry.getValue());
        }
        return resultMap;
    }

    @Override
    public boolean checkLessonIsLiving(Integer lessonId) {
        try {
            TxVZhiBoLesson boLesson = (TxVZhiBoLesson)this.lessonCache.get((Object)lessonId);
            log.info("[send]boLesson:{}", (Object)boLesson);
            if (boLesson == null || TxVZhiBoLessonStatusEnums.DONE.getCode() == boLesson.getStatus().intValue() || TxVZhiBoLessonStatusEnums.DELETED.getCode() == boLesson.getStatus().intValue()) {
                log.info("[send]lesson status is illegel!");
                return false;
            }
        }
        catch (ExecutionException e) {
            log.error("Error In send msg", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public UserTypeEnums checkUserType(Integer lessonId, Integer orgId, Integer txCascadeId, String openId) {
        log.info("[checkUserType]lessonId:{},orgId:{},txCascadeId:{},openId:{}", new Object[]{lessonId, orgId, txCascadeId, openId});
        if (lessonId == null) {
            return UserTypeEnums.HACKER;
        }
        if (orgId == null && txCascadeId == null && StringUtils.isBlank((CharSequence)openId)) {
            return UserTypeEnums.HACKER;
        }
        if (orgId == null && txCascadeId == null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId})) {
            return UserTypeEnums.STUDENT;
        }
        TxVZhiBoLesson lesson = null;
        try {
            lesson = this.getById(new Long(lessonId.intValue()));
        }
        catch (Exception e) {
            log.info("Cann`t find lesson", (Throwable)e);
        }
        if (lesson == null) {
            return UserTypeEnums.HACKER;
        }
        if (lesson.getOrgId().equals(orgId)) {
            if (lesson.getOwnerType().intValue() == OwnerTypeEnums.MAIN.getCode()) {
                if (txCascadeId == null && orgId.intValue() == lesson.getOwnerId().intValue()) {
                    return UserTypeEnums.TEACHER;
                }
                return UserTypeEnums.OTHER_TEACHER;
            }
            if (lesson.getOwnerId().equals(txCascadeId)) {
                return UserTypeEnums.TEACHER;
            }
            return UserTypeEnums.OTHER_TEACHER;
        }
        if (null != orgId) {
            return UserTypeEnums.OTHER_TEACHER;
        }
        return UserTypeEnums.HACKER;
    }

    @Override
    public List<TxVZhiBoLesson> getByRoomId(Integer roomId) {
        if (roomId == null) {
            return Lists.newArrayList();
        }
        return this.txVZhiBoLessonDao.getByRoomId(roomId);
    }

    @Override
    public LessonDetailVO getOnlyDetailById(Integer lessonId) throws BussinessException, NumberFormatException, Exception {
        TxVZhiBoLesson zhiBoLesson = this.getById(lessonId.intValue());
        if (zhiBoLesson == null) {
            return null;
        }
        return this.convert2DetailVO(zhiBoLesson);
    }
}

