/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.vzhibo.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.vzhibo.constant.TxVZhiBoInviteeInviterType;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoInviteeDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoLessonStudentDao;
import com.baijia.tianxiao.dal.vzhibo.dao.TxVZhiBoRoomDao;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoInvitee;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLesson;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoLessonStudent;
import com.baijia.tianxiao.dal.vzhibo.po.TxVZhiBoRoom;
import com.baijia.tianxiao.dal.wechat.constant.QRCodeSceneBizType;
import com.baijia.tianxiao.dal.wechat.constant.WechatAppVerifyType;
import com.baijia.tianxiao.dal.wechat.dao.QRCodeSceneDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.QRCodeScene;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.RedisKeyEnums;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.redis.lock.RedisDistributeLock;
import com.baijia.tianxiao.redis.lock.RedisDistributeLockImpl;
import com.baijia.tianxiao.sal.common.dto.InviteCardTaskDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.vzhibo.constant.InviteCardStatus;
import com.baijia.tianxiao.sal.vzhibo.constant.OwnerTypeEnums;
import com.baijia.tianxiao.sal.vzhibo.service.AudienceService;
import com.baijia.tianxiao.sal.vzhibo.service.TxVZhiBoInviteCardService;
import com.baijia.tianxiao.sal.vzhibo.vo.AudienceDto;
import com.baijia.tianxiao.sal.vzhibo.vo.InviteCardInfoDto;
import com.baijia.tianxiao.sal.vzhibo.vo.TxVZhiBoInviteCardVO;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.qrcode.QRCodeDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.qrcode.WechatQRCodeLinkHelper;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class TxVZhiBoInviteCardServiceImpl
implements TxVZhiBoInviteCardService {
    private static final Logger log = LoggerFactory.getLogger(TxVZhiBoInviteCardServiceImpl.class);
    @Autowired
    private AudienceService audienceService;
    @Autowired
    private TxVZhiBoInviteeDao txVZhiBoInviteeDao;
    @Autowired
    private FansService fansService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TxVZhiBoLessonDao txVZhiBoLessonDao;
    @Autowired
    private TxVZhiBoRoomDao txVZhiBoRoomDao;
    @Autowired
    private QRCodeSceneDao qrCodeSceneDao;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private TxVZhiBoLessonStudentDao txVZhiBoLessonStudentDao;
    @Autowired
    private MessagePushService messagePushService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private RedisDistributeLock distributeLock;

    @PostConstruct
    public void postConstruct() {
        this.distributeLock = new RedisDistributeLockImpl(this.redisTemplate);
    }

    private QRCodeScene generateCardWeChatQrUrl(String openId, @NonNull Integer lessonId) {
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
        WechatApiValidator._4CallApi((AuthorizationInfo)authorizationInfo, (AuthorizerInfo)authorizerInfo, (WechatApi)WechatApi.USER_WEBAUTH);
        TxVZhiBoInviteeInviterType inviterType = null;
        Integer roleId = 0;
        String roleStr = "";
        if (StringUtils.isBlank((CharSequence)openId)) {
            if (OwnerTypeEnums.MAIN.getCode() == txVZhiBoLesson.getOwnerType().intValue()) {
                inviterType = TxVZhiBoInviteeInviterType.MASTER;
                roleId = txVZhiBoLesson.getOrgId();
            } else {
                inviterType = TxVZhiBoInviteeInviterType.CASCADE;
                roleId = txVZhiBoLesson.getOwnerId();
            }
        } else {
            inviterType = TxVZhiBoInviteeInviterType.AUDIENCE;
            roleStr = openId;
        }
        QRCodeScene scene = this.qrCodeSceneDao.getByAllParam(Integer.valueOf(QRCodeSceneBizType.VZHIBO_INVITECARD.getCode()), lessonId, Integer.valueOf(inviterType.getCode()), roleId, roleStr);
        if (null == scene) {
            scene = new QRCodeScene();
            scene.setBizType(Integer.valueOf(QRCodeSceneBizType.VZHIBO_INVITECARD.getCode()));
            scene.setBizId(lessonId);
            scene.setRoleType(Integer.valueOf(inviterType.getCode()));
            scene.setRoleId(roleId);
            scene.setRoleStr(roleStr);
            scene.setCreateTime(new Date());
            scene.setUpdateTime(scene.getCreateTime());
            this.qrCodeSceneDao.save((Object)scene, new String[0]);
        }
        QRCodeDto qrCodeDto = null;
        try {
            qrCodeDto = WechatQRCodeLinkHelper.getQRCodeDtoForOneMonth((String)authorizationInfo.getAuthorizerAccessToken(), (Long)txVZhiBoLesson.getOrgId().longValue(), (Long)scene.getId());
        }
        catch (WechatException e) {
            if (e.getErrorCode().equals(SalWechatErrorCode.WECHAT_PERMISSION_DENIED) || e.getErrorCode().equals(SalWechatErrorCode.WECHAT_AUTHORIZATION_DENIED)) {
                log.error("vzhibo generate invite card qrCode error:{}, update authorizerInfo:{} into NOT_VERIFY", (Object)e, (Object)authorizerInfo);
                authorizerInfo.setVerifyType(Integer.valueOf(WechatAppVerifyType.NOT_VERIFY.getValue()));
                this.authorizerInfoService.update(authorizerInfo);
            }
            throw e;
        }
        String base64Img = null;
        try {
            byte[] data = WechatQRCodeLinkHelper.downloadQRCodeImage((String)qrCodeDto.getTicket());
            BASE64Encoder encoder = new BASE64Encoder();
            base64Img = encoder.encode(data);
        }
        catch (Exception e) {
            log.error("get wechat qr code img error! e:{}", (Throwable)e);
        }
        scene.setBase64Img("data:image/jpg;base64," + base64Img);
        return scene;
    }

    @Override
    public TxVZhiBoInviteCardVO createNewInviteCard(String openId, @NonNull Integer lessonId) {
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        QRCodeScene qrCodeScene = this.generateCardWeChatQrUrl(openId, lessonId);
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        TxVZhiBoRoom txVZhiBoRoom = (TxVZhiBoRoom)this.txVZhiBoRoomDao.getById((Serializable)txVZhiBoLesson.getRoomId(), new String[0]);
        TxVZhiBoInviteCardVO txVZhiBoInviteCardVO = new TxVZhiBoInviteCardVO();
        txVZhiBoInviteCardVO.setQrCodeScene(qrCodeScene);
        txVZhiBoInviteCardVO.setDate(txVZhiBoLesson.getStartTime());
        txVZhiBoInviteCardVO.setCardTitle(txVZhiBoLesson.getName());
        txVZhiBoInviteCardVO.setBase64Img(qrCodeScene.getBase64Img());
        if (StringUtils.isNotEmpty((CharSequence)txVZhiBoRoom.getName())) {
            txVZhiBoInviteCardVO.setLocation(txVZhiBoRoom.getName());
        } else {
            OrgInfoSimpleDto orgInfo = this.orgInfoService.getMOrgInfo(Long.valueOf(txVZhiBoLesson.getOrgId().longValue()));
            txVZhiBoInviteCardVO.setLocation(orgInfo.getShortName());
        }
        if (StringUtils.isBlank((CharSequence)openId)) {
            if (txVZhiBoLesson.getOwnerType().intValue() == OwnerTypeEnums.CASCADE_ACCOUNT.getCode()) {
                TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)txVZhiBoLesson.getOwnerId(), new String[0]);
                TXCascadeCredential txCascadeCredential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                if (StringUtils.isNotBlank((CharSequence)txCascadeCredential.getAvatar())) {
                    txVZhiBoInviteCardVO.setInviterAvatar(txCascadeCredential.getAvatar());
                } else {
                    txVZhiBoInviteCardVO.setInviterAvatar("https://imgs.genshuixue.com/21644918_xqjeiipb.png");
                }
                txVZhiBoInviteCardVO.setInviterName(txCascadeCredential.getName());
            } else if (txVZhiBoLesson.getOwnerType().intValue() == OwnerTypeEnums.MAIN.getCode()) {
                OrgInfoSimpleDto infoSimpleDto = this.orgInfoService.getMOrgInfo(Long.valueOf(txVZhiBoLesson.getOrgId().longValue()));
                txVZhiBoInviteCardVO.setInviterAvatar(infoSimpleDto.getLogo());
                txVZhiBoInviteCardVO.setInviterName(infoSimpleDto.getContacts());
            }
        } else {
            Fans fans = this.fansService.getFans(openId);
            if (fans != null) {
                if (StringUtils.isBlank((CharSequence)fans.getHeadImgUrl())) {
                    txVZhiBoInviteCardVO.setInviterAvatar(fans.getHeadImgUrl());
                } else {
                    txVZhiBoInviteCardVO.setInviterAvatar(fans.getHeadImgUrl());
                }
                txVZhiBoInviteCardVO.setInviterName(fans.getNick());
            }
        }
        return txVZhiBoInviteCardVO;
    }

    @Override
    public InviteCardInfoDto getInviteCardInfoDto(String openId, Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        InviteCardInfoDto inviteCardInfoDto = new InviteCardInfoDto();
        try {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
            WechatApiValidator._4CallApi((AuthorizationInfo)authorizationInfo, (AuthorizerInfo)authorizerInfo, (WechatApi)WechatApi.USER_WEBAUTH);
        }
        catch (Exception e) {
            log.info("lesson:{} find no auth wechat. no invite card! e:{}", (Object)txVZhiBoLesson, (Object)e);
            inviteCardInfoDto.setCardStatus(InviteCardStatus.WECHAT_NO_AUTH.getCode());
            inviteCardInfoDto.setCardStatusStr(InviteCardStatus.WECHAT_NO_AUTH.getDesc());
            return inviteCardInfoDto;
        }
        InviteCardInfoDto.CardInfo cardInfo = new InviteCardInfoDto.CardInfo();
        cardInfo.setCardPageUrl(PropertiesReader.getValue((String)"tianxiao", (String)"vzhibo.url") + String.format("/invite/myCard.do?lessonId=%s", lessonId));
        TxVZhiBoInvitee maxNumInviter = this.txVZhiBoInviteeDao.getMaxInviteNumInviter(lessonId);
        log.debug("maxNumInviter:{}", (Object)maxNumInviter);
        if (null == maxNumInviter) {
            cardInfo.setInviteNum(0);
        } else {
            cardInfo.setInviteNum(maxNumInviter.getCount());
            if (TxVZhiBoInviteeInviterType.MASTER.getCode() == maxNumInviter.getInviterType().intValue()) {
                OrgInfoSimpleDto orgInfo = this.orgInfoService.getMOrgInfo(Long.valueOf(maxNumInviter.getInviterId().longValue()));
                cardInfo.setInviterName(orgInfo.getContacts());
            } else if (TxVZhiBoInviteeInviterType.CASCADE.getCode() == maxNumInviter.getInviterType().intValue()) {
                TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)maxNumInviter.getInviterId(), new String[]{"credentialId"});
                TXCascadeCredential cascadeCredential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[]{"name"});
                cardInfo.setInviterName(cascadeCredential.getName());
            } else {
                AudienceDto audienceDto = this.audienceService.getAudienceDetail(maxNumInviter.getInviterOpenId(), txVZhiBoLesson.getOrgNumber(), lessonId);
                cardInfo.setInviterName(audienceDto.getName());
            }
        }
        inviteCardInfoDto.setCardInfo(cardInfo);
        if (StringUtils.isBlank((CharSequence)openId)) {
            RedisDistributeLock.LockObject lockObject;
            if (StringUtils.isNotBlank((CharSequence)txVZhiBoLesson.getInvitePicUrl()) && txVZhiBoLesson.getInvitePicReady().intValue() == Flag.TRUE.getInt()) {
                return inviteCardInfoDto;
            }
            if (StringUtils.isBlank((CharSequence)txVZhiBoLesson.getInvitePicUrl()) && DateUtil.getMinuteDiff((Date)txVZhiBoLesson.getCreateTime(), (Date)new Date()) > 5 && null != (lockObject = this.distributeLock.lockFastFail(RedisKeyEnums.VZB.VZHIBO_REGENERATE_INVITE_CARD_LOCK.getRedisKey() + "_" + lessonId.toString(), 300000L))) {
                InviteCardTaskDto taskDto = new InviteCardTaskDto(lessonId, openId, Boolean.valueOf(false));
                this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
            }
        } else {
            RedisDistributeLock.LockObject lockObject;
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (null != txVZhiBoLessonStudent && StringUtils.isNotBlank((CharSequence)txVZhiBoLessonStudent.getInvitePicUrl()) && txVZhiBoLessonStudent.getInvitePicReady().intValue() == Flag.TRUE.getInt()) {
                return inviteCardInfoDto;
            }
            if (null != txVZhiBoLessonStudent && StringUtils.isBlank((CharSequence)txVZhiBoLessonStudent.getInvitePicUrl()) && DateUtil.getMinuteDiff((Date)txVZhiBoLessonStudent.getCreateTime(), (Date)new Date()) > 120 && null != (lockObject = this.distributeLock.lockFastFail(RedisKeyEnums.VZB.VZHIBO_REGENERATE_INVITE_CARD_LOCK.getRedisKey() + "_" + lessonId.toString() + "_" + openId, 300000L))) {
                InviteCardTaskDto taskDto = new InviteCardTaskDto(lessonId, openId, Boolean.valueOf(false));
                this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
            }
        }
        inviteCardInfoDto.setCardStatus(InviteCardStatus.CARD_GENERATING.getCode());
        inviteCardInfoDto.setCardStatusStr(InviteCardStatus.CARD_GENERATING.getDesc());
        return inviteCardInfoDto;
    }

    @Override
    public boolean canGenerateInviteCard(Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        try {
            AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
            AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
            WechatApiValidator._4CallApi((AuthorizationInfo)authorizationInfo, (AuthorizerInfo)authorizerInfo, (WechatApi)WechatApi.USER_WEBAUTH);
            return true;
        }
        catch (Exception e) {
            log.info("lesson:{} find no auth wechat. no invite card! e:{}", (Object)txVZhiBoLesson, (Object)e);
            return false;
        }
    }

    @Override
    public void updateInviteCardUrl(String openId, Integer lessonId, String url, Boolean sendWechatMsg) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        if (StringUtils.isEmpty((CharSequence)openId)) {
            txVZhiBoLesson.setInvitePicUrl(url);
            txVZhiBoLesson.setInvitePicReady(Integer.valueOf(Flag.TRUE.getInt()));
            this.txVZhiBoLessonDao.update((Object)txVZhiBoLesson, new String[]{"invitePicUrl", "invitePicReady"});
        } else {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (null != txVZhiBoLessonStudent) {
                txVZhiBoLessonStudent.setInvitePicUrl(url);
                txVZhiBoLessonStudent.setInvitePicReady(Integer.valueOf(Flag.TRUE.getInt()));
                this.txVZhiBoLessonStudentDao.update((Object)txVZhiBoLessonStudent, new String[]{"invitePicUrl", "invitePicReady"});
            }
            if (null != sendWechatMsg && sendWechatMsg.booleanValue()) {
                this.sendWechatPic(txVZhiBoLesson.getOrgId(), openId, url);
            }
        }
    }

    @Override
    public void reGenerateInviteCard(String openId, Integer lessonId) {
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(txVZhiBoLesson.getOrgId());
        AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(txVZhiBoLesson.getOrgId());
        WechatApiValidator._4CallApi((AuthorizationInfo)authorizationInfo, (AuthorizerInfo)authorizerInfo, (WechatApi)WechatApi.USER_WEBAUTH);
        RedisDistributeLock.LockObject lockObject = this.distributeLock.lockFastFail(RedisKeyEnums.VZB.VZHIBO_REGENERATE_INVITE_CARD_LOCK.getRedisKey() + "_" + lessonId.toString() + "_" + openId, 300000L);
        if (null == lockObject) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5982\u9700\u91cd\u65b0\u751f\u6210\u8bf75\u5206\u949f\u540e\u518d\u8bd5");
        }
        InviteCardTaskDto taskDto = new InviteCardTaskDto();
        if (StringUtils.isBlank((CharSequence)openId)) {
            if (txVZhiBoLesson.getInvitePicReady().intValue() == Flag.FALSE.getInt()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9080\u8bf7\u5361\u751f\u6210\u4e2d!");
            }
            taskDto.setLessonId(lessonId);
            this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
            txVZhiBoLesson.setInvitePicReady(Integer.valueOf(Flag.FALSE.getInt()));
            this.txVZhiBoLessonDao.update((Object)txVZhiBoLesson, new String[]{"invitePicReady"});
        } else {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (txVZhiBoLessonStudent.getInvitePicReady().intValue() == Flag.FALSE.getInt()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9080\u8bf7\u5361\u751f\u6210\u4e2d!");
            }
            taskDto.setOpenId(openId);
            taskDto.setLessonId(lessonId);
            this.redisTemplate.opsForList().rightPush((Object)RedisKeyEnums.VZB.VZHIBO_INVITE_CARD_TASK_QUEUE.getRedisKey(), (Object)taskDto.toJson());
            txVZhiBoLessonStudent.setInvitePicReady(Integer.valueOf(Flag.FALSE.getInt()));
            this.txVZhiBoLessonStudentDao.update((Object)txVZhiBoLessonStudent, new String[]{"invitePicReady"});
        }
    }

    @Override
    public String getInviteCardPicUrl(String openId, Integer lessonId) {
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            TxVZhiBoLessonStudent txVZhiBoLessonStudent = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            if (null == txVZhiBoLessonStudent) {
                TimeUnit.SECONDS.sleep(3L);
                txVZhiBoLessonStudent = this.txVZhiBoLessonStudentDao.getByOpenId(openId, lessonId);
            }
            return txVZhiBoLessonStudent.getInvitePicUrl();
        }
        TxVZhiBoLesson txVZhiBoLesson = (TxVZhiBoLesson)this.txVZhiBoLessonDao.getById((Serializable)lessonId, new String[0]);
        return txVZhiBoLesson.getInvitePicUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendWechatPic(Integer orgId, String openId, String picUrl) {
        File localFile;
        block8: {
            localFile = null;
            try {
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
                String accessToken = authorizationInfo.getAuthorizerAccessToken();
                byte[] data = null;
                if (StringUtils.isNotBlank((CharSequence)picUrl)) {
                    data = HttpClientUtils.download((String)picUrl);
                    localFile = LocalFileHelper.saveToLocal((byte[])data, (MIMEType)MIMEType.JPG);
                    TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia((String)accessToken, (MediaType)MediaType.IMAGE, (File)localFile);
                    CustomerServiceApiHelper.sendImageMsg((String)accessToken, (String)openId, (String)mediaApiDto.getMediaId());
                    if (localFile == null) return;
                    break block8;
                }
                log.info("error msg - url:{}", (Object)picUrl);
                if (localFile == null) return;
            }
            catch (Exception e) {
                log.warn("send wechat msg error! openId:{}, e:{}", (Object)openId, (Object)e);
                return;
            }
            LocalFileHelper.deleteFile((File)localFile);
            return;
        }
        LocalFileHelper.deleteFile((File)localFile);
        return;
        finally {
            if (localFile != null) {
                LocalFileHelper.deleteFile(localFile);
            }
        }
    }
}

